////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptString
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptString class provides a data entry prompt
//		for a character string value. It creates a widget
//		consisting of an optional variable name label, together
//		with the actual data entry field. The user can retrieve
//		the value from the class via the function "value", or
//		use a callback hook to receive updates when changes are made.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			callback	Callback called when enter pressed
//			clientData	Data passed to callback
//		setValue()		Set the string in the field
//		value()			Return the string in the field
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptString_h
#define _akPromptString_h
#ifdef __cplusplus

#include <std/string.h>
#include <Xm/Xm.h>
#include "akPrompt.h"

typedef void (*akPromptStringCB) (XtPointer clientData,string value);

class akPromptString : public akPrompt
{
	public:

		// Constructor

		akPromptString(Widget parent,
				char *name,
				string variable_name,
				akPromptStringCB callback=0,
				XtPointer clientData=0);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptString");}

		// Access functions

		virtual string	value(void);
		virtual void	setValue(string new_value);

	protected:

		// The user is responsible for deleting the string

		virtual void	changeCB(string field_string);

		akPromptStringCB	userCB;
		XtPointer		userClientData;
};

#endif
#endif
