////////////////////////////////////////////////////////////////////////////////
//
//	Class : akRadioBox
//
//	Author : Andy Jefferson
//
//	Description :
//		The akRadioBox class provides a radio box of options
//		of which the user can select one at any time.
//		It allows the user to extract the selected option no
//		as well as providing a callback hook to allow
//		dynamic notification of changes in selections.
//		The user controls the layout of the radio box options
//		by way of the 'num_columns' input item. The options
//		are always layed out in a rectangular grid. The
//		'num_columns' input item determines how many columns
//		there are. This means there will be 
//		(num_options/num_columns) rows.
//		Whenever an option is changed, the "callback" is
//		invoked - allowing dynamic response to a users input.
//		The "callback" is passed the "clientData" as well as
//		the option no that is selected (as "callData"). The
//		option no ranges from 0 to num_options-1.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			options		The options in the radio-box
//			num_options	Number of options
//			num_cols	Number of columns in the display
//			callback	Callback called when value changed
//			clientData	Data passed to callback
//		selected()		Returns option no that is selected
//		set()			Select an option.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akRadioBox_h
#define _akRadioBox_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include "akComponent.h"

class akRadioBox : public akComponent
{
	public:

		// Constructor

		akRadioBox(Widget parent,
			    char *name,
			    char *prompt,
			    char **options,
			    int num_options,
			    int num_columns=1,
			    XtCallbackProc callback=(XtCallbackProc)0,
			    XtPointer clientData=(XtPointer)0);

		// Access functions

		void	set(int option_no);	// Select the option
		int	selected(void);		// Which option is selected ?

		// Class name

		virtual const char *const className(void)
			{return ("akRadioBox");}

	private:

		Widget		_radioBox;
		int		_numOptions;
		Widget		optionWidget(int option_no);

		static	void	changeCB(Widget,XtPointer,XtPointer);

		XtCallbackProc	_userCB;
		XtPointer	_userData;
};

#endif
#endif
