////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxFtp
//
//	Author : Andy Jefferson
//
//	Description :
//		mxFtp is the main window class for the mxFtp application.
//		It controls the cpnnection to and options used within the
//		Ftp session.
//
//	Public Methods :
//		(Constructor) requires :-
//			name		Name used for resource specification.
//
//	Limitations :
//		Linked in with mxSetup item, so relies on there being a global
//		mxSetup object.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxFtp_h
#define mxFtp_h
#ifdef __cplusplus

#include <vector.h>
#include <std/string.h>
#include <bool.h>
#include "akWindow.h"
#include "akLabel.h"
#include "akClock.h"
#include "akButton.h"
#include "akPixmap.h"
#include "akDocView.h"
#include "akProcess.h"
#include "akSound.h"
#include "akMessageArea.h"
#include "akMessageDialog.h"
#include "akPromptDialog.h"
#include "akPromptString.h"
#include "akPromptPassword.h"
#include "akRadioBox.h"
#include "akComboBox.h"
#include "akCopyright.h"
#include "mxFtpMonitor.h"
#include "mxDirView.h"

class mxFtp : public akWindow
{
	public:

		// Constructor,destructor

		mxFtp(char *name,
		      XtCallbackProc callback=0,
		      XtPointer clientData=0);
		~mxFtp();

	private:

		// Data used within Ftp process

		akProcess		*_ftpProcess;
		bool			_connectCmd;
		bool			_loginCmd;
		bool			_defaultDirCmd;
		bool			_cdCmd;
		bool			_pwdCmd;
		bool			_lsCmd;
		bool			_putCmd;
		bool			_getCmd;
		bool			_mkdirCmd;
		bool			_rmdirCmd;
		string			_outputText;

		vector<string>		_transferFilesLocal;
		vector<string>		_transferFilesRemote;
		int			_transferFileNo;

		akPixmap		*_logoPixmaps[12];
		XtIntervalId		_animationId;
		int			_animateLogoNo;

		XtCallbackProc		_userCB;
		XtPointer		_userData;

		// Panel widgets/methods

		Widget			createWorkArea(Widget parent);
		Widget			createMenuBar(Widget parent);
		Widget			createToolBar(Widget parent);
		akLabel			*_applicationLogo;
		akMessageArea		*_message;
		akDocView		*_helpDocument;
		akClock			*_date;
		akClock			*_time;
		akComboBox		*_hostField;
		akPromptString		*_loginField;
		akPromptPassword	*_passwordField;
		akButton		*_connectOption;
		akButton		*_disconnectOption;
		akButton		*_setupOption;
		akButton		*_helpOption;
		akButton		*_copyrightOption;
		akButton		*_quitOption;
		akButton		*_connectButton;
		akButton		*_disconnectButton;
		akButton		*_addSiteButton;
		akButton		*_setupButton;
		akButton		*_helpButton;
		akButton		*_quitButton;
		akButton		*_copyToLocalButton;
		akButton		*_copyToRemoteButton;
		akButton		*_localChgDirButton;
		akButton		*_localMkDirButton;
		akButton		*_localRemoveButton;
		akButton		*_remoteChgDirButton;
		akButton		*_remoteMkDirButton;
		akButton		*_remoteRemoveButton;
		akCopyright		*_copyright;
		akSound			*_transferCompleteSound;
		akRadioBox		*_transferTypeField;
		mxDirView		*_localSystem;
		mxDirView		*_remoteSystem;
		mxFtpMonitor		*_transferMonitor;
		akPromptDialog		*_promptDialog;
		akMessageDialog		*_quitDialog;

		// Utility functions

		string	localLsListing(string directory);
		void	setState();
		bool	transferNextFile();

		// Function callbacks

		static	void	connectCB(Widget,XtPointer,XtPointer);
		static	void	disconnectCB(Widget,XtPointer,XtPointer);
		static	void	addSiteCB(Widget,XtPointer,XtPointer);
		static	void	setupCB(Widget,XtPointer,XtPointer);
		static	void	helpCB(Widget,XtPointer,XtPointer);
		static	void	copyrightCB(Widget,XtPointer,XtPointer);
		static	void	quitCB(Widget,XtPointer,XtPointer);
		static	void	quitOK(XtPointer,XtPointer);
		static	void	quitCancel(XtPointer,XtPointer);
		static	void	copyToLocalCB(Widget,XtPointer,XtPointer);
		static	void	copyToRemoteCB(Widget,XtPointer,XtPointer);
		static	void	transferTypeChangedCB(Widget,XtPointer,XtPointer);
		static	void	localChgDirCB(Widget,XtPointer,XtPointer);
		static	void	localMkDirCB(Widget,XtPointer,XtPointer);
		static	void	localRemoveCB(Widget,XtPointer,XtPointer);
		static	void	remoteChgDirCB(Widget,XtPointer,XtPointer);
		static	void	remoteMkDirCB(Widget,XtPointer,XtPointer);
		static	void	remoteRemoveCB(Widget,XtPointer,XtPointer);

		static	void	localChgDirOK(XtPointer,XtPointer);
		static	void	localMkDirOK(XtPointer,XtPointer);
		static	void	localRemoveOK(XtPointer,XtPointer);
		static	void	remoteChgDirOK(XtPointer,XtPointer);
		static	void	remoteMkDirOK(XtPointer,XtPointer);
		static	void	remoteRemoveOK(XtPointer,XtPointer);
		static	void	dummyCB(XtPointer,XtPointer);
		static	void	setupChangedCB(Widget,XtPointer,XtPointer);
		static	void	localDirChangedCB(XtPointer,string);
		static	void	remoteDirChangedCB(XtPointer,string);
		static	void	receiveOutput(XtPointer,string);
		static	void	animateLogoCB(XtPointer,XtIntervalId*);
};

#endif
#endif
