#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>
#include <fstream.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>

#include "mxMailAttachmentSpecify.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailAttachmentSpecify::mxMailAttachmentSpecify(Widget parent,
						 char *name,
						 XtCallbackProc callback,
						 XtPointer clientData)
	:akDialog(name),
	 _userCB(callback),
	 _userData(clientData),
	 _callbackStruct((mxMailAttachCallbackStruct *)0)
{
	initialize(parent,
		   (XtPointer)this,
		   "OK",
		   &mxMailAttachmentSpecify::okCB,
		   "Cancel",
		   &mxMailAttachmentSpecify::cancelCB);

	_callbackStruct = new mxMailAttachCallbackStruct;

	setTitle("File Attachment Specification");
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailAttachmentSpecify::~mxMailAttachmentSpecify()
{
	if (_callbackStruct)
	  delete _callbackStruct;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Create Work Area
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMailAttachmentSpecify::createWorkArea(Widget parent)
{
	Widget			form;
	char		*options[]=
			{
			"Include in message (quoted)",
			"Include in message (as text)",
			"Attach as file"
			};

//	Create form to attach contents to

	form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,parent,0);

//	Add filename selection prompt

	_filenameField =
	  new akPromptFile(form,"FilePrompt","Filename");
	XtVaSetValues(_filenameField->baseWidget(),
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      NULL);
	_filenameField->manage();

//	Add file attachment mode prompt

	_attachmentModeField =
	  new akRadioBox(form,"AttachmentMode","Mode of Attachment",
			 options,XtNumber(options));
	XtVaSetValues(_attachmentModeField->baseWidget(),
		      XmNtopAttachment,XmATTACH_WIDGET,
		      XmNtopWidget,_filenameField->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      NULL);
	_attachmentModeField->manage();
	_attachmentModeField->set(2);

//	Add file attachment mode prompt

	_attachmentTypeField =
	  new akOptionMenu(form,"AttachmentType","File Type");
	_attachmentTypeField->add("Text");
	_attachmentTypeField->add("Image");
	_attachmentTypeField->add("Audio");
	_attachmentTypeField->add("Video");
	_attachmentTypeField->add("Application");
	_attachmentTypeField->manage();
	XtVaSetValues(_attachmentTypeField->baseWidget(),
		      XmNbottomAttachment,XmATTACH_FORM,
		      XmNtopAttachment,XmATTACH_WIDGET,
		      XmNtopWidget,_attachmentModeField->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      NULL);

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	okCB - remove the panel and pass back data (autoUnmanage removes it)
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailAttachmentSpecify::okCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAttachmentSpecify	*obj = (mxMailAttachmentSpecify *)clientData;
	string	filename=obj->_filenameField->value();

//	Check if file exists first

	ifstream	infile((char *)filename.c_str(),ios::nocreate);
	if (!infile)
	  {
	   XBell(XtDisplay(obj->_w),50);
	   return;
	  }
	infile.close();

//	Set up callback struct

	obj->_callbackStruct->filename = filename;
	obj->_callbackStruct->method = obj->_attachmentModeField->selected();
	if (obj->_attachmentTypeField->selectedOption() == "Text")
	  {
	   obj->_callbackStruct->type = MX_FILE;
	   obj->_callbackStruct->subtype = "plain";
	  }
	else if (obj->_attachmentTypeField->selectedOption() == "Image")
	  {
	   obj->_callbackStruct->type = MX_IMAGE;
	   obj->_callbackStruct->subtype = "unknown";
	  }
	else if (obj->_attachmentTypeField->selectedOption() == "Audio")
	  {
	   obj->_callbackStruct->type = MX_AUDIO;
	   obj->_callbackStruct->subtype = "unknown";
	  }
	else if (obj->_attachmentTypeField->selectedOption() == "Video")
	  {
	   obj->_callbackStruct->type = MX_VIDEO;
	   obj->_callbackStruct->subtype = "unknown";
	  }
	else if (obj->_attachmentTypeField->selectedOption() == "Application")
	  {
	   obj->_callbackStruct->type = MX_APPLICATION;
	   obj->_callbackStruct->subtype = "unknown";
	  }

//	Pass to users callback

	if (obj->_userCB)
	  obj->_userCB(obj->_w,obj->_userData,(XtPointer)obj->_callbackStruct);
}
////////////////////////////////////////////////////////////////////////////////
//
//	cancelCB - remove the panel (autoUnmanage removes it)
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailAttachmentSpecify::cancelCB(Widget,XtPointer,XtPointer)
{
//	Empty
}
