#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/ScrolledW.h>
#include <Xm/Separator.h>

#include "akApp.h"
#include "mxNet.h"
#include "mxSetup.h"
#include "mxSetupModify.h"

#include "mxNetLogo.xpm"
#include "mxNetIcon.xpm"
#include "mxButtons.xpm"
#include "ajSoft.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxNet::mxNet(char *name)
	:akWindow(name),
	 _connected(FALSE),
	 _connectionProcess((akProcess *)0),
	 _applicationLogo((akLabel *)0),
	 _helpDocument((akDocView *)0),
	 _date((akClock *)0),
	 _time((akClock *)0),
	 _message((akMessageArea *)0),
	 _connectOption((akButton *)0),
	 _disconnectOption((akButton *)0),
	 _helpOption((akButton *)0),
	 _copyrightOption((akButton *)0),
	 _wwwOption((akButton *)0),
	 _mailOption((akButton *)0),
	 _ftpOption((akButton *)0),
	 _newsOption((akButton *)0),
	 _connectButton((akButton *)0),
	 _disconnectButton((akButton *)0),
	 _setupButton((akButton *)0),
	 _quitButton((akButton *)0),
	 _helpButton((akButton *)0),
	 _wwwButton((akButton *)0),
	 _mailButton((akButton *)0),
	 _ftpButton((akButton *)0),
	 _newsButton((akButton *)0),
	 _quitDialog((akMessageDialog *)0),
	 _copyright((akCopyright *)0),
	 _mailWindow((mxMail *)0),
	 _ftpWindow((mxFtp *)0)
{
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxNet::~mxNet()
{
	if (_connected)
	  {
	  }
	if (_connectionProcess)
	  delete _connectionProcess;
	if (_applicationLogo)
	  delete _applicationLogo;
	if (_message)
	  delete _message;
	if (_helpDocument)
	  delete _helpDocument;
	if (_connectOption)
	  delete _connectOption;
	if (_disconnectOption)
	  delete _disconnectOption;
	if (_helpOption)
	  delete _helpOption;
	if (_copyrightOption)
	  delete _copyrightOption;
	if (_quitOption)
	  delete _quitOption;
	if (_wwwOption)
	  delete _wwwOption;
	if (_ftpOption)
	  delete _ftpOption;
	if (_mailOption)
	  delete _mailOption;
	if (_newsOption)
	  delete _newsOption;
	if (_connectButton)
	  delete _connectButton;
	if (_disconnectButton)
	  delete _disconnectButton;
	if (_setupButton)
	  delete _setupButton;
	if (_helpButton)
	  delete _helpButton;
	if (_quitButton)
	  delete _quitButton;
	if (_wwwButton)
	  delete _wwwButton;
	if (_ftpButton)
	  delete _ftpButton;
	if (_mailButton)
	  delete _mailButton;
	if (_newsButton)
	  delete _newsButton;
	if (_quitDialog)
	  delete _quitDialog;
	if (_mailWindow)
	  delete _mailWindow;
	if (_ftpWindow)
	  delete _ftpWindow;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createWorkArea
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxNet::createWorkArea(Widget parent)
{
	Widget	form;
	Widget	menuBar;
	Widget	toolBar;
	Widget	infoBar;
	Widget	logo_frame;
	Widget	date_frame;
	Widget	time_frame;

//	Set the icon and title

	setIcon("mxNet",mxNetIcon_xpm);

	string	title;
	title  = "mxNet Version ";
	title += theAkApp->applicationVersion();
	setTitle(title);

//	Add a form to attach contents to

	form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,parent,0);

//	Add application logo

	logo_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					form,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNtopOffset,3,
				        XmNrightAttachment,XmATTACH_FORM,
				        XmNrightOffset,3,
				        0);
	_applicationLogo =
	  new akLabel(logo_frame,"Label",mxNetLogo_xpm);
	_applicationLogo->manage();

//	Add menu bar

	menuBar = createMenuBar(form);
	XtVaSetValues(menuBar,
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_WIDGET,
		      XmNrightWidget,logo_frame,
		      0);

//	Add tool bar

	toolBar = createToolBar(form);
	XtVaSetValues(toolBar,
		      XmNtopAttachment,XmATTACH_WIDGET,
		      XmNtopWidget,menuBar,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_WIDGET,
		      XmNrightWidget,logo_frame,
		      0);

//	Add the info bar

	infoBar =
		 XtVaCreateManagedWidget("InfoBar",
					xmFormWidgetClass,
					form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					0);
	date_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					infoBar,
				        XmNleftAttachment,XmATTACH_FORM,
				        XmNleftOffset,3,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNtopOffset,3,
				        XmNbottomAttachment,XmATTACH_FORM,
				        XmNbottomOffset,3,
				        0);
	_date = new akClock(date_frame,"Date",DATE);
	_date->manage();
	time_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					infoBar,
				        XmNrightAttachment,XmATTACH_FORM,
				        XmNrightOffset,3,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNtopOffset,3,
				        XmNbottomAttachment,XmATTACH_FORM,
				        XmNbottomOffset,3,
				        0);
	_time = new akClock(time_frame,"Time",TIME);
	_time->manage();

//	Add Net messages area

	_message =
	  new akMessageArea(form,"MessageArea");
	XtVaSetValues(_message->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      XmNtopAttachment,XmATTACH_WIDGET,
		      XmNtopWidget,toolBar,
		      XmNbottomAttachment,XmATTACH_WIDGET,
		      XmNbottomWidget,infoBar,
		      0);
	_message->manage();

	_disconnectButton->deactivate();

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createMenuBar
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxNet::createMenuBar(Widget parent)
{
	Widget	menu;
	Widget	pulldown;
	Widget	cascade;

	menu = XmCreateMenuBar(parent,"MenuBar",NULL,0);

//	Create Connection menu

	pulldown = XmCreatePulldownMenu(menu,"Connection",NULL,0);
	_connectOption =
	  new akButton(pulldown,"Connect","Connect",
		       &mxNet::connectCB,(XtPointer)this);
	_connectOption->manage();

	_disconnectOption =
	  new akButton(pulldown,"Disconnect","Disconnect",
		       &mxNet::disconnectCB,(XtPointer)this);
	_disconnectOption->manage();
	_disconnectOption->deactivate();

	XtVaCreateManagedWidget("Sep",xmSeparatorWidgetClass,pulldown,0);
	_quitOption =
	  new akButton(pulldown,"Quit","Quit",
		       &mxNet::quitCB,(XtPointer)this);
	_quitOption->manage();
	cascade =
		XtVaCreateManagedWidget("Connection",
					xmCascadeButtonWidgetClass,
					menu,
					XmNsubMenuId,pulldown,
					0);

//	Create Applications menu

	pulldown = XmCreatePulldownMenu(menu,"Applications",NULL,0);
	_wwwOption =
	  new akButton(pulldown,"WWW","WWW",
		       &mxNet::wwwCB,(XtPointer)this);
	_wwwOption->manage();

	_ftpOption =
	  new akButton(pulldown,"FTP","FTP",
		       &mxNet::ftpCB,(XtPointer)this);
	_ftpOption->manage();

	_mailOption =
	  new akButton(pulldown,"Mail","Mail",
		       &mxNet::mailCB,(XtPointer)this);
	_mailOption->manage();

	_newsOption =
	  new akButton(pulldown,"News","News",
		       &mxNet::newsCB,(XtPointer)this);
	_newsOption->manage();
	cascade =
		XtVaCreateManagedWidget("Applications",
					xmCascadeButtonWidgetClass,
					menu,
					XmNsubMenuId,pulldown,
					0);

//	Create Help menu

	pulldown = XmCreatePulldownMenu(menu,"Help",NULL,0);
	_setupOption =
	  new akButton(pulldown,"Setup","Setup",
		       &mxNet::setupCB,(XtPointer)this);
	_setupOption->manage();

	_helpOption =
	  new akButton(pulldown,"Help","Help",
		       &mxNet::helpCB,(XtPointer)this);
	_helpOption->manage();

	_copyrightOption =
	  new akButton(pulldown,"Copyright","Copyright",
		       &mxNet::copyrightCB,(XtPointer)this);
	_copyrightOption->manage();

	cascade =
		XtVaCreateManagedWidget("Help",
					xmCascadeButtonWidgetClass,
					menu,
					XmNsubMenuId,pulldown,
					0);

	XtVaSetValues(menu,XmNmenuHelpWidget,cascade,0);
	XtManageChild(menu);

	return menu;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createToolBar
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxNet::createToolBar(Widget parent)
{
	Widget	rowcol;

	rowcol =
		XtVaCreateManagedWidget("ToolBar",
					xmRowColumnWidgetClass,
					parent,
					XmNorientation,XmHORIZONTAL,
					XmNadjustLast,FALSE,
					0);

	_quitButton =
	  new akButton(rowcol,"Close",mxClose_xpm,
		       &mxNet::quitCB,(XtPointer)this);
	_quitButton->installHelp("Quit mxNet");
	_quitButton->manage();

	_connectButton =
	  new akButton(rowcol,"Connect",mxConnect_xpm,
		       &mxNet::connectCB,(XtPointer)this);
	_connectButton->installHelp("Connect to the Internet");
	_connectButton->manage();

	_disconnectButton =
	  new akButton(rowcol,"Disconnect",mxDisconnect_xpm,
		       &mxNet::disconnectCB,(XtPointer)this);
	_disconnectButton->installHelp("Disconnect from the Internet");
	_disconnectButton->manage();

	_wwwButton =
	  new akButton(rowcol,"WWW",mxWWW_xpm,
		       &mxNet::wwwCB,(XtPointer)this);
	_wwwButton->installHelp("World-Wide-Web");
	_wwwButton->manage();

	_ftpButton =
	  new akButton(rowcol,"FTP","FTP",
		       &mxNet::ftpCB,(XtPointer)this);
	_ftpButton->installHelp("File-Transfer-Protocol");
	_ftpButton->manage();

	_mailButton =
	  new akButton(rowcol,"Mail","Mail",
		       &mxNet::mailCB,(XtPointer)this);
	_mailButton->installHelp("mxMail");
	_mailButton->manage();

	_newsButton =
	  new akButton(rowcol,"News","News",
		       &mxNet::newsCB,(XtPointer)this);
	_newsButton->installHelp("News");
	_newsButton->manage();

	_setupButton =
	  new akButton(rowcol,"Setup",mxSetup_xpm,
		       &mxNet::setupCB,(XtPointer)this);
	_setupButton->installHelp("View/Modify setup details");
	_setupButton->manage();

	_helpButton =
	  new akButton(rowcol,"Help",mxHelp_xpm,
		       &mxNet::helpCB,(XtPointer)this);
	_helpButton->installHelp("View the help");
	_helpButton->manage();

	return rowcol;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Connect callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::connectCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;
	string	dipfile;
	string	command;

	if (obj->_connected)
	  return;

	obj->busy();

//	Create DIP connection script

	time_t	the_time;
	tm	*t;
	char	tempfile[50];
	time(&the_time);
	t = localtime(&the_time);
	strftime(tempfile,50,"mxDIP_%d%m%y.%H%M%S.dip",t);
	obj->_dipConnectFile = theMxSetup->tempDirectory() + tempfile;
	if (!obj->createConnectScript(obj->_dipConnectFile))
	  {
	   XBell(XtDisplay(obj->_w),50);
	   obj->ready();
	   return;
	  }

//	Start the DIP process

	if (!obj->_connectionProcess)
	  obj->_connectionProcess = new akProcess;
	command = "/sbin/dip " + obj->_dipConnectFile;
	obj->_connectButton->deactivate();
	obj->_message->write(AK_INFO,"Attempting to connect to %s Internet. Please wait ...\n",
			     theMxSetup->supplierName().c_str());
	obj->_connectionProcess->start(command,
				       &mxNet::connectProcessOutput,
				       (XtPointer)obj);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Connect Process Output
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::connectProcessOutput(XtPointer clientData,string output)
{
	mxNet	*obj = (mxNet *)clientData;

	obj->_dipConnectText += output;

//	Connecting

	if (!obj->_connected)
	  {
	   // Successful connection
	   if ((int)obj->_dipConnectText.find("Dial-up and logon SUCCESSFUL") >= 0)
	     {
	      unlink((char *)obj->_dipConnectFile.c_str());
	      obj->_connected = TRUE;
	      obj->_connectButton->deactivate();
	      obj->_disconnectButton->activate();
	      obj->_dipConnectText.remove();
	      obj->ready();

	      // Will need to check on the PPP process (pppd) existence here
//	      obj->_message->write(AK_INFO,"PPP Connection established\n");
	     }

	   // Failure in connection
	   if ((int)obj->_dipConnectText.find("Dial-up and logon FAILED") >= 0 ||
	       (int)obj->_dipConnectText.find("problems with locking ") >= 0 ||
	       (int)obj->_dipConnectText.find("dip failed with exit code") >= 0)
	     {
	      unlink((char *)obj->_dipConnectFile.c_str());
	      obj->_connected = FALSE;
	      obj->_connectButton->activate();
	      obj->_disconnectButton->deactivate();
	      obj->_dipConnectText.remove();
	      obj->ready();
	     }
	  }

//	Disconnecting

	else
	  {
	   // Successful disconnection
	   if ((int)obj->_dipConnectText.find(" killed.") >= 0 ||
	       (int)obj->_dipConnectText.find("DIP: cannot open /etc/dip/pid: No such file or directory") >= 0)
	     {
	      obj->_connected = FALSE;
	      obj->_connectButton->activate();
	      obj->_disconnectButton->deactivate();
	      obj->_dipConnectText.remove();
	      sleep(2);	// Temporary code - really ought to check the device itself here
	      obj->_message->write(AK_INFO,"Phone hangup completed\n");
	      output.remove();
	      obj->ready();
	     }
	  }

//	Remove any carriage returns and output to message area

	int	pos = 0;
	while ((pos = output.find("
",pos)) >= 0)
	  output.remove(pos,1);
	obj->_message->write(AK_CONTINUE,(char *)output.c_str());
}
////////////////////////////////////////////////////////////////////////////////
//
//	Disconnect callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::disconnectCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;
	string	command;

	if (!obj->_connected)
	  return;

	obj->busy();

//	Stop the DIP process

	if (!obj->_connectionProcess)
	  obj->_connectionProcess = new akProcess;
	command = "/sbin/dip -k";
	obj->_message->write(AK_INFO,"Hanging up the phone. Please wait ...\n");
	obj->_connectionProcess->start(command,
				       &mxNet::connectProcessOutput,
				       (XtPointer)obj);
}
////////////////////////////////////////////////////////////////////////////////
//
//	WWW callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::wwwCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;
	string	command;

	obj->busy();
	command = theMxSetup->wwwCommand() + " &";
	system((char *)command.c_str());
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	FTP callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::ftpCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;

	obj->busy();
	if (!obj->_ftpWindow)
	  obj->_ftpWindow = new mxFtp("mxFTP",
				      &mxNet::ftpClosedCB,(XtPointer)obj);
	obj->_ftpWindow->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Ftp closed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::ftpClosedCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;

	obj->busy();
	obj->_ftpWindow->unmanage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Mail callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::mailCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;

	obj->busy();
	if (!obj->_mailWindow)
	  obj->_mailWindow = new mxMail("mxMail",
					&mxNet::mailClosedCB,(XtPointer)obj);
	obj->_mailWindow->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Mail closed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::mailClosedCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;

	obj->busy();
	obj->_mailWindow->unmanage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	News callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::newsCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;
	string	command;

	obj->busy();
	command = theMxSetup->newsCommand() + " &";
	system((char *)command.c_str());
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Setup callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::setupCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;

	obj->busy();
	if (!theMxSetupModify)
	  {
	   theMxSetupModify = new mxSetupModify(obj->_w,"SetupModify",
						&mxNet::setupChangedCB,
						(XtPointer)obj);
	   theMxSetupModify->update();
	   theMxSetupModify->manage();
	   theMxSetupModify->setSection(MXSETUP_NET);
	  }
	else
	  {
	   theMxSetupModify->update();
	   theMxSetupModify->manage();
	  }
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Setup changed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::setupChangedCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::quitCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;

	if (!obj->_quitDialog)
	  obj->_quitDialog = new akMessageDialog(obj->_w,"MessageDialog",
						    QUESTION,TRUE,
						    "Confirm Quit mxNet",
						    (XtPointer)obj,
						    &mxNet::quitOK,
						    &mxNet::quitCancel);
	obj->_quitDialog->setTitle("Confirm Quit");
	obj->_quitDialog->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::quitOK(XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;

	if (obj->_connected)
	  obj->_message->write(AK_ERROR,"Disconnect before exiting\n");
	else
	  exit(1);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit Cancel callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::quitCancel(XtPointer clientData,XtPointer)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Copyright callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::copyrightCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;

	obj->busy();
	if (!obj->_copyright)
	  obj->_copyright =
	    new akCopyright(theAkApp->baseWidget(),
			    "CopyrightPanel",
			    "AJ Soft Limited","1997",
			    ajSoft_xpm);
	obj->_copyright->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Help callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxNet::helpCB(Widget,XtPointer clientData,XtPointer)
{
	mxNet	*obj = (mxNet *)clientData;
	string	helpfile=theMxSetup->helpDirectory() + "mxNet.html";

	obj->busy();
	XmUpdateDisplay(obj->_w);
	if (!obj->_helpDocument)
	  obj->_helpDocument = new akDocView("HelpDocument",helpfile);
	obj->_helpDocument->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Create Connect (DIP) script
//
////////////////////////////////////////////////////////////////////////////////
bool	mxNet::createConnectScript(string filename)
{
	ofstream	outfile((char *)filename.c_str());
	if (!outfile)
	  return FALSE;

//	Set modem details

	outfile << "port ttyS" << theMxSetup->modemPort()-1 << endl;
	outfile << "speed " << theMxSetup->modemSpeed() << endl;
	outfile << "databits 8" << endl;
	outfile << "parity N" << endl;
	outfile << "stopbits 1" << endl;
	outfile << "echo off" << endl;	// Don't want echo since it screws up output
	outfile << "get $dial_no 0" << endl;
	outfile << "send " << theMxSetup->modemInit() << "\\r" << endl;
	outfile << "wait OK 3" << endl;
	outfile << "if $errlvl != 0 goto error1" << endl;

//	Dial section

	outfile << "dial:" << endl;
	outfile << "  inc $dial_no" << endl;
	outfile << "  if $dial_no == " << theMxSetup->modemNoRetries() << " goto error7" << endl;
	outfile << "  print Dialling " << theMxSetup->supplierPhoneNo() << endl;
	outfile << "  dial " << theMxSetup->supplierPhoneNo() << endl;
	outfile << "  if $errlvl == 0 goto error2" << endl;
	outfile << "  if $errlvl == 2 goto error2" << endl;
	outfile << "  if $errlvl == 4 goto busy" << endl;
	outfile << "  if $errlvl == 1 goto login" << endl;
	outfile << "  if $errlvl == 3 goto busy" << endl;

//	Busy section - redial

	outfile << "busy:" << endl;
	outfile << "  print Line is BUSY - trying again" << endl;
	outfile << "  goto dial" << endl;

//	Login section

	outfile << "login:" << endl;
	outfile << "  wait ogin: 60" << endl;
	outfile << "  if $errlvl != 0 goto error3" << endl;
	outfile << "  sleep 1" << endl;
	outfile << "  send " << theMxSetup->supplierLogin() << "\\r" << endl;
	outfile << "  print Login: " << theMxSetup->supplierLogin() << endl;
	outfile << "  wait word: 60" << endl;
	outfile << "  if $errlvl != 0 goto error4" << endl;
	outfile << "  send " << theMxSetup->supplierPassword() << "\\r" << endl;
	outfile << "  print Password: " << endl;
	outfile << "  wait ocol: 60" << endl;
	outfile << "  if $errlvl != 0 goto error5" << endl;
	outfile << "  send ppp,nolqm,idle=0\\r" << endl;
	outfile << "  print Protocol: PPP" << endl;
	outfile << "  wait HELLO 60" << endl;
	outfile << "  if $errlvl != 0 goto error6" << endl;

	outfile << "  print" << endl;
	outfile << "  print Dial-up and logon SUCCESSFUL" << endl;
	outfile << "  get $local " << getenv("HOST") << ".demon.co.uk" << endl;
	outfile << "  get $remote demon-du.demon.co.uk" << endl;
	outfile << "  flush" << endl;
	outfile << "  mode PPP" << endl;
	outfile << "  exit 0" << endl;

//	Error section

	outfile << "error1:" << endl;
	outfile << "  print Error resetting modem - OK not received" << endl;
	outfile << "  goto error" << endl;
	outfile << "error2:" << endl;
	outfile << "  print Error in dialling" << endl;
	outfile << "  goto error" << endl;
	outfile << "error3:" << endl;
	outfile << "  print Error waiting for login prompt" << endl;
	outfile << "  goto error" << endl;
	outfile << "error4:" << endl;
	outfile << "  print Error waiting for password prompt" << endl;
	outfile << "  goto error" << endl;
	outfile << "error5:" << endl;
	outfile << "  print Error waiting for protocol prompt" << endl;
	outfile << "  goto error" << endl;
	outfile << "error6:" << endl;
	outfile << "  print Error waiting for HELLO prompt" << endl;
	outfile << "  goto error" << endl;
	outfile << "error7:" << endl;
	outfile << "  print Reached limit on No of Retries" << endl;
	outfile << "  goto error" << endl;
	outfile << "error:" << endl;
	outfile << "  print Dial-up and logon FAILED" << endl;
	outfile << "  flush" << endl;
	outfile << "  exit 1" << endl;

	outfile.close();

	return TRUE;
}
