/*
 * Copyright 1989 Waseda University.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Waseda University not be used
 * in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.
 * Waseda University makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * WASEDA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL WASEDA
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:	Nobuhiko Nakajima
 *		Waseda University
 *
 *	61-505, Sci&Eng department, Waseda University
 *	3-1-9 shinjyuku-ku ookubo, Tokyo, Japan	169
 *	(03) 232-0551
 *
 *	Junet	hiko@ohara.waseda.ac.jp
 */

#include <stdio.h>
#include <signal.h>
#include <sys/time.h>
#include <math.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xlib.h>

#include "moon.h"
#include "moon.bm"

#ifdef SVR4
#define bcopy(src, dst, len)	memmove((dst), (src), (len))
#define bcmp(s1, s2, len)	memcmp((s1), (s2), (len))
#endif

unsigned char	MoonLast[MoonHeight*MoonWidth/8];
unsigned char	MoonShape[MoonHeight*MoonWidth/8];
unsigned char	MoonPhase[MoonHeight*MoonWidth/8];
unsigned char	MoonShade[MoonHeight*MoonWidth/8];
int        	redraw_moon;
Display		*dpy;
int		scrNum;
int		kickme;
Pixmap		MoonPixmap;
unsigned int	update;
long		times;

extern Boolean	test_flag;

/*  Forward functions  */
extern double	jtime(), phase();
extern void	phasehunt(), ringgg(), RemakeMoon(), jyear(), jhms();
extern Widget toplevel;

init_moon()
{
	Arg			arg[8];
	int			i, j, d, s, nargs;
	unsigned char	*p;
	unsigned char	mask;
	extern void		wakeup();
	Display *dpy = XtDisplay(toplevel);

	MoonPixmap = XCreatePixmapFromBitmapData( dpy,
	    XtScreen(toplevel)->root, FullMoon, MoonWidth, MoonHeight,
	    BlackPixel(dpy, scrNum), WhitePixel(dpy, scrNum),
	    DefaultDepth(dpy, scrNum) );

	for( i = 0; i < sizeof(MoonPhase); i ++ ) {
		MoonPhase[i] = FullMoon[i];
		for ( s = FullMoon[i], j = d = 0; j < 8; j++, s >>= 1 ) {
			d <<= 1;
			if (s & 1)	d |= 1;
		}
		MoonPhase[i] = d;
	}

	p = MoonShade; 
	mask = 0xaa;
	for( i = 0; i < MoonHeight; i ++ ) {
		mask = ~mask;
		for( j = 0; j < MoonWidth/8; j ++ ) *p ++ = mask;
	}

	(void) time(&times);
	redraw_moon = 1;
	ringgg();
}

void
wakeup( w )
Widget w;
{
    Arg		arg;
	Display *dpy = XtDisplay(toplevel);

    ringgg();

    if( redraw_moon ) {
	XFreePixmap( dpy, MoonPixmap );
	MoonPixmap = XCreatePixmapFromBitmapData( dpy,
	    XtScreen(toplevel)->root, MoonShape, MoonWidth, MoonHeight,
	    BlackPixel(dpy, scrNum), WhitePixel(dpy, scrNum),
	    DefaultDepth(dpy, scrNum) );

	XtSetArg ( arg, XtNbitmap, (XtArgVal)MoonPixmap );
	XtSetValues ( w, &arg, 1 );
    }

    MoonRedisplay( w, (XEvent *)NULL, (Region *)NULL );

}

/*  DRAWMOON  --  Construct given phase of moon.  */
void
RemakeMoon( ph )
double	ph;
{
    int			i, j, lx, rx;
    double		cp, xscale;
    unsigned short	lb[4];
    unsigned short	*Ptr = (unsigned short *)MoonPhase;

    xscale = cos(2 * PI * ph);

    for (i = 0; i < 24; i++) {
	lb[0] = lb[1] = lb[2] = lb[3] = 0xFFFF;
	cp = 24.0 * cos(asin(i / 24.0));
	if (ph < 0.5) {
	    rx = 32 + cp;
	    lx = 32 + xscale * cp;
	} else {
	    lx = 33 - cp;
	    rx = 33 - xscale * cp;
	}
	if ((1.0 - xscale) * cp < 0.3) {
	    lx = 0; rx = -1;
	}
	for (j = lx; j <= rx; j++) {
	    lb[j >> 4] &= (0x8000 >> (j & 0xF)) ^ 0xFFFF;
	}
	for (j = 0; j < 4; j++)
	    *( Ptr + (32 + i)*(MoonWidth/16) + j )
		= *( Ptr + (31 - i)*(MoonWidth/16) + j ) = lb[j];
    }
}

static
RedrawMoon()
{
    register int	 	n, s, j, d;
    register unsigned char	*sp, *dp, *fp, *ap;

    bcopy( MoonPhase, MoonLast, sizeof(FullMoon));

    sp = MoonPhase;
    dp = MoonShape;
    fp = FullMoon;
    ap = MoonShade;

    for( n = 0; n < sizeof( FullMoon ); n ++ ) {
	for ( s = *sp ++, j = d = 0; j < 8; j++, s >>= 1 ) {
	    d <<= 1;
	    if (s & 1)	d |= 1;
	}
	*dp++ = (~d & *ap & *fp) | d;
	ap ++; fp ++;
    }
}

/*  RINGGG  --	Update status on interval timer ticks and redraw
		window if needed.  */
void
ringgg()
{
	double jd, p, aom, cphase, cdist, cangdia, csund, csuang, lptime;
	static double last_phase = 0.0;
	struct tm *gm;

	if( test_flag ) {
	    times += 60*60*2;
	}
	else	(void) time(&times);
	    
	gm = localtime(&times);

	jd = jtime((gm = gmtime(&times)));

	p = phase(jd, &cphase, &aom, &cdist, &cangdia, &csund, &csuang);
	if (fabs(last_phase-p)*10000.0 > 1.0) {
	    RemakeMoon( p );
	    if( bcmp(MoonPhase, MoonLast, sizeof(FullMoon)) ) {
		redraw_moon = 1;
		RedrawMoon();
	    }
	    last_phase = p;
	}
}
