/* file2c.c -- convert a file into C code
 *
 * file2c name <infile >outfile.c
 *
 * file2c is a simple filter that reads a file in Xresource format
 * and writes C code of the form:
 *
 * static char *name[] = {
 *	"<first line of input>",
 *	"<second line of input>",
 *	...
 *	"<last line of input>",
 *	NULL};
 *
 * name is specified as the sole command line argument, and <contents
 * of input> is replaced by the actual data read from standard input.
 * This array is suitable as the argument of XtAppSetFallbackResources.
 */
#include <stdio.h>
#include <ctype.h>
#include "config.h"

typedef	char	*String;
typedef	int	Bool;

#ifdef	__STDC__
String	read_x_line(FILE *);
int	escape(FILE *);
void	write_x_line(String, FILE *);
void	faddc(String *, String *, int *, int *, int);
VOIDST	ealloc(int);
VOIDST	erealloc(VOIDST, int);
#else
String	read_x_line();
int	escape();
void	write_x_line();
void	faddc();
VOIDST	ealloc();
VOIDST	erealloc();
#endif

/* append a char to a line, allocating new space if necessary		*/
#define	addc(l, s, len, n, c)\
(									\
    (len++ < n) ? (*s++ = c) : (len--, faddc(&l, &s, &len, &n, c))	\
)

char	*PROGNAME;
char	*name;
int	debug = FALSE;
int	indent = 0;

int
main(argc, argv)
int	argc;
char	*argv[];
{
    register char	*line;

    PROGNAME = *argv++; argc--;
    if (1 != argc)
	error1("usage: %s name <infile >outfile.c", PROGNAME);
    name = *argv++; argc--;
    printf("/* Generated by %s */\n", PROGNAME);
    printf("static char *%s[] = {\n", name);
    while(NULL != (line = read_x_line(stdin))) {
	if ('\0' != *line) write_x_line(line, stdout);
	free(line);
    }
    printf("    NULL};\n");
    exit(NOERR);
}

String
read_x_line(xdp)
FILE		*xdp;
{
    String		line = (String) ealloc(LLEN);
    String		s;
    int			len = 0;
    int			nc = LLEN;
    int			c;
    Bool		comment = FALSE;

    s = line;
    while((EOF != (c = getc(xdp))) && ('\n' != c)) {
	if ('!' == c) comment = TRUE;
	if ('\\' == c) c = escape(xdp);
	if ((EOF != c) && !comment) addc(line, s, len, nc, c);
    }
    addc(line, s, len, nc, '\0');
    if ((EOF == c) && ('\0' == line[0])) {
	free(line);
	line = NULL;
    }
    else {
	line = erealloc(line, len);
    }
    return(line);
}

int
escape(xdp)
FILE		*xdp;
{
    int			c;
    int			d;

    switch(c = getc(xdp)) {
    case 'x':				/* hex escape			*/
	c = 0;
	while(isxdigit(d = getc(xdp))) {
	    c *= 0x10;
	    c += isdigit(d) ? (d - '0') : (tolower(d) - 'a' + 0xa);
	}
	ungetc(d, xdp);
	break;

    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
	ungetc(c, xdp);
	c = 0;
	while(('0' <= (d = getc(xdp))) && ('7' >= d)) {
	    c *= 010;
	    c += isdigit(d) ? (d - '0') : (tolower(d) - 'a' + 0xa);
	}
	ungetc(d, xdp);
	break;

    case 'a':
	c = '\a';
	break;

    case 'b':
	c = '\b';
	break;

    case 'f':
	c = '\f';
	break;

    case 'n':
	c = '\n';
	break;

    case 'r':
	c = '\r';
	break;

    case 't':
	c = '\t';
	break;

    case 'v':
	c = '\v';
	break;

    case '\n':
	c = EOF;
	break;

    case EOF:
    default:
	break;
    }
    return(c);
}

void
write_x_line(line, xdp)
String	line;
FILE	*xdp;
{
    register int	c;

    printf("    \"");
    while('\0' != (c = *line++)) {
	switch(c) {
	case '\n':
	    printf("\\\\n\\\n");
	    break;

	case '\a':
	    putchar('\\');
	    putchar('a');
	    break;

	case '\b':
	    putchar('\\');
	    putchar('b');
	    break;

	case '\f':
	    putchar('\\');
	    putchar('f');
	    break;

	case '\r':
	    putchar('\\');
	    putchar('r');
	    break;

	case '\t':
	    putchar('\\');
	    putchar('t');
	    break;

	case '\v':
	    putchar('\\');
	    putchar('v');
	    break;

	case '\"':
	    putchar('\\');
	    putchar('\"');
	    break;

	case '\'':
	    putchar('\\');
	    putchar('\'');
	    break;

	case ' ':
	    putchar(' ');
	    break;

	case '\\':
	    putchar('\\');
	    putchar('\\');
	    break;

	default:
	    if (isgraph(c))
		putchar(c);
	    else
		printf("\\x%x", 0xff & c);
	    break;
	}
    }
    printf("\",\n");
}

void
faddc(l, s, len, n, c)
String		*l;
String		*s;
int		*len;
int		*n;
int		c;
{
    int			d = (*s) - (*l);

    if (*len < *n) {
	*(*s)++ = c;
	(*len)++;
	return;
    }
    *l = (String) erealloc(*l, *n + LLEN);
    *n += LLEN;
    *s = *l + d;
    *(*s)++ = c;
    (*len)++;
}
