#ifndef IIOP_ENDIAN_H
#define IIOP_ENDIAN_H 1

/* This is pretty much "here" */
#include "config.h"

#include "ORBitutil/machine_endian.h"
#include "IIOP.h"

#define FLAG_BIG_ENDIAN 0
#define FLAG_LITTLE_ENDIAN 1

#if defined MACHINE_IS_BIG_ENDIAN

# define FLAG_ENDIANNESS FLAG_BIG_ENDIAN
# define conversion_needed(to_endianness) ((to_endianness)!=FLAG_BIG_ENDIAN)

#elif defined MACHINE_IS_LITTLE_ENDIAN

# define FLAG_ENDIANNESS FLAG_LITTLE_ENDIAN
# define conversion_needed(to_endianness) ((to_endianness)!=FLAG_LITTLE_ENDIAN)

#else
# error "The byte order on this CPU is unsupported by CORBA/IIOP <= 1.1"
#endif

/* This is also defined in IIOP-types.c */
extern inline void byteswap(guchar *outdata,
			    const guchar *data,
			    gulong datalen)
{
  const guchar *source_ptr = data;
  guchar *dest_ptr = outdata + datalen - 1;
  while(dest_ptr >= outdata)
    *dest_ptr-- = *source_ptr++;
}

#endif
