/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter and Red Hat Software
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Phil Dawes <philipd@parallax.co.uk>
 *
 */

/*
 *   ORBit specific CORBA_Object funcitons.
 *
 */
#ifndef _ORBIT_ORBIT_OBJECT_H_
#define _ORBIT_ORBIT_OBJECT_H_

#include "corba_object.h"

extern CORBA_Object ORBit_CORBA_Object_new(CORBA_Environment *ev);
extern void ORBit_CORBA_Object_free(CORBA_Object obj, CORBA_Environment *ev);

void ORBit_set_object_key(CORBA_Object obj,
			  gpointer key,
			  CORBA_unsigned_long key_len);


typedef enum {
	ORBIT_PSEUDO_ORB,
	ORBIT_PSEUDO_POA,
	ORBIT_PSEUDO_POAMANAGER
} ORBit_PseudoObject_type;
typedef struct ORBit_PseudoObject_struct *ORBit_PseudoObject;

void ORBit_pseudo_object_init(ORBit_PseudoObject obj,
			      ORBit_PseudoObject_type obj_type);

/* Use ORBit_CORBA_Object_new() */
void ORBit_object_reference_init(CORBA_Object obj, CORBA_Environment *ev);



#endif /* _ORBIT_ORBIT_OBJECT_H_ */
