/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#ifndef _ORBIT_CORBA_SEQUENCES_TYPE_H_
#define _ORBIT_CORBA_SEQUENCES_TYPE_H_

#include "corba_sequences.h"

struct CORBA_sequence_Identifier {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_Identifier *_buffer;
	unsigned int _flags;
};


struct CORBA_sequence_ServiceOption {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_ServiceOption *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_ServiceDetail {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_ServiceDetail *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_ORB_ObjectId {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_ORB_ObjectId *_buffer;  
	unsigned int _flags;
};

struct CORBA_sequence_NameValuePair {
	unsigned long int _maximum;
	unsigned long int _length;
	struct CORBA_NameValuePair *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_InterfaceDef {
	unsigned long int _maximum;
	unsigned long int _length;  
	CORBA_InterfaceDef *_buffer;
	unsigned int _flags;
};
	
struct CORBA_sequence_ContainedSeq {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_Contained *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_Container_Description {
	unsigned long int _maximum;
	unsigned long int _length;
	struct CORBA_Container_Description *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_StructMember {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_StructMember *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_UnionMember {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_UnionMember *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_CORBA_any {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_any *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_ParameterDescription {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_ParameterDescription *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_ContextIdentifier {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_ContextIdentifier *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_ExceptionDef {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_ExceptionDef *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_ExceptionDescription {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_ExceptionDescription *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_RepositoryId {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_RepositoryId *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_OperationDescription {
	unsigned long int _maximum;
	unsigned long int _length;
	struct CORBA_OperationDescription *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_AttributeDescription {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_AttributeDescription *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_Policy {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_Policy *_buffer;
	unsigned int _flags;
};

struct CORBA_sequence_DomainManager {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_DomainManager *_buffer;
	unsigned int _flags;
};

struct PortableServer_sequence_octet {
	unsigned long int _maximum;
	unsigned long int _length;
	CORBA_octet *_buffer;
	unsigned int _flags;
};

/* Generic sequence */
struct CORBA_Sequence_type {
	unsigned long int _maximum;
	unsigned long int _length;
	void *_buffer;
	unsigned int _flags;
};

#define CORBA_SEQFLAGS_RELEASE 1


#endif /* !_ORBIT_CORBA_SEQUENCES_TYPE_H_ */
