/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter and Red Hat Software
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Phil Dawes <philipd@parallax.co.uk>
 *
 */

/*
 *   ORBit specific POA funcitons.
 *
 */

#ifndef _ORBIT_ORBIT_POA_H_
#define _ORBIT_ORBIT_POA_H_

#include "orbit_types.h"

/*
 * Creates a new POAManager
 */


extern PortableServer_POAManager ORBit_POAManager_new();

extern void ORBit_POAManager_free(PortableServer_POAManager poa_mgr, 
				  CORBA_Environment *ev);


extern PortableServer_POA ORBit_POA_new(CORBA_char *adapter_name,
					 PortableServer_POAManager a_POAManager,
					 CORBA_PolicyList *policies,
					 CORBA_Environment *ev);

extern void ORBit_POA_free(PortableServer_POA poa, CORBA_Environment *ev);


extern void ORBit_POA_add_child(PortableServer_POA poa,
				PortableServer_POA child_poa,
				CORBA_Environment *ev);

void ORBit_POA_handle_request(PortableServer_POA poa,
			      GIOPRecvBuffer *recv_buffer);

#endif /* !_ORBIT_ORBIT_POA_H_ */
