/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

/**
 */
public class Filter extends Enum {
    static final private int _FAST = 0;
    static final public Filter FAST = new Filter (_FAST);
    static final private int _GOOD = 1;
    static final public Filter GOOD = new Filter (_GOOD);
    static final private int _BEST = 2;
    static final public Filter BEST = new Filter (_BEST);
    static final private int _NEAREST = 3;
    static final public Filter NEAREST = new Filter (_NEAREST);
    static final private int _BILINEAR = 4;
    static final public Filter BILINEAR = new Filter (_BILINEAR);
    static final private int _GAUSSIAN = 5;
    static final public Filter GAUSSIAN = new Filter (_GAUSSIAN);
    static final private Filter[] theInterned = new Filter[] {
        FAST, GOOD, BEST, NEAREST, BILINEAR, GAUSSIAN
    };
    static private java.util.Hashtable theInternedExtras;
    static final private Filter theSacrificialOne = new Filter (0);
    static public Filter intern (int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        Filter already = (Filter) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new Filter(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Filter(int value) {
        value_ = value;
    }

    public boolean test (Filter other) {
        return (value_ & other.value_) == other.value_;
    }
}
