/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Handle;

public class Gradient extends Pattern {
    
    Gradient(Handle hndl) {
        super(hndl);
    }

    /**
     * Adds a new color stop to the pattern.
     * @param offset The offset length
     * @param red The value to use for red
     * @param green The value to use for green
     * @param blue The value to use for blue
     */
    public void addColorStop(double offset, double red, double green, double blue) {
        cairo_pattern_add_color_stop_rgb(getHandle(), offset, red,
                    green, blue);
    }
    
    /**
     * Adds a new color stop to the pattern.
     * @param offset The offset length
     * @param red The value to use for red
     * @param green The value to use for green
     * @param blue The value to use for blue
     * @param alpha alpha for the color
     */
    public void addColorStop(double offset, double red, double green, double blue, double alpha) {
        cairo_pattern_add_color_stop_rgba(getHandle(), offset, red,
                    green, blue, alpha);
    }
    
    
}
