/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <stdlib.h>
#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_FontFace
#define _Included_org_freedesktop_cairo_FontFace
#ifdef __cplusplus
extern "C" {
#endif


/*
 * Class:     org_freedesktop_cairo_FontFace
 * Method:    cairo_font_face_destroy
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_FontFace_cairo_1font_1face_1destroy
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_face_t *font = (cairo_font_face_t*)getPointerFromHandle(env, obj);
	cairo_font_face_destroy(font);
}


#ifdef __cplusplus
}
#endif
#endif
