/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_Matrix
#define _Included_org_freedesktop_cairo_Matrix
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    getXX
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_Matrix_getXX
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	return matrix->xx;	
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    getYX
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Matrix_getYX
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	return matrix->yx;	
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    getXY
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Matrix_getXY
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	return matrix->xy;	
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    getYY
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Matrix_getYY
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	return matrix->yy;	
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    getX0
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Matrix_getX0
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	return matrix->x0;	
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    getY0
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Matrix_getY0
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	return matrix->y0;	
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    setXX
 * Signature: (Lorg/gnu/glib/Handle;D)D
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_setXX
  (JNIEnv *env, jclass cls, jobject obj, jdouble value)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	matrix->xx = (double)value;
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    setYX
 * Signature: (Lorg/gnu/glib/Handle;D)D
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_setYX
  (JNIEnv *env, jclass cls, jobject obj, jdouble value)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	matrix->yx = (double)value;
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    setXY
 * Signature: (Lorg/gnu/glib/Handle;D)D
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_setXY
  (JNIEnv *env, jclass cls, jobject obj, jdouble value)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	matrix->xy = (double)value;
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    setYY
 * Signature: (Lorg/gnu/glib/Handle;D)D
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_setYY
  (JNIEnv *env, jclass cls, jobject obj, jdouble value)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	matrix->yy = (double)value;
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    setX0
 * Signature: (Lorg/gnu/glib/Handle;D)D
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_setX0
  (JNIEnv *env, jclass cls, jobject obj, jdouble value)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	matrix->x0 = (double)value;
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    setY0
 * Signature: (Lorg/gnu/glib/Handle;D)D
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_setY0
  (JNIEnv *env, jclass cls, jobject obj, jdouble value)
{
	cairo_matrix_t *matrix;
	
	matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	matrix->y0 = (double)value;
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    cairo_matrix_translate
 * Signature: (Lorg/gnu/glib/Handle;DD)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_cairo_1matrix_1translate
  (JNIEnv *env, jclass cls, jobject obj, jdouble tx, jdouble ty)
{
	cairo_matrix_t *matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	cairo_matrix_translate(matrix, tx, ty);
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    cairo_matrix_scale
 * Signature: (Lorg/gnu/glib/Handle;DD)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_cairo_1matrix_1scale
  (JNIEnv *env, jclass cls, jobject obj, jdouble sx, jdouble sy)
{
	cairo_matrix_t *matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	cairo_matrix_scale(matrix, sx, sy);
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    cairo_matrix_rotate
 * Signature: (Lorg/gnu/glib/Handle;D)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_cairo_1matrix_1rotate
  (JNIEnv *env, jclass cls, jobject obj, jdouble rad)
{
	cairo_matrix_t *matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	cairo_matrix_rotate(matrix, rad);
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    cairo_matrix_invert
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_cairo_1matrix_1invert
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_matrix_t *matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	cairo_matrix_invert(matrix);
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    cairo_matrix_multiply
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_cairo_1matrix_1multiply
  (JNIEnv *env, jclass cls, jobject dest, jobject one, jobject two)
{
	cairo_matrix_t *dest_g = (cairo_matrix_t*)getPointerFromHandle(env, dest);
	cairo_matrix_t *one_g = (cairo_matrix_t*)getPointerFromHandle(env, one);
	cairo_matrix_t *two_g = (cairo_matrix_t*)getPointerFromHandle(env, two);
	cairo_matrix_multiply(dest_g, one_g, two_g);
	updateHandle(env, dest, dest_g);
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    cairo_matrix_transform_distance
 * Signature: (Lorg/gnu/glib/Handle;[D[D)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_cairo_1matrix_1transform_1distance
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray dx, jdoubleArray dy)
{
	cairo_matrix_t *matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	double *dx_g = (double*)(*env)->GetDoubleArrayElements(env, dx, NULL);	
	double *dy_g = (double*)(*env)->GetDoubleArrayElements(env, dy, NULL);	
	cairo_matrix_transform_distance(matrix, dx_g, dy_g);
	(*env)->ReleaseDoubleArrayElements(env, dx, dx_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, dy, dy_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Matrix
 * Method:    cairo_matrix_transform_point
 * Signature: (Lorg/gnu/glib/Handle;[D[D)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Matrix_cairo_1matrix_1transform_1point
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray dx, jdoubleArray dy)
{
	cairo_matrix_t *matrix = (cairo_matrix_t*)getPointerFromHandle(env, obj);
	double *dx_g = (double*)(*env)->GetDoubleArrayElements(env, dx, NULL);	
	double *dy_g = (double*)(*env)->GetDoubleArrayElements(env, dy, NULL);	
	cairo_matrix_transform_point(matrix, dx_g, dy_g);
	(*env)->ReleaseDoubleArrayElements(env, dx, dx_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, dy, dy_g, 0);
}

#ifdef __cplusplus
}
#endif
#endif
