/* -*- mode: C; c-basic-offset: 4 -*- */

#include "pygnomevfs-private.h"

PyObject *
pygnome_vfs_context_new(GnomeVFSContext *context)
{
    PyGnomeVFSContext *self;

    self = PyObject_NEW(PyGnomeVFSContext, &PyGnomeVFSContext_Type);
    if (self == NULL)
	    return NULL;

    self->context = context;

    return (PyObject *)self;
}

static void
pygvcontext_dealloc(PyGnomeVFSContext *self)
{
    if (self->context) {
	    gnome_vfs_context_free(self->context);
    }
    
    PyObject_FREE(self);
}

static int
pygvcontext_init(PyGnomeVFSContext *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     ":gnome.vfs.Context.__init__",
				     kwlist))
	return -1;

    /* XXX: unblock threads here */

    self->context = gnome_vfs_context_new();

    return 0;
}

static PyObject *
pygvcontext_get_cancellation(PyGnomeVFSContext *self)
{
	GnomeVFSCancellation *cancel;

	cancel = gnome_vfs_context_get_cancellation (self->context);

	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef pygvcontext_methods[] = {
    { "get_cancellation",
      (PyCFunction)pygvcontext_get_cancellation, METH_NOARGS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGnomeVFSContext_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                  /* ob_size */
    "gnome.vfs.Context",                 /* tp_name */
    sizeof(PyGnomeVFSContext),          /* tp_basicsize */
    0,                                  /* tp_itemsize */
    /* methods */
    (destructor)pygvcontext_dealloc,     /* tp_dealloc */
    (printfunc)0,                       /* tp_print */
    (getattrfunc)0,                     /* tp_getattr */
    (setattrfunc)0,                     /* tp_setattr */
    (cmpfunc)0,                         /* tp_compare */
    (reprfunc)0,                        /* tp_repr */
    0,                                  /* tp_as_number */
    0,                                  /* tp_as_sequence */
    0,                                  /* tp_as_mapping */
    (hashfunc)0,                        /* tp_hash */
    (ternaryfunc)0,                     /* tp_call */
    (reprfunc)0,                        /* tp_str */
    (getattrofunc)0,                    /* tp_getattro */
    (setattrofunc)0,                    /* tp_setattro */
    0,                                  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,   /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,                    /* tp_traverse */
    (inquiry)0,                         /* tp_clear */
    (richcmpfunc)0,                     /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
    (getiterfunc)0,                     /* tp_iter */
    (iternextfunc)0,                    /* tp_iternext */
    pygvcontext_methods,                 /* tp_methods */
    0,                                  /* tp_members */
    0,                                  /* tp_getset */
    (PyTypeObject *)0,                  /* tp_base */
    (PyObject *)0,                      /* tp_dict */
    0,                                  /* tp_descr_get */
    0,                                  /* tp_descr_set */
    0,                                  /* tp_dictoffset */
    (initproc)pygvcontext_init,         /* tp_init */
    PyType_GenericAlloc,                /* tp_alloc */
    PyType_GenericNew,                  /* tp_new */
    0,                                  /* tp_free */
    (inquiry)0,                         /* tp_is_gc */
    (PyObject *)0,                      /* tp_bases */
};
