/* libglade - a library for building interfaces from XML files at runtime
 * Copyright (C) 1998  James Henstridge <james@daa.com.au>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#include <glib.h>
#include <gdk/gdkkeysyms.h>

/* This file was automatically produced by makekeys.awk */

typedef struct _GladeKeyDef GladeKeyDef;
struct _GladeKeyDef {
  char *str;
  guint key;
};

static const GladeKeyDef keys[] = {
  { "GDK_VoidSymbol", GDK_VoidSymbol },
  { "GDK_BackSpace", GDK_BackSpace },
  { "GDK_Tab", GDK_Tab },
  { "GDK_Linefeed", GDK_Linefeed },
  { "GDK_Clear", GDK_Clear },
  { "GDK_Return", GDK_Return },
  { "GDK_Pause", GDK_Pause },
  { "GDK_Scroll_Lock", GDK_Scroll_Lock },
  { "GDK_Sys_Req", GDK_Sys_Req },
  { "GDK_Escape", GDK_Escape },
  { "GDK_Delete", GDK_Delete },
  { "GDK_Multi_key", GDK_Multi_key },
  { "GDK_SingleCandidate", GDK_SingleCandidate },
  { "GDK_MultipleCandidate", GDK_MultipleCandidate },
  { "GDK_PreviousCandidate", GDK_PreviousCandidate },
  { "GDK_Kanji", GDK_Kanji },
  { "GDK_Muhenkan", GDK_Muhenkan },
  { "GDK_Henkan_Mode", GDK_Henkan_Mode },
  { "GDK_Henkan", GDK_Henkan },
  { "GDK_Romaji", GDK_Romaji },
  { "GDK_Hiragana", GDK_Hiragana },
  { "GDK_Katakana", GDK_Katakana },
  { "GDK_Hiragana_Katakana", GDK_Hiragana_Katakana },
  { "GDK_Zenkaku", GDK_Zenkaku },
  { "GDK_Hankaku", GDK_Hankaku },
  { "GDK_Zenkaku_Hankaku", GDK_Zenkaku_Hankaku },
  { "GDK_Touroku", GDK_Touroku },
  { "GDK_Massyo", GDK_Massyo },
  { "GDK_Kana_Lock", GDK_Kana_Lock },
  { "GDK_Kana_Shift", GDK_Kana_Shift },
  { "GDK_Eisu_Shift", GDK_Eisu_Shift },
  { "GDK_Eisu_toggle", GDK_Eisu_toggle },
  { "GDK_Zen_Koho", GDK_Zen_Koho },
  { "GDK_Mae_Koho", GDK_Mae_Koho },
  { "GDK_Home", GDK_Home },
  { "GDK_Left", GDK_Left },
  { "GDK_Up", GDK_Up },
  { "GDK_Right", GDK_Right },
  { "GDK_Down", GDK_Down },
  { "GDK_Prior", GDK_Prior },
  { "GDK_Page_Up", GDK_Page_Up },
  { "GDK_Next", GDK_Next },
  { "GDK_Page_Down", GDK_Page_Down },
  { "GDK_End", GDK_End },
  { "GDK_Begin", GDK_Begin },
  { "GDK_Select", GDK_Select },
  { "GDK_Print", GDK_Print },
  { "GDK_Execute", GDK_Execute },
  { "GDK_Insert", GDK_Insert },
  { "GDK_Undo", GDK_Undo },
  { "GDK_Redo", GDK_Redo },
  { "GDK_Menu", GDK_Menu },
  { "GDK_Find", GDK_Find },
  { "GDK_Cancel", GDK_Cancel },
  { "GDK_Help", GDK_Help },
  { "GDK_Break", GDK_Break },
  { "GDK_Mode_switch", GDK_Mode_switch },
  { "GDK_script_switch", GDK_script_switch },
  { "GDK_Num_Lock", GDK_Num_Lock },
  { "GDK_KP_Space", GDK_KP_Space },
  { "GDK_KP_Tab", GDK_KP_Tab },
  { "GDK_KP_Enter", GDK_KP_Enter },
  { "GDK_KP_F1", GDK_KP_F1 },
  { "GDK_KP_F2", GDK_KP_F2 },
  { "GDK_KP_F3", GDK_KP_F3 },
  { "GDK_KP_F4", GDK_KP_F4 },
  { "GDK_KP_Home", GDK_KP_Home },
  { "GDK_KP_Left", GDK_KP_Left },
  { "GDK_KP_Up", GDK_KP_Up },
  { "GDK_KP_Right", GDK_KP_Right },
  { "GDK_KP_Down", GDK_KP_Down },
  { "GDK_KP_Prior", GDK_KP_Prior },
  { "GDK_KP_Page_Up", GDK_KP_Page_Up },
  { "GDK_KP_Next", GDK_KP_Next },
  { "GDK_KP_Page_Down", GDK_KP_Page_Down },
  { "GDK_KP_End", GDK_KP_End },
  { "GDK_KP_Begin", GDK_KP_Begin },
  { "GDK_KP_Insert", GDK_KP_Insert },
  { "GDK_KP_Delete", GDK_KP_Delete },
  { "GDK_KP_Equal", GDK_KP_Equal },
  { "GDK_KP_Multiply", GDK_KP_Multiply },
  { "GDK_KP_Add", GDK_KP_Add },
  { "GDK_KP_Separator", GDK_KP_Separator },
  { "GDK_KP_Subtract", GDK_KP_Subtract },
  { "GDK_KP_Decimal", GDK_KP_Decimal },
  { "GDK_KP_Divide", GDK_KP_Divide },
  { "GDK_KP_0", GDK_KP_0 },
  { "GDK_KP_1", GDK_KP_1 },
  { "GDK_KP_2", GDK_KP_2 },
  { "GDK_KP_3", GDK_KP_3 },
  { "GDK_KP_4", GDK_KP_4 },
  { "GDK_KP_5", GDK_KP_5 },
  { "GDK_KP_6", GDK_KP_6 },
  { "GDK_KP_7", GDK_KP_7 },
  { "GDK_KP_8", GDK_KP_8 },
  { "GDK_KP_9", GDK_KP_9 },
  { "GDK_F1", GDK_F1 },
  { "GDK_F2", GDK_F2 },
  { "GDK_F3", GDK_F3 },
  { "GDK_F4", GDK_F4 },
  { "GDK_F5", GDK_F5 },
  { "GDK_F6", GDK_F6 },
  { "GDK_F7", GDK_F7 },
  { "GDK_F8", GDK_F8 },
  { "GDK_F9", GDK_F9 },
  { "GDK_F10", GDK_F10 },
  { "GDK_F11", GDK_F11 },
  { "GDK_L1", GDK_L1 },
  { "GDK_F12", GDK_F12 },
  { "GDK_L2", GDK_L2 },
  { "GDK_F13", GDK_F13 },
  { "GDK_L3", GDK_L3 },
  { "GDK_F14", GDK_F14 },
  { "GDK_L4", GDK_L4 },
  { "GDK_F15", GDK_F15 },
  { "GDK_L5", GDK_L5 },
  { "GDK_F16", GDK_F16 },
  { "GDK_L6", GDK_L6 },
  { "GDK_F17", GDK_F17 },
  { "GDK_L7", GDK_L7 },
  { "GDK_F18", GDK_F18 },
  { "GDK_L8", GDK_L8 },
  { "GDK_F19", GDK_F19 },
  { "GDK_L9", GDK_L9 },
  { "GDK_F20", GDK_F20 },
  { "GDK_L10", GDK_L10 },
  { "GDK_F21", GDK_F21 },
  { "GDK_R1", GDK_R1 },
  { "GDK_F22", GDK_F22 },
  { "GDK_R2", GDK_R2 },
  { "GDK_F23", GDK_F23 },
  { "GDK_R3", GDK_R3 },
  { "GDK_F24", GDK_F24 },
  { "GDK_R4", GDK_R4 },
  { "GDK_F25", GDK_F25 },
  { "GDK_R5", GDK_R5 },
  { "GDK_F26", GDK_F26 },
  { "GDK_R6", GDK_R6 },
  { "GDK_F27", GDK_F27 },
  { "GDK_R7", GDK_R7 },
  { "GDK_F28", GDK_F28 },
  { "GDK_R8", GDK_R8 },
  { "GDK_F29", GDK_F29 },
  { "GDK_R9", GDK_R9 },
  { "GDK_F30", GDK_F30 },
  { "GDK_R10", GDK_R10 },
  { "GDK_F31", GDK_F31 },
  { "GDK_R11", GDK_R11 },
  { "GDK_F32", GDK_F32 },
  { "GDK_R12", GDK_R12 },
  { "GDK_F33", GDK_F33 },
  { "GDK_R13", GDK_R13 },
  { "GDK_F34", GDK_F34 },
  { "GDK_R14", GDK_R14 },
  { "GDK_F35", GDK_F35 },
  { "GDK_R15", GDK_R15 },
  { "GDK_Shift_L", GDK_Shift_L },
  { "GDK_Shift_R", GDK_Shift_R },
  { "GDK_Control_L", GDK_Control_L },
  { "GDK_Control_R", GDK_Control_R },
  { "GDK_Caps_Lock", GDK_Caps_Lock },
  { "GDK_Shift_Lock", GDK_Shift_Lock },
  { "GDK_Meta_L", GDK_Meta_L },
  { "GDK_Meta_R", GDK_Meta_R },
  { "GDK_Alt_L", GDK_Alt_L },
  { "GDK_Alt_R", GDK_Alt_R },
  { "GDK_Super_L", GDK_Super_L },
  { "GDK_Super_R", GDK_Super_R },
  { "GDK_Hyper_L", GDK_Hyper_L },
  { "GDK_Hyper_R", GDK_Hyper_R },
  { "GDK_ISO_Lock", GDK_ISO_Lock },
  { "GDK_ISO_Level2_Latch", GDK_ISO_Level2_Latch },
  { "GDK_ISO_Level3_Shift", GDK_ISO_Level3_Shift },
  { "GDK_ISO_Level3_Latch", GDK_ISO_Level3_Latch },
  { "GDK_ISO_Level3_Lock", GDK_ISO_Level3_Lock },
  { "GDK_ISO_Group_Shift", GDK_ISO_Group_Shift },
  { "GDK_ISO_Group_Latch", GDK_ISO_Group_Latch },
  { "GDK_ISO_Group_Lock", GDK_ISO_Group_Lock },
  { "GDK_ISO_Next_Group", GDK_ISO_Next_Group },
  { "GDK_ISO_Next_Group_Lock", GDK_ISO_Next_Group_Lock },
  { "GDK_ISO_Prev_Group", GDK_ISO_Prev_Group },
  { "GDK_ISO_Prev_Group_Lock", GDK_ISO_Prev_Group_Lock },
  { "GDK_ISO_First_Group", GDK_ISO_First_Group },
  { "GDK_ISO_First_Group_Lock", GDK_ISO_First_Group_Lock },
  { "GDK_ISO_Last_Group", GDK_ISO_Last_Group },
  { "GDK_ISO_Last_Group_Lock", GDK_ISO_Last_Group_Lock },
  { "GDK_ISO_Left_Tab", GDK_ISO_Left_Tab },
  { "GDK_ISO_Move_Line_Up", GDK_ISO_Move_Line_Up },
  { "GDK_ISO_Move_Line_Down", GDK_ISO_Move_Line_Down },
  { "GDK_ISO_Partial_Line_Up", GDK_ISO_Partial_Line_Up },
  { "GDK_ISO_Partial_Line_Down", GDK_ISO_Partial_Line_Down },
  { "GDK_ISO_Partial_Space_Left", GDK_ISO_Partial_Space_Left },
  { "GDK_ISO_Partial_Space_Right", GDK_ISO_Partial_Space_Right },
  { "GDK_ISO_Set_Margin_Left", GDK_ISO_Set_Margin_Left },
  { "GDK_ISO_Set_Margin_Right", GDK_ISO_Set_Margin_Right },
  { "GDK_ISO_Release_Margin_Left", GDK_ISO_Release_Margin_Left },
  { "GDK_ISO_Release_Margin_Right", GDK_ISO_Release_Margin_Right },
  { "GDK_ISO_Release_Both_Margins", GDK_ISO_Release_Both_Margins },
  { "GDK_ISO_Fast_Cursor_Left", GDK_ISO_Fast_Cursor_Left },
  { "GDK_ISO_Fast_Cursor_Right", GDK_ISO_Fast_Cursor_Right },
  { "GDK_ISO_Fast_Cursor_Up", GDK_ISO_Fast_Cursor_Up },
  { "GDK_ISO_Fast_Cursor_Down", GDK_ISO_Fast_Cursor_Down },
  { "GDK_ISO_Continuous_Underline", GDK_ISO_Continuous_Underline },
  { "GDK_ISO_Discontinuous_Underline", GDK_ISO_Discontinuous_Underline },
  { "GDK_ISO_Emphasize", GDK_ISO_Emphasize },
  { "GDK_ISO_Center_Object", GDK_ISO_Center_Object },
  { "GDK_ISO_Enter", GDK_ISO_Enter },
  { "GDK_dead_grave", GDK_dead_grave },
  { "GDK_dead_acute", GDK_dead_acute },
  { "GDK_dead_circumflex", GDK_dead_circumflex },
  { "GDK_dead_tilde", GDK_dead_tilde },
  { "GDK_dead_macron", GDK_dead_macron },
  { "GDK_dead_breve", GDK_dead_breve },
  { "GDK_dead_abovedot", GDK_dead_abovedot },
  { "GDK_dead_diaeresis", GDK_dead_diaeresis },
  { "GDK_dead_abovering", GDK_dead_abovering },
  { "GDK_dead_doubleacute", GDK_dead_doubleacute },
  { "GDK_dead_caron", GDK_dead_caron },
  { "GDK_dead_cedilla", GDK_dead_cedilla },
  { "GDK_dead_ogonek", GDK_dead_ogonek },
  { "GDK_dead_iota", GDK_dead_iota },
  { "GDK_dead_voiced_sound", GDK_dead_voiced_sound },
  { "GDK_dead_semivoiced_sound", GDK_dead_semivoiced_sound },
  { "GDK_dead_belowdot", GDK_dead_belowdot },
  { "GDK_First_Virtual_Screen", GDK_First_Virtual_Screen },
  { "GDK_Prev_Virtual_Screen", GDK_Prev_Virtual_Screen },
  { "GDK_Next_Virtual_Screen", GDK_Next_Virtual_Screen },
  { "GDK_Last_Virtual_Screen", GDK_Last_Virtual_Screen },
  { "GDK_Terminate_Server", GDK_Terminate_Server },
  { "GDK_AccessX_Enable", GDK_AccessX_Enable },
  { "GDK_AccessX_Feedback_Enable", GDK_AccessX_Feedback_Enable },
  { "GDK_RepeatKeys_Enable", GDK_RepeatKeys_Enable },
  { "GDK_SlowKeys_Enable", GDK_SlowKeys_Enable },
  { "GDK_BounceKeys_Enable", GDK_BounceKeys_Enable },
  { "GDK_StickyKeys_Enable", GDK_StickyKeys_Enable },
  { "GDK_MouseKeys_Enable", GDK_MouseKeys_Enable },
  { "GDK_MouseKeys_Accel_Enable", GDK_MouseKeys_Accel_Enable },
  { "GDK_Overlay1_Enable", GDK_Overlay1_Enable },
  { "GDK_Overlay2_Enable", GDK_Overlay2_Enable },
  { "GDK_AudibleBell_Enable", GDK_AudibleBell_Enable },
  { "GDK_Pointer_Left", GDK_Pointer_Left },
  { "GDK_Pointer_Right", GDK_Pointer_Right },
  { "GDK_Pointer_Up", GDK_Pointer_Up },
  { "GDK_Pointer_Down", GDK_Pointer_Down },
  { "GDK_Pointer_UpLeft", GDK_Pointer_UpLeft },
  { "GDK_Pointer_UpRight", GDK_Pointer_UpRight },
  { "GDK_Pointer_DownLeft", GDK_Pointer_DownLeft },
  { "GDK_Pointer_DownRight", GDK_Pointer_DownRight },
  { "GDK_Pointer_Button_Dflt", GDK_Pointer_Button_Dflt },
  { "GDK_Pointer_Button1", GDK_Pointer_Button1 },
  { "GDK_Pointer_Button2", GDK_Pointer_Button2 },
  { "GDK_Pointer_Button3", GDK_Pointer_Button3 },
  { "GDK_Pointer_Button4", GDK_Pointer_Button4 },
  { "GDK_Pointer_Button5", GDK_Pointer_Button5 },
  { "GDK_Pointer_DblClick_Dflt", GDK_Pointer_DblClick_Dflt },
  { "GDK_Pointer_DblClick1", GDK_Pointer_DblClick1 },
  { "GDK_Pointer_DblClick2", GDK_Pointer_DblClick2 },
  { "GDK_Pointer_DblClick3", GDK_Pointer_DblClick3 },
  { "GDK_Pointer_DblClick4", GDK_Pointer_DblClick4 },
  { "GDK_Pointer_DblClick5", GDK_Pointer_DblClick5 },
  { "GDK_Pointer_Drag_Dflt", GDK_Pointer_Drag_Dflt },
  { "GDK_Pointer_Drag1", GDK_Pointer_Drag1 },
  { "GDK_Pointer_Drag2", GDK_Pointer_Drag2 },
  { "GDK_Pointer_Drag3", GDK_Pointer_Drag3 },
  { "GDK_Pointer_Drag4", GDK_Pointer_Drag4 },
  { "GDK_Pointer_Drag5", GDK_Pointer_Drag5 },
  { "GDK_Pointer_EnableKeys", GDK_Pointer_EnableKeys },
  { "GDK_Pointer_Accelerate", GDK_Pointer_Accelerate },
  { "GDK_Pointer_DfltBtnNext", GDK_Pointer_DfltBtnNext },
  { "GDK_Pointer_DfltBtnPrev", GDK_Pointer_DfltBtnPrev },
  { "GDK_3270_Duplicate", GDK_3270_Duplicate },
  { "GDK_3270_FieldMark", GDK_3270_FieldMark },
  { "GDK_3270_Right2", GDK_3270_Right2 },
  { "GDK_3270_Left2", GDK_3270_Left2 },
  { "GDK_3270_BackTab", GDK_3270_BackTab },
  { "GDK_3270_EraseEOF", GDK_3270_EraseEOF },
  { "GDK_3270_EraseInput", GDK_3270_EraseInput },
  { "GDK_3270_Reset", GDK_3270_Reset },
  { "GDK_3270_Quit", GDK_3270_Quit },
  { "GDK_3270_PA1", GDK_3270_PA1 },
  { "GDK_3270_PA2", GDK_3270_PA2 },
  { "GDK_3270_PA3", GDK_3270_PA3 },
  { "GDK_3270_Test", GDK_3270_Test },
  { "GDK_3270_Attn", GDK_3270_Attn },
  { "GDK_3270_CursorBlink", GDK_3270_CursorBlink },
  { "GDK_3270_AltCursor", GDK_3270_AltCursor },
  { "GDK_3270_KeyClick", GDK_3270_KeyClick },
  { "GDK_3270_Jump", GDK_3270_Jump },
  { "GDK_3270_Ident", GDK_3270_Ident },
  { "GDK_3270_Rule", GDK_3270_Rule },
  { "GDK_3270_Copy", GDK_3270_Copy },
  { "GDK_3270_Play", GDK_3270_Play },
  { "GDK_3270_Setup", GDK_3270_Setup },
  { "GDK_3270_Record", GDK_3270_Record },
  { "GDK_3270_ChangeScreen", GDK_3270_ChangeScreen },
  { "GDK_3270_DeleteWord", GDK_3270_DeleteWord },
  { "GDK_3270_ExSelect", GDK_3270_ExSelect },
  { "GDK_3270_CursorSelect", GDK_3270_CursorSelect },
  { "GDK_3270_PrintScreen", GDK_3270_PrintScreen },
  { "GDK_3270_Enter", GDK_3270_Enter },
  { "GDK_space", GDK_space },
  { "GDK_exclam", GDK_exclam },
  { "GDK_quotedbl", GDK_quotedbl },
  { "GDK_numbersign", GDK_numbersign },
  { "GDK_dollar", GDK_dollar },
  { "GDK_percent", GDK_percent },
  { "GDK_ampersand", GDK_ampersand },
  { "GDK_apostrophe", GDK_apostrophe },
  { "GDK_quoteright", GDK_quoteright },
  { "GDK_parenleft", GDK_parenleft },
  { "GDK_parenright", GDK_parenright },
  { "GDK_asterisk", GDK_asterisk },
  { "GDK_plus", GDK_plus },
  { "GDK_comma", GDK_comma },
  { "GDK_minus", GDK_minus },
  { "GDK_period", GDK_period },
  { "GDK_slash", GDK_slash },
  { "GDK_0", GDK_0 },
  { "GDK_1", GDK_1 },
  { "GDK_2", GDK_2 },
  { "GDK_3", GDK_3 },
  { "GDK_4", GDK_4 },
  { "GDK_5", GDK_5 },
  { "GDK_6", GDK_6 },
  { "GDK_7", GDK_7 },
  { "GDK_8", GDK_8 },
  { "GDK_9", GDK_9 },
  { "GDK_colon", GDK_colon },
  { "GDK_semicolon", GDK_semicolon },
  { "GDK_less", GDK_less },
  { "GDK_equal", GDK_equal },
  { "GDK_greater", GDK_greater },
  { "GDK_question", GDK_question },
  { "GDK_at", GDK_at },
  { "GDK_A", GDK_A },
  { "GDK_B", GDK_B },
  { "GDK_C", GDK_C },
  { "GDK_D", GDK_D },
  { "GDK_E", GDK_E },
  { "GDK_F", GDK_F },
  { "GDK_G", GDK_G },
  { "GDK_H", GDK_H },
  { "GDK_I", GDK_I },
  { "GDK_J", GDK_J },
  { "GDK_K", GDK_K },
  { "GDK_L", GDK_L },
  { "GDK_M", GDK_M },
  { "GDK_N", GDK_N },
  { "GDK_O", GDK_O },
  { "GDK_P", GDK_P },
  { "GDK_Q", GDK_Q },
  { "GDK_R", GDK_R },
  { "GDK_S", GDK_S },
  { "GDK_T", GDK_T },
  { "GDK_U", GDK_U },
  { "GDK_V", GDK_V },
  { "GDK_W", GDK_W },
  { "GDK_X", GDK_X },
  { "GDK_Y", GDK_Y },
  { "GDK_Z", GDK_Z },
  { "GDK_bracketleft", GDK_bracketleft },
  { "GDK_backslash", GDK_backslash },
  { "GDK_bracketright", GDK_bracketright },
  { "GDK_asciicircum", GDK_asciicircum },
  { "GDK_underscore", GDK_underscore },
  { "GDK_grave", GDK_grave },
  { "GDK_quoteleft", GDK_quoteleft },
  { "GDK_a", GDK_a },
  { "GDK_b", GDK_b },
  { "GDK_c", GDK_c },
  { "GDK_d", GDK_d },
  { "GDK_e", GDK_e },
  { "GDK_f", GDK_f },
  { "GDK_g", GDK_g },
  { "GDK_h", GDK_h },
  { "GDK_i", GDK_i },
  { "GDK_j", GDK_j },
  { "GDK_k", GDK_k },
  { "GDK_l", GDK_l },
  { "GDK_m", GDK_m },
  { "GDK_n", GDK_n },
  { "GDK_o", GDK_o },
  { "GDK_p", GDK_p },
  { "GDK_q", GDK_q },
  { "GDK_r", GDK_r },
  { "GDK_s", GDK_s },
  { "GDK_t", GDK_t },
  { "GDK_u", GDK_u },
  { "GDK_v", GDK_v },
  { "GDK_w", GDK_w },
  { "GDK_x", GDK_x },
  { "GDK_y", GDK_y },
  { "GDK_z", GDK_z },
  { "GDK_braceleft", GDK_braceleft },
  { "GDK_bar", GDK_bar },
  { "GDK_braceright", GDK_braceright },
  { "GDK_asciitilde", GDK_asciitilde },
  { "GDK_nobreakspace", GDK_nobreakspace },
  { "GDK_exclamdown", GDK_exclamdown },
  { "GDK_cent", GDK_cent },
  { "GDK_sterling", GDK_sterling },
  { "GDK_currency", GDK_currency },
  { "GDK_yen", GDK_yen },
  { "GDK_brokenbar", GDK_brokenbar },
  { "GDK_section", GDK_section },
  { "GDK_diaeresis", GDK_diaeresis },
  { "GDK_copyright", GDK_copyright },
  { "GDK_ordfeminine", GDK_ordfeminine },
  { "GDK_guillemotleft", GDK_guillemotleft },
  { "GDK_notsign", GDK_notsign },
  { "GDK_hyphen", GDK_hyphen },
  { "GDK_registered", GDK_registered },
  { "GDK_macron", GDK_macron },
  { "GDK_degree", GDK_degree },
  { "GDK_plusminus", GDK_plusminus },
  { "GDK_twosuperior", GDK_twosuperior },
  { "GDK_threesuperior", GDK_threesuperior },
  { "GDK_acute", GDK_acute },
  { "GDK_mu", GDK_mu },
  { "GDK_paragraph", GDK_paragraph },
  { "GDK_periodcentered", GDK_periodcentered },
  { "GDK_cedilla", GDK_cedilla },
  { "GDK_onesuperior", GDK_onesuperior },
  { "GDK_masculine", GDK_masculine },
  { "GDK_guillemotright", GDK_guillemotright },
  { "GDK_onequarter", GDK_onequarter },
  { "GDK_onehalf", GDK_onehalf },
  { "GDK_threequarters", GDK_threequarters },
  { "GDK_questiondown", GDK_questiondown },
  { "GDK_Agrave", GDK_Agrave },
  { "GDK_Aacute", GDK_Aacute },
  { "GDK_Acircumflex", GDK_Acircumflex },
  { "GDK_Atilde", GDK_Atilde },
  { "GDK_Adiaeresis", GDK_Adiaeresis },
  { "GDK_Aring", GDK_Aring },
  { "GDK_AE", GDK_AE },
  { "GDK_Ccedilla", GDK_Ccedilla },
  { "GDK_Egrave", GDK_Egrave },
  { "GDK_Eacute", GDK_Eacute },
  { "GDK_Ecircumflex", GDK_Ecircumflex },
  { "GDK_Ediaeresis", GDK_Ediaeresis },
  { "GDK_Igrave", GDK_Igrave },
  { "GDK_Iacute", GDK_Iacute },
  { "GDK_Icircumflex", GDK_Icircumflex },
  { "GDK_Idiaeresis", GDK_Idiaeresis },
  { "GDK_ETH", GDK_ETH },
  { "GDK_Eth", GDK_Eth },
  { "GDK_Ntilde", GDK_Ntilde },
  { "GDK_Ograve", GDK_Ograve },
  { "GDK_Oacute", GDK_Oacute },
  { "GDK_Ocircumflex", GDK_Ocircumflex },
  { "GDK_Otilde", GDK_Otilde },
  { "GDK_Odiaeresis", GDK_Odiaeresis },
  { "GDK_multiply", GDK_multiply },
  { "GDK_Ooblique", GDK_Ooblique },
  { "GDK_Ugrave", GDK_Ugrave },
  { "GDK_Uacute", GDK_Uacute },
  { "GDK_Ucircumflex", GDK_Ucircumflex },
  { "GDK_Udiaeresis", GDK_Udiaeresis },
  { "GDK_Yacute", GDK_Yacute },
  { "GDK_THORN", GDK_THORN },
  { "GDK_Thorn", GDK_Thorn },
  { "GDK_ssharp", GDK_ssharp },
  { "GDK_agrave", GDK_agrave },
  { "GDK_aacute", GDK_aacute },
  { "GDK_acircumflex", GDK_acircumflex },
  { "GDK_atilde", GDK_atilde },
  { "GDK_adiaeresis", GDK_adiaeresis },
  { "GDK_aring", GDK_aring },
  { "GDK_ae", GDK_ae },
  { "GDK_ccedilla", GDK_ccedilla },
  { "GDK_egrave", GDK_egrave },
  { "GDK_eacute", GDK_eacute },
  { "GDK_ecircumflex", GDK_ecircumflex },
  { "GDK_ediaeresis", GDK_ediaeresis },
  { "GDK_igrave", GDK_igrave },
  { "GDK_iacute", GDK_iacute },
  { "GDK_icircumflex", GDK_icircumflex },
  { "GDK_idiaeresis", GDK_idiaeresis },
  { "GDK_eth", GDK_eth },
  { "GDK_ntilde", GDK_ntilde },
  { "GDK_ograve", GDK_ograve },
  { "GDK_oacute", GDK_oacute },
  { "GDK_ocircumflex", GDK_ocircumflex },
  { "GDK_otilde", GDK_otilde },
  { "GDK_odiaeresis", GDK_odiaeresis },
  { "GDK_division", GDK_division },
  { "GDK_oslash", GDK_oslash },
  { "GDK_ugrave", GDK_ugrave },
  { "GDK_uacute", GDK_uacute },
  { "GDK_ucircumflex", GDK_ucircumflex },
  { "GDK_udiaeresis", GDK_udiaeresis },
  { "GDK_yacute", GDK_yacute },
  { "GDK_thorn", GDK_thorn },
  { "GDK_ydiaeresis", GDK_ydiaeresis },
  { "GDK_Aogonek", GDK_Aogonek },
  { "GDK_breve", GDK_breve },
  { "GDK_Lstroke", GDK_Lstroke },
  { "GDK_Lcaron", GDK_Lcaron },
  { "GDK_Sacute", GDK_Sacute },
  { "GDK_Scaron", GDK_Scaron },
  { "GDK_Scedilla", GDK_Scedilla },
  { "GDK_Tcaron", GDK_Tcaron },
  { "GDK_Zacute", GDK_Zacute },
  { "GDK_Zcaron", GDK_Zcaron },
  { "GDK_Zabovedot", GDK_Zabovedot },
  { "GDK_aogonek", GDK_aogonek },
  { "GDK_ogonek", GDK_ogonek },
  { "GDK_lstroke", GDK_lstroke },
  { "GDK_lcaron", GDK_lcaron },
  { "GDK_sacute", GDK_sacute },
  { "GDK_caron", GDK_caron },
  { "GDK_scaron", GDK_scaron },
  { "GDK_scedilla", GDK_scedilla },
  { "GDK_tcaron", GDK_tcaron },
  { "GDK_zacute", GDK_zacute },
  { "GDK_doubleacute", GDK_doubleacute },
  { "GDK_zcaron", GDK_zcaron },
  { "GDK_zabovedot", GDK_zabovedot },
  { "GDK_Racute", GDK_Racute },
  { "GDK_Abreve", GDK_Abreve },
  { "GDK_Lacute", GDK_Lacute },
  { "GDK_Cacute", GDK_Cacute },
  { "GDK_Ccaron", GDK_Ccaron },
  { "GDK_Eogonek", GDK_Eogonek },
  { "GDK_Ecaron", GDK_Ecaron },
  { "GDK_Dcaron", GDK_Dcaron },
  { "GDK_Dstroke", GDK_Dstroke },
  { "GDK_Nacute", GDK_Nacute },
  { "GDK_Ncaron", GDK_Ncaron },
  { "GDK_Odoubleacute", GDK_Odoubleacute },
  { "GDK_Rcaron", GDK_Rcaron },
  { "GDK_Uring", GDK_Uring },
  { "GDK_Udoubleacute", GDK_Udoubleacute },
  { "GDK_Tcedilla", GDK_Tcedilla },
  { "GDK_racute", GDK_racute },
  { "GDK_abreve", GDK_abreve },
  { "GDK_lacute", GDK_lacute },
  { "GDK_cacute", GDK_cacute },
  { "GDK_ccaron", GDK_ccaron },
  { "GDK_eogonek", GDK_eogonek },
  { "GDK_ecaron", GDK_ecaron },
  { "GDK_dcaron", GDK_dcaron },
  { "GDK_dstroke", GDK_dstroke },
  { "GDK_nacute", GDK_nacute },
  { "GDK_ncaron", GDK_ncaron },
  { "GDK_odoubleacute", GDK_odoubleacute },
  { "GDK_udoubleacute", GDK_udoubleacute },
  { "GDK_rcaron", GDK_rcaron },
  { "GDK_uring", GDK_uring },
  { "GDK_tcedilla", GDK_tcedilla },
  { "GDK_abovedot", GDK_abovedot },
  { "GDK_Hstroke", GDK_Hstroke },
  { "GDK_Hcircumflex", GDK_Hcircumflex },
  { "GDK_Iabovedot", GDK_Iabovedot },
  { "GDK_Gbreve", GDK_Gbreve },
  { "GDK_Jcircumflex", GDK_Jcircumflex },
  { "GDK_hstroke", GDK_hstroke },
  { "GDK_hcircumflex", GDK_hcircumflex },
  { "GDK_idotless", GDK_idotless },
  { "GDK_gbreve", GDK_gbreve },
  { "GDK_jcircumflex", GDK_jcircumflex },
  { "GDK_Cabovedot", GDK_Cabovedot },
  { "GDK_Ccircumflex", GDK_Ccircumflex },
  { "GDK_Gabovedot", GDK_Gabovedot },
  { "GDK_Gcircumflex", GDK_Gcircumflex },
  { "GDK_Ubreve", GDK_Ubreve },
  { "GDK_Scircumflex", GDK_Scircumflex },
  { "GDK_cabovedot", GDK_cabovedot },
  { "GDK_ccircumflex", GDK_ccircumflex },
  { "GDK_gabovedot", GDK_gabovedot },
  { "GDK_gcircumflex", GDK_gcircumflex },
  { "GDK_ubreve", GDK_ubreve },
  { "GDK_scircumflex", GDK_scircumflex },
  { "GDK_kra", GDK_kra },
  { "GDK_kappa", GDK_kappa },
  { "GDK_Rcedilla", GDK_Rcedilla },
  { "GDK_Itilde", GDK_Itilde },
  { "GDK_Lcedilla", GDK_Lcedilla },
  { "GDK_Emacron", GDK_Emacron },
  { "GDK_Gcedilla", GDK_Gcedilla },
  { "GDK_Tslash", GDK_Tslash },
  { "GDK_rcedilla", GDK_rcedilla },
  { "GDK_itilde", GDK_itilde },
  { "GDK_lcedilla", GDK_lcedilla },
  { "GDK_emacron", GDK_emacron },
  { "GDK_gcedilla", GDK_gcedilla },
  { "GDK_tslash", GDK_tslash },
  { "GDK_ENG", GDK_ENG },
  { "GDK_eng", GDK_eng },
  { "GDK_Amacron", GDK_Amacron },
  { "GDK_Iogonek", GDK_Iogonek },
  { "GDK_Eabovedot", GDK_Eabovedot },
  { "GDK_Imacron", GDK_Imacron },
  { "GDK_Ncedilla", GDK_Ncedilla },
  { "GDK_Omacron", GDK_Omacron },
  { "GDK_Kcedilla", GDK_Kcedilla },
  { "GDK_Uogonek", GDK_Uogonek },
  { "GDK_Utilde", GDK_Utilde },
  { "GDK_Umacron", GDK_Umacron },
  { "GDK_amacron", GDK_amacron },
  { "GDK_iogonek", GDK_iogonek },
  { "GDK_eabovedot", GDK_eabovedot },
  { "GDK_imacron", GDK_imacron },
  { "GDK_ncedilla", GDK_ncedilla },
  { "GDK_omacron", GDK_omacron },
  { "GDK_kcedilla", GDK_kcedilla },
  { "GDK_uogonek", GDK_uogonek },
  { "GDK_utilde", GDK_utilde },
  { "GDK_umacron", GDK_umacron },
  { "GDK_overline", GDK_overline },
  { "GDK_kana_fullstop", GDK_kana_fullstop },
  { "GDK_kana_openingbracket", GDK_kana_openingbracket },
  { "GDK_kana_closingbracket", GDK_kana_closingbracket },
  { "GDK_kana_comma", GDK_kana_comma },
  { "GDK_kana_conjunctive", GDK_kana_conjunctive },
  { "GDK_kana_middledot", GDK_kana_middledot },
  { "GDK_kana_WO", GDK_kana_WO },
  { "GDK_kana_a", GDK_kana_a },
  { "GDK_kana_i", GDK_kana_i },
  { "GDK_kana_u", GDK_kana_u },
  { "GDK_kana_e", GDK_kana_e },
  { "GDK_kana_o", GDK_kana_o },
  { "GDK_kana_ya", GDK_kana_ya },
  { "GDK_kana_yu", GDK_kana_yu },
  { "GDK_kana_yo", GDK_kana_yo },
  { "GDK_kana_tsu", GDK_kana_tsu },
  { "GDK_kana_tu", GDK_kana_tu },
  { "GDK_prolongedsound", GDK_prolongedsound },
  { "GDK_kana_A", GDK_kana_A },
  { "GDK_kana_I", GDK_kana_I },
  { "GDK_kana_U", GDK_kana_U },
  { "GDK_kana_E", GDK_kana_E },
  { "GDK_kana_O", GDK_kana_O },
  { "GDK_kana_KA", GDK_kana_KA },
  { "GDK_kana_KI", GDK_kana_KI },
  { "GDK_kana_KU", GDK_kana_KU },
  { "GDK_kana_KE", GDK_kana_KE },
  { "GDK_kana_KO", GDK_kana_KO },
  { "GDK_kana_SA", GDK_kana_SA },
  { "GDK_kana_SHI", GDK_kana_SHI },
  { "GDK_kana_SU", GDK_kana_SU },
  { "GDK_kana_SE", GDK_kana_SE },
  { "GDK_kana_SO", GDK_kana_SO },
  { "GDK_kana_TA", GDK_kana_TA },
  { "GDK_kana_CHI", GDK_kana_CHI },
  { "GDK_kana_TI", GDK_kana_TI },
  { "GDK_kana_TSU", GDK_kana_TSU },
  { "GDK_kana_TU", GDK_kana_TU },
  { "GDK_kana_TE", GDK_kana_TE },
  { "GDK_kana_TO", GDK_kana_TO },
  { "GDK_kana_NA", GDK_kana_NA },
  { "GDK_kana_NI", GDK_kana_NI },
  { "GDK_kana_NU", GDK_kana_NU },
  { "GDK_kana_NE", GDK_kana_NE },
  { "GDK_kana_NO", GDK_kana_NO },
  { "GDK_kana_HA", GDK_kana_HA },
  { "GDK_kana_HI", GDK_kana_HI },
  { "GDK_kana_FU", GDK_kana_FU },
  { "GDK_kana_HU", GDK_kana_HU },
  { "GDK_kana_HE", GDK_kana_HE },
  { "GDK_kana_HO", GDK_kana_HO },
  { "GDK_kana_MA", GDK_kana_MA },
  { "GDK_kana_MI", GDK_kana_MI },
  { "GDK_kana_MU", GDK_kana_MU },
  { "GDK_kana_ME", GDK_kana_ME },
  { "GDK_kana_MO", GDK_kana_MO },
  { "GDK_kana_YA", GDK_kana_YA },
  { "GDK_kana_YU", GDK_kana_YU },
  { "GDK_kana_YO", GDK_kana_YO },
  { "GDK_kana_RA", GDK_kana_RA },
  { "GDK_kana_RI", GDK_kana_RI },
  { "GDK_kana_RU", GDK_kana_RU },
  { "GDK_kana_RE", GDK_kana_RE },
  { "GDK_kana_RO", GDK_kana_RO },
  { "GDK_kana_WA", GDK_kana_WA },
  { "GDK_kana_N", GDK_kana_N },
  { "GDK_voicedsound", GDK_voicedsound },
  { "GDK_semivoicedsound", GDK_semivoicedsound },
  { "GDK_kana_switch", GDK_kana_switch },
  { "GDK_Arabic_comma", GDK_Arabic_comma },
  { "GDK_Arabic_semicolon", GDK_Arabic_semicolon },
  { "GDK_Arabic_question_mark", GDK_Arabic_question_mark },
  { "GDK_Arabic_hamza", GDK_Arabic_hamza },
  { "GDK_Arabic_maddaonalef", GDK_Arabic_maddaonalef },
  { "GDK_Arabic_hamzaonalef", GDK_Arabic_hamzaonalef },
  { "GDK_Arabic_hamzaonwaw", GDK_Arabic_hamzaonwaw },
  { "GDK_Arabic_hamzaunderalef", GDK_Arabic_hamzaunderalef },
  { "GDK_Arabic_hamzaonyeh", GDK_Arabic_hamzaonyeh },
  { "GDK_Arabic_alef", GDK_Arabic_alef },
  { "GDK_Arabic_beh", GDK_Arabic_beh },
  { "GDK_Arabic_tehmarbuta", GDK_Arabic_tehmarbuta },
  { "GDK_Arabic_teh", GDK_Arabic_teh },
  { "GDK_Arabic_theh", GDK_Arabic_theh },
  { "GDK_Arabic_jeem", GDK_Arabic_jeem },
  { "GDK_Arabic_hah", GDK_Arabic_hah },
  { "GDK_Arabic_khah", GDK_Arabic_khah },
  { "GDK_Arabic_dal", GDK_Arabic_dal },
  { "GDK_Arabic_thal", GDK_Arabic_thal },
  { "GDK_Arabic_ra", GDK_Arabic_ra },
  { "GDK_Arabic_zain", GDK_Arabic_zain },
  { "GDK_Arabic_seen", GDK_Arabic_seen },
  { "GDK_Arabic_sheen", GDK_Arabic_sheen },
  { "GDK_Arabic_sad", GDK_Arabic_sad },
  { "GDK_Arabic_dad", GDK_Arabic_dad },
  { "GDK_Arabic_tah", GDK_Arabic_tah },
  { "GDK_Arabic_zah", GDK_Arabic_zah },
  { "GDK_Arabic_ain", GDK_Arabic_ain },
  { "GDK_Arabic_ghain", GDK_Arabic_ghain },
  { "GDK_Arabic_tatweel", GDK_Arabic_tatweel },
  { "GDK_Arabic_feh", GDK_Arabic_feh },
  { "GDK_Arabic_qaf", GDK_Arabic_qaf },
  { "GDK_Arabic_kaf", GDK_Arabic_kaf },
  { "GDK_Arabic_lam", GDK_Arabic_lam },
  { "GDK_Arabic_meem", GDK_Arabic_meem },
  { "GDK_Arabic_noon", GDK_Arabic_noon },
  { "GDK_Arabic_ha", GDK_Arabic_ha },
  { "GDK_Arabic_heh", GDK_Arabic_heh },
  { "GDK_Arabic_waw", GDK_Arabic_waw },
  { "GDK_Arabic_alefmaksura", GDK_Arabic_alefmaksura },
  { "GDK_Arabic_yeh", GDK_Arabic_yeh },
  { "GDK_Arabic_fathatan", GDK_Arabic_fathatan },
  { "GDK_Arabic_dammatan", GDK_Arabic_dammatan },
  { "GDK_Arabic_kasratan", GDK_Arabic_kasratan },
  { "GDK_Arabic_fatha", GDK_Arabic_fatha },
  { "GDK_Arabic_damma", GDK_Arabic_damma },
  { "GDK_Arabic_kasra", GDK_Arabic_kasra },
  { "GDK_Arabic_shadda", GDK_Arabic_shadda },
  { "GDK_Arabic_sukun", GDK_Arabic_sukun },
  { "GDK_Arabic_switch", GDK_Arabic_switch },
  { "GDK_Serbian_dje", GDK_Serbian_dje },
  { "GDK_Macedonia_gje", GDK_Macedonia_gje },
  { "GDK_Cyrillic_io", GDK_Cyrillic_io },
  { "GDK_Ukrainian_ie", GDK_Ukrainian_ie },
  { "GDK_Ukranian_je", GDK_Ukranian_je },
  { "GDK_Macedonia_dse", GDK_Macedonia_dse },
  { "GDK_Ukrainian_i", GDK_Ukrainian_i },
  { "GDK_Ukranian_i", GDK_Ukranian_i },
  { "GDK_Ukrainian_yi", GDK_Ukrainian_yi },
  { "GDK_Ukranian_yi", GDK_Ukranian_yi },
  { "GDK_Cyrillic_je", GDK_Cyrillic_je },
  { "GDK_Serbian_je", GDK_Serbian_je },
  { "GDK_Cyrillic_lje", GDK_Cyrillic_lje },
  { "GDK_Serbian_lje", GDK_Serbian_lje },
  { "GDK_Cyrillic_nje", GDK_Cyrillic_nje },
  { "GDK_Serbian_nje", GDK_Serbian_nje },
  { "GDK_Serbian_tshe", GDK_Serbian_tshe },
  { "GDK_Macedonia_kje", GDK_Macedonia_kje },
  { "GDK_Byelorussian_shortu", GDK_Byelorussian_shortu },
  { "GDK_Cyrillic_dzhe", GDK_Cyrillic_dzhe },
  { "GDK_Serbian_dze", GDK_Serbian_dze },
  { "GDK_numerosign", GDK_numerosign },
  { "GDK_Serbian_DJE", GDK_Serbian_DJE },
  { "GDK_Macedonia_GJE", GDK_Macedonia_GJE },
  { "GDK_Cyrillic_IO", GDK_Cyrillic_IO },
  { "GDK_Ukrainian_IE", GDK_Ukrainian_IE },
  { "GDK_Ukranian_JE", GDK_Ukranian_JE },
  { "GDK_Macedonia_DSE", GDK_Macedonia_DSE },
  { "GDK_Ukrainian_I", GDK_Ukrainian_I },
  { "GDK_Ukranian_I", GDK_Ukranian_I },
  { "GDK_Ukrainian_YI", GDK_Ukrainian_YI },
  { "GDK_Ukranian_YI", GDK_Ukranian_YI },
  { "GDK_Cyrillic_JE", GDK_Cyrillic_JE },
  { "GDK_Serbian_JE", GDK_Serbian_JE },
  { "GDK_Cyrillic_LJE", GDK_Cyrillic_LJE },
  { "GDK_Serbian_LJE", GDK_Serbian_LJE },
  { "GDK_Cyrillic_NJE", GDK_Cyrillic_NJE },
  { "GDK_Serbian_NJE", GDK_Serbian_NJE },
  { "GDK_Serbian_TSHE", GDK_Serbian_TSHE },
  { "GDK_Macedonia_KJE", GDK_Macedonia_KJE },
  { "GDK_Byelorussian_SHORTU", GDK_Byelorussian_SHORTU },
  { "GDK_Cyrillic_DZHE", GDK_Cyrillic_DZHE },
  { "GDK_Serbian_DZE", GDK_Serbian_DZE },
  { "GDK_Cyrillic_yu", GDK_Cyrillic_yu },
  { "GDK_Cyrillic_a", GDK_Cyrillic_a },
  { "GDK_Cyrillic_be", GDK_Cyrillic_be },
  { "GDK_Cyrillic_tse", GDK_Cyrillic_tse },
  { "GDK_Cyrillic_de", GDK_Cyrillic_de },
  { "GDK_Cyrillic_ie", GDK_Cyrillic_ie },
  { "GDK_Cyrillic_ef", GDK_Cyrillic_ef },
  { "GDK_Cyrillic_ghe", GDK_Cyrillic_ghe },
  { "GDK_Cyrillic_ha", GDK_Cyrillic_ha },
  { "GDK_Cyrillic_i", GDK_Cyrillic_i },
  { "GDK_Cyrillic_shorti", GDK_Cyrillic_shorti },
  { "GDK_Cyrillic_ka", GDK_Cyrillic_ka },
  { "GDK_Cyrillic_el", GDK_Cyrillic_el },
  { "GDK_Cyrillic_em", GDK_Cyrillic_em },
  { "GDK_Cyrillic_en", GDK_Cyrillic_en },
  { "GDK_Cyrillic_o", GDK_Cyrillic_o },
  { "GDK_Cyrillic_pe", GDK_Cyrillic_pe },
  { "GDK_Cyrillic_ya", GDK_Cyrillic_ya },
  { "GDK_Cyrillic_er", GDK_Cyrillic_er },
  { "GDK_Cyrillic_es", GDK_Cyrillic_es },
  { "GDK_Cyrillic_te", GDK_Cyrillic_te },
  { "GDK_Cyrillic_u", GDK_Cyrillic_u },
  { "GDK_Cyrillic_zhe", GDK_Cyrillic_zhe },
  { "GDK_Cyrillic_ve", GDK_Cyrillic_ve },
  { "GDK_Cyrillic_softsign", GDK_Cyrillic_softsign },
  { "GDK_Cyrillic_yeru", GDK_Cyrillic_yeru },
  { "GDK_Cyrillic_ze", GDK_Cyrillic_ze },
  { "GDK_Cyrillic_sha", GDK_Cyrillic_sha },
  { "GDK_Cyrillic_e", GDK_Cyrillic_e },
  { "GDK_Cyrillic_shcha", GDK_Cyrillic_shcha },
  { "GDK_Cyrillic_che", GDK_Cyrillic_che },
  { "GDK_Cyrillic_hardsign", GDK_Cyrillic_hardsign },
  { "GDK_Cyrillic_YU", GDK_Cyrillic_YU },
  { "GDK_Cyrillic_A", GDK_Cyrillic_A },
  { "GDK_Cyrillic_BE", GDK_Cyrillic_BE },
  { "GDK_Cyrillic_TSE", GDK_Cyrillic_TSE },
  { "GDK_Cyrillic_DE", GDK_Cyrillic_DE },
  { "GDK_Cyrillic_IE", GDK_Cyrillic_IE },
  { "GDK_Cyrillic_EF", GDK_Cyrillic_EF },
  { "GDK_Cyrillic_GHE", GDK_Cyrillic_GHE },
  { "GDK_Cyrillic_HA", GDK_Cyrillic_HA },
  { "GDK_Cyrillic_I", GDK_Cyrillic_I },
  { "GDK_Cyrillic_SHORTI", GDK_Cyrillic_SHORTI },
  { "GDK_Cyrillic_KA", GDK_Cyrillic_KA },
  { "GDK_Cyrillic_EL", GDK_Cyrillic_EL },
  { "GDK_Cyrillic_EM", GDK_Cyrillic_EM },
  { "GDK_Cyrillic_EN", GDK_Cyrillic_EN },
  { "GDK_Cyrillic_O", GDK_Cyrillic_O },
  { "GDK_Cyrillic_PE", GDK_Cyrillic_PE },
  { "GDK_Cyrillic_YA", GDK_Cyrillic_YA },
  { "GDK_Cyrillic_ER", GDK_Cyrillic_ER },
  { "GDK_Cyrillic_ES", GDK_Cyrillic_ES },
  { "GDK_Cyrillic_TE", GDK_Cyrillic_TE },
  { "GDK_Cyrillic_U", GDK_Cyrillic_U },
  { "GDK_Cyrillic_ZHE", GDK_Cyrillic_ZHE },
  { "GDK_Cyrillic_VE", GDK_Cyrillic_VE },
  { "GDK_Cyrillic_SOFTSIGN", GDK_Cyrillic_SOFTSIGN },
  { "GDK_Cyrillic_YERU", GDK_Cyrillic_YERU },
  { "GDK_Cyrillic_ZE", GDK_Cyrillic_ZE },
  { "GDK_Cyrillic_SHA", GDK_Cyrillic_SHA },
  { "GDK_Cyrillic_E", GDK_Cyrillic_E },
  { "GDK_Cyrillic_SHCHA", GDK_Cyrillic_SHCHA },
  { "GDK_Cyrillic_CHE", GDK_Cyrillic_CHE },
  { "GDK_Cyrillic_HARDSIGN", GDK_Cyrillic_HARDSIGN },
  { "GDK_Greek_ALPHAaccent", GDK_Greek_ALPHAaccent },
  { "GDK_Greek_EPSILONaccent", GDK_Greek_EPSILONaccent },
  { "GDK_Greek_ETAaccent", GDK_Greek_ETAaccent },
  { "GDK_Greek_IOTAaccent", GDK_Greek_IOTAaccent },
  { "GDK_Greek_IOTAdiaeresis", GDK_Greek_IOTAdiaeresis },
  { "GDK_Greek_OMICRONaccent", GDK_Greek_OMICRONaccent },
  { "GDK_Greek_UPSILONaccent", GDK_Greek_UPSILONaccent },
  { "GDK_Greek_UPSILONdieresis", GDK_Greek_UPSILONdieresis },
  { "GDK_Greek_OMEGAaccent", GDK_Greek_OMEGAaccent },
  { "GDK_Greek_accentdieresis", GDK_Greek_accentdieresis },
  { "GDK_Greek_horizbar", GDK_Greek_horizbar },
  { "GDK_Greek_alphaaccent", GDK_Greek_alphaaccent },
  { "GDK_Greek_epsilonaccent", GDK_Greek_epsilonaccent },
  { "GDK_Greek_etaaccent", GDK_Greek_etaaccent },
  { "GDK_Greek_iotaaccent", GDK_Greek_iotaaccent },
  { "GDK_Greek_iotadieresis", GDK_Greek_iotadieresis },
  { "GDK_Greek_iotaaccentdieresis", GDK_Greek_iotaaccentdieresis },
  { "GDK_Greek_omicronaccent", GDK_Greek_omicronaccent },
  { "GDK_Greek_upsilonaccent", GDK_Greek_upsilonaccent },
  { "GDK_Greek_upsilondieresis", GDK_Greek_upsilondieresis },
  { "GDK_Greek_upsilonaccentdieresis", GDK_Greek_upsilonaccentdieresis },
  { "GDK_Greek_omegaaccent", GDK_Greek_omegaaccent },
  { "GDK_Greek_ALPHA", GDK_Greek_ALPHA },
  { "GDK_Greek_BETA", GDK_Greek_BETA },
  { "GDK_Greek_GAMMA", GDK_Greek_GAMMA },
  { "GDK_Greek_DELTA", GDK_Greek_DELTA },
  { "GDK_Greek_EPSILON", GDK_Greek_EPSILON },
  { "GDK_Greek_ZETA", GDK_Greek_ZETA },
  { "GDK_Greek_ETA", GDK_Greek_ETA },
  { "GDK_Greek_THETA", GDK_Greek_THETA },
  { "GDK_Greek_IOTA", GDK_Greek_IOTA },
  { "GDK_Greek_KAPPA", GDK_Greek_KAPPA },
  { "GDK_Greek_LAMDA", GDK_Greek_LAMDA },
  { "GDK_Greek_LAMBDA", GDK_Greek_LAMBDA },
  { "GDK_Greek_MU", GDK_Greek_MU },
  { "GDK_Greek_NU", GDK_Greek_NU },
  { "GDK_Greek_XI", GDK_Greek_XI },
  { "GDK_Greek_OMICRON", GDK_Greek_OMICRON },
  { "GDK_Greek_PI", GDK_Greek_PI },
  { "GDK_Greek_RHO", GDK_Greek_RHO },
  { "GDK_Greek_SIGMA", GDK_Greek_SIGMA },
  { "GDK_Greek_TAU", GDK_Greek_TAU },
  { "GDK_Greek_UPSILON", GDK_Greek_UPSILON },
  { "GDK_Greek_PHI", GDK_Greek_PHI },
  { "GDK_Greek_CHI", GDK_Greek_CHI },
  { "GDK_Greek_PSI", GDK_Greek_PSI },
  { "GDK_Greek_OMEGA", GDK_Greek_OMEGA },
  { "GDK_Greek_alpha", GDK_Greek_alpha },
  { "GDK_Greek_beta", GDK_Greek_beta },
  { "GDK_Greek_gamma", GDK_Greek_gamma },
  { "GDK_Greek_delta", GDK_Greek_delta },
  { "GDK_Greek_epsilon", GDK_Greek_epsilon },
  { "GDK_Greek_zeta", GDK_Greek_zeta },
  { "GDK_Greek_eta", GDK_Greek_eta },
  { "GDK_Greek_theta", GDK_Greek_theta },
  { "GDK_Greek_iota", GDK_Greek_iota },
  { "GDK_Greek_kappa", GDK_Greek_kappa },
  { "GDK_Greek_lamda", GDK_Greek_lamda },
  { "GDK_Greek_lambda", GDK_Greek_lambda },
  { "GDK_Greek_mu", GDK_Greek_mu },
  { "GDK_Greek_nu", GDK_Greek_nu },
  { "GDK_Greek_xi", GDK_Greek_xi },
  { "GDK_Greek_omicron", GDK_Greek_omicron },
  { "GDK_Greek_pi", GDK_Greek_pi },
  { "GDK_Greek_rho", GDK_Greek_rho },
  { "GDK_Greek_sigma", GDK_Greek_sigma },
  { "GDK_Greek_finalsmallsigma", GDK_Greek_finalsmallsigma },
  { "GDK_Greek_tau", GDK_Greek_tau },
  { "GDK_Greek_upsilon", GDK_Greek_upsilon },
  { "GDK_Greek_phi", GDK_Greek_phi },
  { "GDK_Greek_chi", GDK_Greek_chi },
  { "GDK_Greek_psi", GDK_Greek_psi },
  { "GDK_Greek_omega", GDK_Greek_omega },
  { "GDK_Greek_switch", GDK_Greek_switch },
  { "GDK_leftradical", GDK_leftradical },
  { "GDK_topleftradical", GDK_topleftradical },
  { "GDK_horizconnector", GDK_horizconnector },
  { "GDK_topintegral", GDK_topintegral },
  { "GDK_botintegral", GDK_botintegral },
  { "GDK_vertconnector", GDK_vertconnector },
  { "GDK_topleftsqbracket", GDK_topleftsqbracket },
  { "GDK_botleftsqbracket", GDK_botleftsqbracket },
  { "GDK_toprightsqbracket", GDK_toprightsqbracket },
  { "GDK_botrightsqbracket", GDK_botrightsqbracket },
  { "GDK_topleftparens", GDK_topleftparens },
  { "GDK_botleftparens", GDK_botleftparens },
  { "GDK_toprightparens", GDK_toprightparens },
  { "GDK_botrightparens", GDK_botrightparens },
  { "GDK_leftmiddlecurlybrace", GDK_leftmiddlecurlybrace },
  { "GDK_rightmiddlecurlybrace", GDK_rightmiddlecurlybrace },
  { "GDK_topleftsummation", GDK_topleftsummation },
  { "GDK_botleftsummation", GDK_botleftsummation },
  { "GDK_topvertsummationconnector", GDK_topvertsummationconnector },
  { "GDK_botvertsummationconnector", GDK_botvertsummationconnector },
  { "GDK_toprightsummation", GDK_toprightsummation },
  { "GDK_botrightsummation", GDK_botrightsummation },
  { "GDK_rightmiddlesummation", GDK_rightmiddlesummation },
  { "GDK_lessthanequal", GDK_lessthanequal },
  { "GDK_notequal", GDK_notequal },
  { "GDK_greaterthanequal", GDK_greaterthanequal },
  { "GDK_integral", GDK_integral },
  { "GDK_therefore", GDK_therefore },
  { "GDK_variation", GDK_variation },
  { "GDK_infinity", GDK_infinity },
  { "GDK_nabla", GDK_nabla },
  { "GDK_approximate", GDK_approximate },
  { "GDK_similarequal", GDK_similarequal },
  { "GDK_ifonlyif", GDK_ifonlyif },
  { "GDK_implies", GDK_implies },
  { "GDK_identical", GDK_identical },
  { "GDK_radical", GDK_radical },
  { "GDK_includedin", GDK_includedin },
  { "GDK_includes", GDK_includes },
  { "GDK_intersection", GDK_intersection },
  { "GDK_union", GDK_union },
  { "GDK_logicaland", GDK_logicaland },
  { "GDK_logicalor", GDK_logicalor },
  { "GDK_partialderivative", GDK_partialderivative },
  { "GDK_function", GDK_function },
  { "GDK_leftarrow", GDK_leftarrow },
  { "GDK_uparrow", GDK_uparrow },
  { "GDK_rightarrow", GDK_rightarrow },
  { "GDK_downarrow", GDK_downarrow },
  { "GDK_blank", GDK_blank },
  { "GDK_soliddiamond", GDK_soliddiamond },
  { "GDK_checkerboard", GDK_checkerboard },
  { "GDK_ht", GDK_ht },
  { "GDK_ff", GDK_ff },
  { "GDK_cr", GDK_cr },
  { "GDK_lf", GDK_lf },
  { "GDK_nl", GDK_nl },
  { "GDK_vt", GDK_vt },
  { "GDK_lowrightcorner", GDK_lowrightcorner },
  { "GDK_uprightcorner", GDK_uprightcorner },
  { "GDK_upleftcorner", GDK_upleftcorner },
  { "GDK_lowleftcorner", GDK_lowleftcorner },
  { "GDK_crossinglines", GDK_crossinglines },
  { "GDK_horizlinescan1", GDK_horizlinescan1 },
  { "GDK_horizlinescan3", GDK_horizlinescan3 },
  { "GDK_horizlinescan5", GDK_horizlinescan5 },
  { "GDK_horizlinescan7", GDK_horizlinescan7 },
  { "GDK_horizlinescan9", GDK_horizlinescan9 },
  { "GDK_leftt", GDK_leftt },
  { "GDK_rightt", GDK_rightt },
  { "GDK_bott", GDK_bott },
  { "GDK_topt", GDK_topt },
  { "GDK_vertbar", GDK_vertbar },
  { "GDK_emspace", GDK_emspace },
  { "GDK_enspace", GDK_enspace },
  { "GDK_em3space", GDK_em3space },
  { "GDK_em4space", GDK_em4space },
  { "GDK_digitspace", GDK_digitspace },
  { "GDK_punctspace", GDK_punctspace },
  { "GDK_thinspace", GDK_thinspace },
  { "GDK_hairspace", GDK_hairspace },
  { "GDK_emdash", GDK_emdash },
  { "GDK_endash", GDK_endash },
  { "GDK_signifblank", GDK_signifblank },
  { "GDK_ellipsis", GDK_ellipsis },
  { "GDK_doubbaselinedot", GDK_doubbaselinedot },
  { "GDK_onethird", GDK_onethird },
  { "GDK_twothirds", GDK_twothirds },
  { "GDK_onefifth", GDK_onefifth },
  { "GDK_twofifths", GDK_twofifths },
  { "GDK_threefifths", GDK_threefifths },
  { "GDK_fourfifths", GDK_fourfifths },
  { "GDK_onesixth", GDK_onesixth },
  { "GDK_fivesixths", GDK_fivesixths },
  { "GDK_careof", GDK_careof },
  { "GDK_figdash", GDK_figdash },
  { "GDK_leftanglebracket", GDK_leftanglebracket },
  { "GDK_decimalpoint", GDK_decimalpoint },
  { "GDK_rightanglebracket", GDK_rightanglebracket },
  { "GDK_marker", GDK_marker },
  { "GDK_oneeighth", GDK_oneeighth },
  { "GDK_threeeighths", GDK_threeeighths },
  { "GDK_fiveeighths", GDK_fiveeighths },
  { "GDK_seveneighths", GDK_seveneighths },
  { "GDK_trademark", GDK_trademark },
  { "GDK_signaturemark", GDK_signaturemark },
  { "GDK_trademarkincircle", GDK_trademarkincircle },
  { "GDK_leftopentriangle", GDK_leftopentriangle },
  { "GDK_rightopentriangle", GDK_rightopentriangle },
  { "GDK_emopencircle", GDK_emopencircle },
  { "GDK_emopenrectangle", GDK_emopenrectangle },
  { "GDK_leftsinglequotemark", GDK_leftsinglequotemark },
  { "GDK_rightsinglequotemark", GDK_rightsinglequotemark },
  { "GDK_leftdoublequotemark", GDK_leftdoublequotemark },
  { "GDK_rightdoublequotemark", GDK_rightdoublequotemark },
  { "GDK_prescription", GDK_prescription },
  { "GDK_minutes", GDK_minutes },
  { "GDK_seconds", GDK_seconds },
  { "GDK_latincross", GDK_latincross },
  { "GDK_hexagram", GDK_hexagram },
  { "GDK_filledrectbullet", GDK_filledrectbullet },
  { "GDK_filledlefttribullet", GDK_filledlefttribullet },
  { "GDK_filledrighttribullet", GDK_filledrighttribullet },
  { "GDK_emfilledcircle", GDK_emfilledcircle },
  { "GDK_emfilledrect", GDK_emfilledrect },
  { "GDK_enopencircbullet", GDK_enopencircbullet },
  { "GDK_enopensquarebullet", GDK_enopensquarebullet },
  { "GDK_openrectbullet", GDK_openrectbullet },
  { "GDK_opentribulletup", GDK_opentribulletup },
  { "GDK_opentribulletdown", GDK_opentribulletdown },
  { "GDK_openstar", GDK_openstar },
  { "GDK_enfilledcircbullet", GDK_enfilledcircbullet },
  { "GDK_enfilledsqbullet", GDK_enfilledsqbullet },
  { "GDK_filledtribulletup", GDK_filledtribulletup },
  { "GDK_filledtribulletdown", GDK_filledtribulletdown },
  { "GDK_leftpointer", GDK_leftpointer },
  { "GDK_rightpointer", GDK_rightpointer },
  { "GDK_club", GDK_club },
  { "GDK_diamond", GDK_diamond },
  { "GDK_heart", GDK_heart },
  { "GDK_maltesecross", GDK_maltesecross },
  { "GDK_dagger", GDK_dagger },
  { "GDK_doubledagger", GDK_doubledagger },
  { "GDK_checkmark", GDK_checkmark },
  { "GDK_ballotcross", GDK_ballotcross },
  { "GDK_musicalsharp", GDK_musicalsharp },
  { "GDK_musicalflat", GDK_musicalflat },
  { "GDK_malesymbol", GDK_malesymbol },
  { "GDK_femalesymbol", GDK_femalesymbol },
  { "GDK_telephone", GDK_telephone },
  { "GDK_telephonerecorder", GDK_telephonerecorder },
  { "GDK_phonographcopyright", GDK_phonographcopyright },
  { "GDK_caret", GDK_caret },
  { "GDK_singlelowquotemark", GDK_singlelowquotemark },
  { "GDK_doublelowquotemark", GDK_doublelowquotemark },
  { "GDK_cursor", GDK_cursor },
  { "GDK_leftcaret", GDK_leftcaret },
  { "GDK_rightcaret", GDK_rightcaret },
  { "GDK_downcaret", GDK_downcaret },
  { "GDK_upcaret", GDK_upcaret },
  { "GDK_overbar", GDK_overbar },
  { "GDK_downtack", GDK_downtack },
  { "GDK_upshoe", GDK_upshoe },
  { "GDK_downstile", GDK_downstile },
  { "GDK_underbar", GDK_underbar },
  { "GDK_jot", GDK_jot },
  { "GDK_quad", GDK_quad },
  { "GDK_uptack", GDK_uptack },
  { "GDK_circle", GDK_circle },
  { "GDK_upstile", GDK_upstile },
  { "GDK_downshoe", GDK_downshoe },
  { "GDK_rightshoe", GDK_rightshoe },
  { "GDK_leftshoe", GDK_leftshoe },
  { "GDK_lefttack", GDK_lefttack },
  { "GDK_righttack", GDK_righttack },
  { "GDK_hebrew_doublelowline", GDK_hebrew_doublelowline },
  { "GDK_hebrew_aleph", GDK_hebrew_aleph },
  { "GDK_hebrew_bet", GDK_hebrew_bet },
  { "GDK_hebrew_beth", GDK_hebrew_beth },
  { "GDK_hebrew_gimel", GDK_hebrew_gimel },
  { "GDK_hebrew_gimmel", GDK_hebrew_gimmel },
  { "GDK_hebrew_dalet", GDK_hebrew_dalet },
  { "GDK_hebrew_daleth", GDK_hebrew_daleth },
  { "GDK_hebrew_he", GDK_hebrew_he },
  { "GDK_hebrew_waw", GDK_hebrew_waw },
  { "GDK_hebrew_zain", GDK_hebrew_zain },
  { "GDK_hebrew_zayin", GDK_hebrew_zayin },
  { "GDK_hebrew_chet", GDK_hebrew_chet },
  { "GDK_hebrew_het", GDK_hebrew_het },
  { "GDK_hebrew_tet", GDK_hebrew_tet },
  { "GDK_hebrew_teth", GDK_hebrew_teth },
  { "GDK_hebrew_yod", GDK_hebrew_yod },
  { "GDK_hebrew_finalkaph", GDK_hebrew_finalkaph },
  { "GDK_hebrew_kaph", GDK_hebrew_kaph },
  { "GDK_hebrew_lamed", GDK_hebrew_lamed },
  { "GDK_hebrew_finalmem", GDK_hebrew_finalmem },
  { "GDK_hebrew_mem", GDK_hebrew_mem },
  { "GDK_hebrew_finalnun", GDK_hebrew_finalnun },
  { "GDK_hebrew_nun", GDK_hebrew_nun },
  { "GDK_hebrew_samech", GDK_hebrew_samech },
  { "GDK_hebrew_samekh", GDK_hebrew_samekh },
  { "GDK_hebrew_ayin", GDK_hebrew_ayin },
  { "GDK_hebrew_finalpe", GDK_hebrew_finalpe },
  { "GDK_hebrew_pe", GDK_hebrew_pe },
  { "GDK_hebrew_finalzade", GDK_hebrew_finalzade },
  { "GDK_hebrew_finalzadi", GDK_hebrew_finalzadi },
  { "GDK_hebrew_zade", GDK_hebrew_zade },
  { "GDK_hebrew_zadi", GDK_hebrew_zadi },
  { "GDK_hebrew_qoph", GDK_hebrew_qoph },
  { "GDK_hebrew_kuf", GDK_hebrew_kuf },
  { "GDK_hebrew_resh", GDK_hebrew_resh },
  { "GDK_hebrew_shin", GDK_hebrew_shin },
  { "GDK_hebrew_taw", GDK_hebrew_taw },
  { "GDK_hebrew_taf", GDK_hebrew_taf },
  { "GDK_Hebrew_switch", GDK_Hebrew_switch },
  { "GDK_Thai_kokai", GDK_Thai_kokai },
  { "GDK_Thai_khokhai", GDK_Thai_khokhai },
  { "GDK_Thai_khokhuat", GDK_Thai_khokhuat },
  { "GDK_Thai_khokhwai", GDK_Thai_khokhwai },
  { "GDK_Thai_khokhon", GDK_Thai_khokhon },
  { "GDK_Thai_khorakhang", GDK_Thai_khorakhang },
  { "GDK_Thai_ngongu", GDK_Thai_ngongu },
  { "GDK_Thai_chochan", GDK_Thai_chochan },
  { "GDK_Thai_choching", GDK_Thai_choching },
  { "GDK_Thai_chochang", GDK_Thai_chochang },
  { "GDK_Thai_soso", GDK_Thai_soso },
  { "GDK_Thai_chochoe", GDK_Thai_chochoe },
  { "GDK_Thai_yoying", GDK_Thai_yoying },
  { "GDK_Thai_dochada", GDK_Thai_dochada },
  { "GDK_Thai_topatak", GDK_Thai_topatak },
  { "GDK_Thai_thothan", GDK_Thai_thothan },
  { "GDK_Thai_thonangmontho", GDK_Thai_thonangmontho },
  { "GDK_Thai_thophuthao", GDK_Thai_thophuthao },
  { "GDK_Thai_nonen", GDK_Thai_nonen },
  { "GDK_Thai_dodek", GDK_Thai_dodek },
  { "GDK_Thai_totao", GDK_Thai_totao },
  { "GDK_Thai_thothung", GDK_Thai_thothung },
  { "GDK_Thai_thothahan", GDK_Thai_thothahan },
  { "GDK_Thai_thothong", GDK_Thai_thothong },
  { "GDK_Thai_nonu", GDK_Thai_nonu },
  { "GDK_Thai_bobaimai", GDK_Thai_bobaimai },
  { "GDK_Thai_popla", GDK_Thai_popla },
  { "GDK_Thai_phophung", GDK_Thai_phophung },
  { "GDK_Thai_fofa", GDK_Thai_fofa },
  { "GDK_Thai_phophan", GDK_Thai_phophan },
  { "GDK_Thai_fofan", GDK_Thai_fofan },
  { "GDK_Thai_phosamphao", GDK_Thai_phosamphao },
  { "GDK_Thai_moma", GDK_Thai_moma },
  { "GDK_Thai_yoyak", GDK_Thai_yoyak },
  { "GDK_Thai_rorua", GDK_Thai_rorua },
  { "GDK_Thai_ru", GDK_Thai_ru },
  { "GDK_Thai_loling", GDK_Thai_loling },
  { "GDK_Thai_lu", GDK_Thai_lu },
  { "GDK_Thai_wowaen", GDK_Thai_wowaen },
  { "GDK_Thai_sosala", GDK_Thai_sosala },
  { "GDK_Thai_sorusi", GDK_Thai_sorusi },
  { "GDK_Thai_sosua", GDK_Thai_sosua },
  { "GDK_Thai_hohip", GDK_Thai_hohip },
  { "GDK_Thai_lochula", GDK_Thai_lochula },
  { "GDK_Thai_oang", GDK_Thai_oang },
  { "GDK_Thai_honokhuk", GDK_Thai_honokhuk },
  { "GDK_Thai_paiyannoi", GDK_Thai_paiyannoi },
  { "GDK_Thai_saraa", GDK_Thai_saraa },
  { "GDK_Thai_maihanakat", GDK_Thai_maihanakat },
  { "GDK_Thai_saraaa", GDK_Thai_saraaa },
  { "GDK_Thai_saraam", GDK_Thai_saraam },
  { "GDK_Thai_sarai", GDK_Thai_sarai },
  { "GDK_Thai_saraii", GDK_Thai_saraii },
  { "GDK_Thai_saraue", GDK_Thai_saraue },
  { "GDK_Thai_sarauee", GDK_Thai_sarauee },
  { "GDK_Thai_sarau", GDK_Thai_sarau },
  { "GDK_Thai_sarauu", GDK_Thai_sarauu },
  { "GDK_Thai_phinthu", GDK_Thai_phinthu },
  { "GDK_Thai_maihanakat_maitho", GDK_Thai_maihanakat_maitho },
  { "GDK_Thai_baht", GDK_Thai_baht },
  { "GDK_Thai_sarae", GDK_Thai_sarae },
  { "GDK_Thai_saraae", GDK_Thai_saraae },
  { "GDK_Thai_sarao", GDK_Thai_sarao },
  { "GDK_Thai_saraaimaimuan", GDK_Thai_saraaimaimuan },
  { "GDK_Thai_saraaimaimalai", GDK_Thai_saraaimaimalai },
  { "GDK_Thai_lakkhangyao", GDK_Thai_lakkhangyao },
  { "GDK_Thai_maiyamok", GDK_Thai_maiyamok },
  { "GDK_Thai_maitaikhu", GDK_Thai_maitaikhu },
  { "GDK_Thai_maiek", GDK_Thai_maiek },
  { "GDK_Thai_maitho", GDK_Thai_maitho },
  { "GDK_Thai_maitri", GDK_Thai_maitri },
  { "GDK_Thai_maichattawa", GDK_Thai_maichattawa },
  { "GDK_Thai_thanthakhat", GDK_Thai_thanthakhat },
  { "GDK_Thai_nikhahit", GDK_Thai_nikhahit },
  { "GDK_Thai_leksun", GDK_Thai_leksun },
  { "GDK_Thai_leknung", GDK_Thai_leknung },
  { "GDK_Thai_leksong", GDK_Thai_leksong },
  { "GDK_Thai_leksam", GDK_Thai_leksam },
  { "GDK_Thai_leksi", GDK_Thai_leksi },
  { "GDK_Thai_lekha", GDK_Thai_lekha },
  { "GDK_Thai_lekhok", GDK_Thai_lekhok },
  { "GDK_Thai_lekchet", GDK_Thai_lekchet },
  { "GDK_Thai_lekpaet", GDK_Thai_lekpaet },
  { "GDK_Thai_lekkao", GDK_Thai_lekkao },
  { "GDK_Hangul", GDK_Hangul },
  { "GDK_Hangul_Start", GDK_Hangul_Start },
  { "GDK_Hangul_End", GDK_Hangul_End },
  { "GDK_Hangul_Hanja", GDK_Hangul_Hanja },
  { "GDK_Hangul_Jamo", GDK_Hangul_Jamo },
  { "GDK_Hangul_Romaja", GDK_Hangul_Romaja },
  { "GDK_Hangul_Codeinput", GDK_Hangul_Codeinput },
  { "GDK_Hangul_Jeonja", GDK_Hangul_Jeonja },
  { "GDK_Hangul_Banja", GDK_Hangul_Banja },
  { "GDK_Hangul_PreHanja", GDK_Hangul_PreHanja },
  { "GDK_Hangul_PostHanja", GDK_Hangul_PostHanja },
  { "GDK_Hangul_SingleCandidate", GDK_Hangul_SingleCandidate },
  { "GDK_Hangul_MultipleCandidate", GDK_Hangul_MultipleCandidate },
  { "GDK_Hangul_PreviousCandidate", GDK_Hangul_PreviousCandidate },
  { "GDK_Hangul_Special", GDK_Hangul_Special },
  { "GDK_Hangul_switch", GDK_Hangul_switch },
  { "GDK_Hangul_Kiyeog", GDK_Hangul_Kiyeog },
  { "GDK_Hangul_SsangKiyeog", GDK_Hangul_SsangKiyeog },
  { "GDK_Hangul_KiyeogSios", GDK_Hangul_KiyeogSios },
  { "GDK_Hangul_Nieun", GDK_Hangul_Nieun },
  { "GDK_Hangul_NieunJieuj", GDK_Hangul_NieunJieuj },
  { "GDK_Hangul_NieunHieuh", GDK_Hangul_NieunHieuh },
  { "GDK_Hangul_Dikeud", GDK_Hangul_Dikeud },
  { "GDK_Hangul_SsangDikeud", GDK_Hangul_SsangDikeud },
  { "GDK_Hangul_Rieul", GDK_Hangul_Rieul },
  { "GDK_Hangul_RieulKiyeog", GDK_Hangul_RieulKiyeog },
  { "GDK_Hangul_RieulMieum", GDK_Hangul_RieulMieum },
  { "GDK_Hangul_RieulPieub", GDK_Hangul_RieulPieub },
  { "GDK_Hangul_RieulSios", GDK_Hangul_RieulSios },
  { "GDK_Hangul_RieulTieut", GDK_Hangul_RieulTieut },
  { "GDK_Hangul_RieulPhieuf", GDK_Hangul_RieulPhieuf },
  { "GDK_Hangul_RieulHieuh", GDK_Hangul_RieulHieuh },
  { "GDK_Hangul_Mieum", GDK_Hangul_Mieum },
  { "GDK_Hangul_Pieub", GDK_Hangul_Pieub },
  { "GDK_Hangul_SsangPieub", GDK_Hangul_SsangPieub },
  { "GDK_Hangul_PieubSios", GDK_Hangul_PieubSios },
  { "GDK_Hangul_Sios", GDK_Hangul_Sios },
  { "GDK_Hangul_SsangSios", GDK_Hangul_SsangSios },
  { "GDK_Hangul_Ieung", GDK_Hangul_Ieung },
  { "GDK_Hangul_Jieuj", GDK_Hangul_Jieuj },
  { "GDK_Hangul_SsangJieuj", GDK_Hangul_SsangJieuj },
  { "GDK_Hangul_Cieuc", GDK_Hangul_Cieuc },
  { "GDK_Hangul_Khieuq", GDK_Hangul_Khieuq },
  { "GDK_Hangul_Tieut", GDK_Hangul_Tieut },
  { "GDK_Hangul_Phieuf", GDK_Hangul_Phieuf },
  { "GDK_Hangul_Hieuh", GDK_Hangul_Hieuh },
  { "GDK_Hangul_A", GDK_Hangul_A },
  { "GDK_Hangul_AE", GDK_Hangul_AE },
  { "GDK_Hangul_YA", GDK_Hangul_YA },
  { "GDK_Hangul_YAE", GDK_Hangul_YAE },
  { "GDK_Hangul_EO", GDK_Hangul_EO },
  { "GDK_Hangul_E", GDK_Hangul_E },
  { "GDK_Hangul_YEO", GDK_Hangul_YEO },
  { "GDK_Hangul_YE", GDK_Hangul_YE },
  { "GDK_Hangul_O", GDK_Hangul_O },
  { "GDK_Hangul_WA", GDK_Hangul_WA },
  { "GDK_Hangul_WAE", GDK_Hangul_WAE },
  { "GDK_Hangul_OE", GDK_Hangul_OE },
  { "GDK_Hangul_YO", GDK_Hangul_YO },
  { "GDK_Hangul_U", GDK_Hangul_U },
  { "GDK_Hangul_WEO", GDK_Hangul_WEO },
  { "GDK_Hangul_WE", GDK_Hangul_WE },
  { "GDK_Hangul_WI", GDK_Hangul_WI },
  { "GDK_Hangul_YU", GDK_Hangul_YU },
  { "GDK_Hangul_EU", GDK_Hangul_EU },
  { "GDK_Hangul_YI", GDK_Hangul_YI },
  { "GDK_Hangul_I", GDK_Hangul_I },
  { "GDK_Hangul_J_Kiyeog", GDK_Hangul_J_Kiyeog },
  { "GDK_Hangul_J_SsangKiyeog", GDK_Hangul_J_SsangKiyeog },
  { "GDK_Hangul_J_KiyeogSios", GDK_Hangul_J_KiyeogSios },
  { "GDK_Hangul_J_Nieun", GDK_Hangul_J_Nieun },
  { "GDK_Hangul_J_NieunJieuj", GDK_Hangul_J_NieunJieuj },
  { "GDK_Hangul_J_NieunHieuh", GDK_Hangul_J_NieunHieuh },
  { "GDK_Hangul_J_Dikeud", GDK_Hangul_J_Dikeud },
  { "GDK_Hangul_J_Rieul", GDK_Hangul_J_Rieul },
  { "GDK_Hangul_J_RieulKiyeog", GDK_Hangul_J_RieulKiyeog },
  { "GDK_Hangul_J_RieulMieum", GDK_Hangul_J_RieulMieum },
  { "GDK_Hangul_J_RieulPieub", GDK_Hangul_J_RieulPieub },
  { "GDK_Hangul_J_RieulSios", GDK_Hangul_J_RieulSios },
  { "GDK_Hangul_J_RieulTieut", GDK_Hangul_J_RieulTieut },
  { "GDK_Hangul_J_RieulPhieuf", GDK_Hangul_J_RieulPhieuf },
  { "GDK_Hangul_J_RieulHieuh", GDK_Hangul_J_RieulHieuh },
  { "GDK_Hangul_J_Mieum", GDK_Hangul_J_Mieum },
  { "GDK_Hangul_J_Pieub", GDK_Hangul_J_Pieub },
  { "GDK_Hangul_J_PieubSios", GDK_Hangul_J_PieubSios },
  { "GDK_Hangul_J_Sios", GDK_Hangul_J_Sios },
  { "GDK_Hangul_J_SsangSios", GDK_Hangul_J_SsangSios },
  { "GDK_Hangul_J_Ieung", GDK_Hangul_J_Ieung },
  { "GDK_Hangul_J_Jieuj", GDK_Hangul_J_Jieuj },
  { "GDK_Hangul_J_Cieuc", GDK_Hangul_J_Cieuc },
  { "GDK_Hangul_J_Khieuq", GDK_Hangul_J_Khieuq },
  { "GDK_Hangul_J_Tieut", GDK_Hangul_J_Tieut },
  { "GDK_Hangul_J_Phieuf", GDK_Hangul_J_Phieuf },
  { "GDK_Hangul_J_Hieuh", GDK_Hangul_J_Hieuh },
  { "GDK_Hangul_RieulYeorinHieuh", GDK_Hangul_RieulYeorinHieuh },
  { "GDK_Hangul_SunkyeongeumMieum", GDK_Hangul_SunkyeongeumMieum },
  { "GDK_Hangul_SunkyeongeumPieub", GDK_Hangul_SunkyeongeumPieub },
  { "GDK_Hangul_PanSios", GDK_Hangul_PanSios },
  { "GDK_Hangul_KkogjiDalrinIeung", GDK_Hangul_KkogjiDalrinIeung },
  { "GDK_Hangul_SunkyeongeumPhieuf", GDK_Hangul_SunkyeongeumPhieuf },
  { "GDK_Hangul_YeorinHieuh", GDK_Hangul_YeorinHieuh },
  { "GDK_Hangul_AraeA", GDK_Hangul_AraeA },
  { "GDK_Hangul_AraeAE", GDK_Hangul_AraeAE },
  { "GDK_Hangul_J_PanSios", GDK_Hangul_J_PanSios },
  { "GDK_Hangul_J_KkogjiDalrinIeung", GDK_Hangul_J_KkogjiDalrinIeung },
  { "GDK_Hangul_J_YeorinHieuh", GDK_Hangul_J_YeorinHieuh },
  { "GDK_Korean_Won", GDK_Korean_Won },
  { NULL, 0 }
};

static GHashTable *
key_hash()
{
	static GHashTable *hash = NULL;
	if (!hash) {
		int i = 0;
		hash = g_hash_table_new(g_str_hash, g_str_equal);
		g_hash_table_freeze(hash);
		while (keys[i].str != NULL) {
			g_hash_table_insert(hash, keys[i].str, GUINT_TO_POINTER(keys[i].key));
			i++;
		}
		g_hash_table_thaw(hash);
	}
	return hash;
}

guint
glade_key_get(char *str)
{
	guint ret = GPOINTER_TO_UINT(g_hash_table_lookup(key_hash(), str));
	g_return_val_if_fail(ret != 0, 0);
	return ret;
}


