%define  ver     0.48
%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define  prefix  /usr

Summary: the GNOME spreadsheet
Name: 		gnumeric
Version: 	%ver
Release: 	%rel
Copyright: 	GPL
Group: 		Applications/Spreadsheets
Source: ftp://ftp.gnome.org/pub/GNOME/sources/gnumeric/gnumeric-%{ver}.tar.gz
Url:		http://www.gnome.org/gnumeric
BuildRoot:	/var/tmp/gnumeric-%{PACKAGE_VERSION}-root
Docdir: 	%{prefix}/doc

Requires: gtk+ >= 1.2.2
Requires: gnome-libs >= 1.0.0
Requires: gnome-print >= 0.10
Requires: libglade >= 0.11
Requires: libxml >= 1.8.5

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.  GNOME is similar in purpose and scope
to CDE and KDE, but GNOME is based completely on free software.

This is the Gnumeric, the GNOME spreadsheet program. If you are familiar with 
Excel, you should be ready to use Gnumeric.  We have tried to clone all of 
the good features and stay as compatible as possible with Excel in terms of 
usability. Hopefully we left the bugs behind :).

%prep
%setup -q

%build
%ifarch alpha
  MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif
# Configure only showing me failures.
CFLAGS="$RPM_OPT_FLAGS" ./configure --quiet --prefix=%prefix $MYARCH_FLAGS --sysconfdir=/etc

if [ "$SMP" != "" ]; then
	make -j$SMP "MAKE=make -j$SMP"
else
	make
fi

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT/etc install


%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr (444, bin, bin, 555)
%lang(cs)      /usr/share/locale/cs/LC_MESSAGES/gnumeric.mo
%lang(da)      /usr/share/locale/da/LC_MESSAGES/gnumeric.mo
%lang(de)      /usr/share/locale/de/LC_MESSAGES/gnumeric.mo
%lang(en)      /usr/share/locale/en_GB/LC_MESSAGES/gnumeric.mo
%lang(es)      /usr/share/locale/es/LC_MESSAGES/gnumeric.mo
%lang(es)      /usr/share/locale/es_DO/LC_MESSAGES/gnumeric.mo
%lang(es)      /usr/share/locale/es_GT/LC_MESSAGES/gnumeric.mo
%lang(es)      /usr/share/locale/es_HN/LC_MESSAGES/gnumeric.mo
%lang(es)      /usr/share/locale/es_MX/LC_MESSAGES/gnumeric.mo
%lang(es)      /usr/share/locale/es_PA/LC_MESSAGES/gnumeric.mo
%lang(es)      /usr/share/locale/es_PE/LC_MESSAGES/gnumeric.mo
%lang(es)      /usr/share/locale/es_SV/LC_MESSAGES/gnumeric.mo
%lang(et)      /usr/share/locale/et/LC_MESSAGES/gnumeric.mo
%lang(fi)      /usr/share/locale/fi/LC_MESSAGES/gnumeric.mo
%lang(fr)      /usr/share/locale/fr/LC_MESSAGES/gnumeric.mo
%lang(hu)      /usr/share/locale/hu/LC_MESSAGES/gnumeric.mo
%lang(hr)      /usr/share/locale/hr/LC_MESSAGES/gnumeric.mo
%lang(it)      /usr/share/locale/it/LC_MESSAGES/gnumeric.mo
%lang(ja)      /usr/share/locale/ja/LC_MESSAGES/gnumeric.mo
%lang(ko)      /usr/share/locale/ko/LC_MESSAGES/gnumeric.mo
%lang(nl)      /usr/share/locale/nl/LC_MESSAGES/gnumeric.mo
%lang(no)      /usr/share/locale/no/LC_MESSAGES/gnumeric.mo
%lang(pt)      /usr/share/locale/pt/LC_MESSAGES/gnumeric.mo
%lang(pt)      /usr/share/locale/pt_BR/LC_MESSAGES/gnumeric.mo
%lang(ru)      /usr/share/locale/ru/LC_MESSAGES/gnumeric.mo
%lang(pl)      /usr/share/locale/pl/LC_MESSAGES/gnumeric.mo
%lang(sk)      /usr/share/locale/sk/LC_MESSAGES/gnumeric.mo
%lang(zh)      /usr/share/locale/zh_TW.Big5/LC_MESSAGES/gnumeric.mo
%lang(sv)      /usr/share/locale/sv/LC_MESSAGES/gnumeric.mo

%defattr (0555, bin, bin)
%{prefix}/bin/gnumeric
%{prefix}/lib/gnumeric/plugins/%{version}/*.so.0.0.0
%{prefix}/lib/gnumeric/plugins/%{version}/*.so.0

%{prefix}/share/gnumeric/python/*
%{prefix}/share/gnumeric/glade/*.glade

%defattr (0444, bin, man, 0555)
%{prefix}/share/gnome/help/gnumeric/C/images/*
%{prefix}/share/gnome/help/gnumeric/C/*.html
%{prefix}/share/gnome/help/gnumeric/C/*.dat
%{prefix}/share/gnome/help/gnumeric/C/docbook.css
%config %{prefix}/share/gnome/apps/Applications/gnumeric.desktop
%{prefix}/share/pixmaps/gnumeric/*
%{prefix}/share/pixmaps/gnome-gnumeric.png
%{prefix}/share/pixmaps/gnome-gnumeric-xl.png
%{prefix}/share/mime-info/gnumeric.keys
%{prefix}/share/mime-info/gnumeric.mime
%{prefix}/share/mc/templates/gnumeric.desktop


%defattr (0444, bin, bin, 555)
# This should go in a devel package...
%{prefix}/share/idl/*.idl
%config %{sysconfdir}/CORBA/servers/gnumeric.gnorba
%doc HACKING AUTHORS ChangeLog NEWS README COPYING TODO

%changelog
* Mon Jan 12 2000 Jody Goldberg <jgolbderg@home.com>
- Add depend on gtk+ >= 1.2.2 so that we can get gtk_object_get.

* Mon Jan 03 2000 Gregory McLean <gregm@comstar.net>
- Updated to 0.47

* Mon Dec 20 1999 Jody Goldberg <jgolbderg@home.com>
- Updated the libglade dependancy.
- Remove req for guile.  We can build without it.

* Thu Sep 02 1999 Gregory McLean <gregm@comstar.net>
- Added small fix so glade generated dialogs appear.

* Wed Jul 14 1999 Gregory McLean <gregm@comstar.net>
- Added the gnome-print requirement.
- Updated the file list to try and quiet down the updating.
- added the sysconfdir

* Tue Mar 9  1999 Gregory McLean <gregm@comstar.net>
- Updated the spec file.

* Thu Sep 24 1998 Michael Fulbright <msf@redhat.com>
- Version 0.2

