
/*  A Bison parser, made from parser.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	NUMBER	257
#define	STRING	258
#define	FUNCALL	259
#define	CONSTANT	260
#define	CELLREF	261
#define	GTE	262
#define	LTE	263
#define	NE	264
#define	SEPARATOR	265
#define	NEG	266
#define	PLUS	267

#line 1 "parser.y"

/*
 * Gnumeric Parser
 *
 * (C) 1998-2000 the Free Software Foundation
 *
 * Author:
 *    Miguel de Icaza (miguel@gnu.org)
 *    Jody Goldberg (jgoldberg@home.com)
 *    Morten Welinder (terra@diku.dk)
 */
#include <config.h>
#include <ctype.h>
#include <string.h>
#include <locale.h>
#include <gnome.h>
#include "gnumeric.h"
#include "number-match.h"
#include "symbol.h"
#include "expr.h"
#include "expr-name.h"
#include "sheet.h"
#include "application.h"
#include "gutils.h"
#include "auto-format.h"

/* ------------------------------------------------------------------------- */
/* Allocation with disposal-on-error */

/*
 * Defined: the stack itself will be kept in use.  This isn't much, btw.
 *   This setting is good for speed.
 *
 * Not defined: memory will be freed.  The is good for finding leaks in the
 * program.  (Here and elsewhere.)
 */
#define KEEP_DEALLOCATION_STACK_BETWEEN_CALLS

/*
 * If some dork enters "=1+2+2*(1+" we have already allocated space for
 * "1+2", "2", and "1" before the parser sees the syntax error and warps
 * us to the error production in the "line" non-terminal.
 *
 * To make sure we can clean up, we register every allocation.  On success,
 * nothing should be left (except the final expression which is unregistered),
 * but on failure we must free everything allocated.
 *
 * Note: there is some room left for optimisation here.  Talk to terra@diku.dk
 * before you set out to do it.
 */

static void
free_expr_list (GList *list)
{
	GList *l;
	for (l = list; l; l = l->next)
		expr_tree_unref (l->data);
	g_list_free (list);
}

static void
free_expr_list_list (GList *list)
{
	GList *l;
	for (l = list; l; l = l->next)
		free_expr_list (l->data);
	g_list_free (list);
}

typedef void (*ParseDeallocator) (void *);
static GPtrArray *deallocate_stack;

static void
deallocate_init (void)
{
	deallocate_stack = g_ptr_array_new ();
}

#ifndef KEEP_DEALLOCATION_STACK_BETWEEN_CALLS
static void
deallocate_uninit (void)
{
	g_ptr_array_free (deallocate_stack, TRUE);
	deallocate_stack = NULL;
}
#endif

static void
deallocate_all (void)
{
	int i;

	for (i = 0; i < deallocate_stack->len; i += 2) {
		ParseDeallocator freer = g_ptr_array_index (deallocate_stack, i + 1);
		freer (g_ptr_array_index (deallocate_stack, i));
	}

	g_ptr_array_set_size (deallocate_stack, 0);
}

static void
deallocate_assert_empty (void)
{
	if (deallocate_stack->len == 0)
		return;

	g_warning ("deallocate_stack not empty as expected.");
	deallocate_all ();
}

static void *
register_allocation (void *data, ParseDeallocator freer)
{
	/* It's handy to be able to register and unregister NULLs.  */
	if (data) {
		int len;
		/*
		 * There are really only a few different freers, so we
		 * could encode the freer in the lower bits of the data
		 * pointer.  Unfortunately, no-one can predict how high
		 * Miguel would jump when he found out.
		 */
		len = deallocate_stack->len;
		g_ptr_array_set_size (deallocate_stack, len + 2);
		g_ptr_array_index (deallocate_stack, len) = data;
		g_ptr_array_index (deallocate_stack, len + 1) = freer;
	}

	/* Returning the pointer here improved readability of the caller.  */
	return data;
}

#define register_expr_allocation(expr) \
  register_allocation ((expr), (ParseDeallocator)&expr_tree_unref)

#define register_expr_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&free_expr_list)

#define register_expr_list_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&free_expr_list_list)

static void
unregister_allocation (const void *data)
{
	int pos;

	/* It's handy to be able to register and unregister NULLs.  */
	if (!data)
		return;

	pos = deallocate_stack->len - 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_set_size (deallocate_stack, pos);
		return;
	}

	/*
	 * Bummer.  In certain error cases, it is possible that the parser
	 * will reduce after it has discovered a token that will lead to an
	 * error.  "2/16/1800 00:00" (without the quotes) is an example.
	 * The first "00" is registered before the second division is
	 * reduced.
	 * 
	 * This isn't a big deal -- we will just look at the entry just below
	 * the top.
	 */
	pos -= 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_index (deallocate_stack, pos) =
			g_ptr_array_index (deallocate_stack, pos + 2);
		g_ptr_array_index (deallocate_stack, pos + 1) =
			g_ptr_array_index (deallocate_stack, pos + 3);

		g_ptr_array_set_size (deallocate_stack, pos);
		return;
	}

	g_warning ("Unbalanced allocation registration");
}

/* ------------------------------------------------------------------------- */

#define ERROR -1

/* Bison/Yacc internals */
static int  yylex (void);
static int  yyerror (char *s);

/* The expression being parsed */
static const char *parser_expr;

/* The error returned from the */
static ParseErr parser_error;

/* Location where the parsing is taking place */
static int parser_col, parser_row;

/* The workbook context */
static Workbook *parser_wb;

/* The suggested format to use for this expression */
static char **parser_desired_format;

/* Locale info.  */
static char parser_decimal_point;
static char parser_separator;
static char parser_array_col_separator;

static ExprTree **parser_result;

static ExprTree *
build_unary_op (Operation op, ExprTree *expr)
{
	unregister_allocation (expr);
	return register_expr_allocation (expr_tree_new_unary (op, expr));
}

static ExprTree *
build_binop (ExprTree *l, Operation op, ExprTree *r)
{
	unregister_allocation (r);
	unregister_allocation (l);
	return register_expr_allocation (expr_tree_new_binary (l, op, r));
}

static ExprTree *
build_array_formula (ExprTree *func, int cols, int rows, int x, int y)
{
	ExprTree *res = expr_tree_array_formula (x, y, rows, cols);

	/*
	 * Note: for a non-corner cell, caller must arrange to have the
	 * inner expression ("func") unref'ed.  This happens in
	 * cell_set_formula.
	 */
	res->u.array.corner.func.expr = func;
	return res;
}

static ExprTree *
build_array (GList *cols)
{
	Value *array;
	GList *row;
	int x, mx, y;

	if (!cols) {
		parser_error = PARSE_ERR_SYNTAX;
		return NULL;
	}

	mx  = 0;
	row = cols->data;
	while (row) {
		mx++;
		row = g_list_next (row);
	}

	array = value_new_array_empty (mx, g_list_length (cols));

	y = 0;
	while (cols) {
		row = cols->data;
		x = 0;
		while (row && x < mx) {
			ExprTree *expr = row->data;
			Value    *v = expr->u.constant;

			g_assert (expr->oper == OPER_CONSTANT);

			value_array_set (array, x, y, value_duplicate (v));

			x++;
			row = g_list_next (row);
		}
		if (x < mx || row) {
			parser_error = PARSE_ERR_SYNTAX;
			value_release (array);
			return NULL;
		}
		y++;
		cols = g_list_next (cols);
	}

	return register_expr_allocation (expr_tree_new_constant (array));
}

/* Make byacc happier */
int yyparse(void);


#line 293 "parser.y"
typedef union {
	ExprTree *tree;
	CellRef  *cell;
	GList    *list;
	Sheet	 *sheet;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		93
#define	YYFLAG		-32768
#define	YYNTBASE	35

#define YYTRANSLATE(x) ((unsigned)(x) <= 267 ? yytranslate[x] : 44)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    22,     2,     2,     2,    24,    12,     2,    27,
    28,    18,    17,    32,    16,     2,    19,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    31,    34,    13,
    15,    14,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    29,    33,    30,    23,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    25,     2,    26,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    20,    21
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,    17,    19,    21,    23,    25,    27,    31,    35,
    39,    43,    47,    51,    55,    59,    63,    67,    71,    75,
    79,    82,    85,    88,    92,    97,   100,   106,   108,   109,
   111,   114,   118,   124,   126,   130,   131,   133,   135,   137,
   141,   145,   146,   148
};

static const short yyrhs[] = {    36,
     0,    25,    36,    26,    27,     3,    11,     3,    28,    29,
     3,    30,    29,     3,    30,     0,     1,     0,     3,     0,
     4,     0,    39,     0,     6,     0,    36,    17,    36,     0,
    36,    16,    36,     0,    36,    18,    36,     0,    36,    19,
    36,     0,    36,    23,    36,     0,    36,    12,    36,     0,
    36,    15,    36,     0,    36,    13,    36,     0,    36,    14,
    36,     0,    36,     8,    36,     0,    36,    10,    36,     0,
    36,     9,    36,     0,    27,    36,    28,     0,    36,    24,
     0,    16,    36,     0,    17,    36,     0,    25,    43,    26,
     0,     5,    27,    40,    28,     0,     4,    22,     0,    29,
     4,    30,     4,    22,     0,    37,     0,     0,     7,     0,
    37,     7,     0,     7,    31,     7,     0,    37,     7,    31,
    38,     7,     0,    36,     0,    36,    11,    40,     0,     0,
     3,     0,     4,     0,    41,     0,    41,    32,    42,     0,
    41,    33,    42,     0,     0,    42,     0,    42,    34,    43,
     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   316,   321,   344,   347,   348,   349,   350,   351,   352,   353,
   354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
   365,   366,   367,   369,   375,   382,   393,   420,   421,   424,
   428,   433,   444,   459,   464,   470,   473,   474,   477,   482,
   491,   500,   503,   508
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","NUMBER",
"STRING","FUNCALL","CONSTANT","CELLREF","GTE","LTE","NE","SEPARATOR","'&'","'<'",
"'>'","'='","'-'","'+'","'*'","'/'","NEG","PLUS","'!'","'^'","'%'","'{'","'}'",
"'('","')'","'['","']'","':'","','","'\\\\'","';'","line","exp","sheetref","opt_sheetref",
"cellref","arg_list","array_exp","array_row","array_cols", NULL
};
#endif

static const short yyr1[] = {     0,
    35,    35,    35,    36,    36,    36,    36,    36,    36,    36,
    36,    36,    36,    36,    36,    36,    36,    36,    36,    36,
    36,    36,    36,    36,    36,    37,    37,    38,    38,    39,
    39,    39,    39,    40,    40,    40,    41,    41,    42,    42,
    42,    42,    43,    43
};

static const short yyr2[] = {     0,
     1,    14,     1,     1,     1,     1,     1,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     2,     2,     2,     3,     4,     2,     5,     1,     0,     1,
     2,     3,     5,     1,     3,     0,     1,     1,     1,     3,
     3,     0,     1,     3
};

static const short yydefact[] = {     0,
     3,     4,     5,     0,     7,    30,     0,     0,    42,     0,
     0,     1,     0,     6,    26,    36,     0,    42,    22,    23,
     4,     5,     0,    39,    43,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    21,    31,    34,     0,    32,    37,    38,     0,    42,    42,
    42,    24,    20,     0,    17,    19,    18,    13,    15,    16,
    14,     9,     8,    10,    11,    12,    29,    36,    25,     0,
    40,    41,    44,     0,     0,    28,     0,    35,     0,    27,
    33,     0,     0,     0,     0,     0,     0,     0,     0,     2,
     0,     0,     0
};

static const short yydefgoto[] = {    91,
    43,    13,    77,    14,    44,    24,    25,    26
};

static const short yypact[] = {    40,
-32768,-32768,   -16,   -11,-32768,    -9,    -2,    -2,    45,    -2,
    20,   120,    19,-32768,-32768,    -2,    21,    15,    -3,    -3,
   -21,   130,    84,    31,    26,    29,    67,    36,    -2,    -2,
    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,
-32768,    37,   103,    43,-32768,-32768,-32768,    46,    15,    15,
    15,-32768,-32768,    74,   142,   142,   142,   132,   142,   142,
   142,    35,    35,    -3,    -3,    -3,    13,    -2,-32768,    86,
-32768,-32768,-32768,    82,   -16,-32768,    98,-32768,    95,-32768,
-32768,   106,    96,    94,   122,   101,   124,   151,   127,-32768,
   167,   168,-32768
};

static const short yypgoto[] = {-32768,
     0,   102,-32768,-32768,   104,-32768,    38,   119
};


#define	YYLAST		172


static const short yytable[] = {    12,
     2,     3,     4,     5,     6,    15,    19,    20,    23,    27,
   -37,   -37,   -37,     7,     8,    16,    75,    46,    47,    40,
    41,    17,    18,    28,    10,    42,    11,    45,    55,    56,
    57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
     1,    11,     2,     3,     4,     5,     6,    21,    22,     4,
     5,     6,    38,    39,    52,     7,     8,    40,    41,    51,
     7,     8,    49,    50,     9,    54,    10,    67,    11,    18,
    69,    10,    70,    11,    29,    30,    31,    74,    32,    33,
    34,    35,    36,    37,    38,    39,    71,    72,    79,    40,
    41,    29,    30,    31,    53,    32,    33,    34,    35,    36,
    37,    38,    39,    80,    81,    82,    40,    41,    83,    48,
    29,    30,    31,    68,    32,    33,    34,    35,    36,    37,
    38,    39,    85,    84,    86,    40,    41,    29,    30,    31,
    87,    32,    33,    34,    35,    36,    37,    38,    39,    29,
    30,    31,    40,    41,    33,    34,    35,    36,    37,    38,
    39,    15,    88,    89,    40,    41,    90,    36,    37,    38,
    39,   -38,   -38,   -38,    40,    41,    92,    93,    76,    73,
     0,    78
};

static const short yycheck[] = {     0,
     3,     4,     5,     6,     7,    22,     7,     8,     9,    10,
    32,    33,    34,    16,    17,    27,     4,     3,     4,    23,
    24,    31,    25,     4,    27,     7,    29,     7,    29,    30,
    31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
     1,    29,     3,     4,     5,     6,     7,     3,     4,     5,
     6,     7,    18,    19,    26,    16,    17,    23,    24,    34,
    16,    17,    32,    33,    25,    30,    27,    31,    29,    25,
    28,    27,    27,    29,     8,     9,    10,     4,    12,    13,
    14,    15,    16,    17,    18,    19,    49,    50,     3,    23,
    24,     8,     9,    10,    28,    12,    13,    14,    15,    16,
    17,    18,    19,    22,     7,    11,    23,    24,     3,    26,
     8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
    18,    19,    29,    28,     3,    23,    24,     8,     9,    10,
    30,    12,    13,    14,    15,    16,    17,    18,    19,     8,
     9,    10,    23,    24,    13,    14,    15,    16,    17,    18,
    19,    22,    29,     3,    23,    24,    30,    16,    17,    18,
    19,    32,    33,    34,    23,    24,     0,     0,    67,    51,
    -1,    68
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 316 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		*parser_result = yyvsp[0].tree;
	;
    break;}
case 2:
#line 321 "parser.y"
{
		const int num_cols = expr_tree_get_const_int (yyvsp[-7].tree);
		const int num_rows = expr_tree_get_const_int (yyvsp[-9].tree);
		const int x = expr_tree_get_const_int (yyvsp[-1].tree);
		const int y = expr_tree_get_const_int (yyvsp[-4].tree);

		/*
		 * Notice that we have no use for the ExprTrees for the NUMBERS,
		 * so we deallocate them.
		 */
		unregister_allocation (yyvsp[-1].tree);
		expr_tree_unref (yyvsp[-1].tree);
		unregister_allocation (yyvsp[-4].tree);
		expr_tree_unref (yyvsp[-4].tree);
		unregister_allocation (yyvsp[-7].tree);
		expr_tree_unref (yyvsp[-7].tree);
		unregister_allocation (yyvsp[-9].tree);
		expr_tree_unref (yyvsp[-9].tree);

		unregister_allocation (yyvsp[-12].tree);
		*parser_result = build_array_formula (yyvsp[-12].tree, num_cols, num_rows, x, y);
	;
    break;}
case 3:
#line 344 "parser.y"
{ parser_error = PARSE_ERR_SYNTAX; ;
    break;}
case 4:
#line 347 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 5:
#line 348 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 6:
#line 349 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 7:
#line 350 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 8:
#line 351 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_ADD,       yyvsp[0].tree); ;
    break;}
case 9:
#line 352 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_SUB,       yyvsp[0].tree); ;
    break;}
case 10:
#line 353 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_MULT,      yyvsp[0].tree); ;
    break;}
case 11:
#line 354 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_DIV,       yyvsp[0].tree); ;
    break;}
case 12:
#line 355 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_EXP,       yyvsp[0].tree); ;
    break;}
case 13:
#line 356 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_CONCAT,    yyvsp[0].tree); ;
    break;}
case 14:
#line 357 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_EQUAL,     yyvsp[0].tree); ;
    break;}
case 15:
#line 358 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_LT,        yyvsp[0].tree); ;
    break;}
case 16:
#line 359 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_GT,        yyvsp[0].tree); ;
    break;}
case 17:
#line 360 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_GTE,       yyvsp[0].tree); ;
    break;}
case 18:
#line 361 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_NOT_EQUAL, yyvsp[0].tree); ;
    break;}
case 19:
#line 362 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_LTE,       yyvsp[0].tree); ;
    break;}
case 20:
#line 363 "parser.y"
{ yyval.tree = yyvsp[-1].tree; ;
    break;}
case 21:
#line 365 "parser.y"
{ yyval.tree = build_unary_op (OPER_PERCENT, yyvsp[-1].tree); ;
    break;}
case 22:
#line 366 "parser.y"
{ yyval.tree = build_unary_op (OPER_UNARY_NEG, yyvsp[0].tree); ;
    break;}
case 23:
#line 367 "parser.y"
{ yyval.tree = build_unary_op (OPER_UNARY_PLUS, yyvsp[0].tree); ;
    break;}
case 24:
#line 369 "parser.y"
{
		unregister_allocation (yyvsp[-1].list);
		yyval.tree = build_array (yyvsp[-1].list);
		free_expr_list_list (yyvsp[-1].list);
	;
    break;}
case 25:
#line 375 "parser.y"
{
		unregister_allocation (yyvsp[-1].list);
		yyval.tree = yyvsp[-3].tree;
		yyval.tree->u.function.arg_list = yyvsp[-1].list;
	;
    break;}
case 26:
#line 382 "parser.y"
{
		Sheet *sheet = sheet_lookup_by_name (parser_wb, yyvsp[-1].tree->u.constant->v.str->str);
		/* TODO : Get rid of ParseErr and replace it with something richer. */
		unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
		if (sheet == NULL) {
			parser_error = PARSE_ERR_SYNTAX;
                        return ERROR;
		}
	        yyval.sheet = sheet;
	;
    break;}
case 27:
#line 393 "parser.y"
{
		/* TODO : Get rid of ParseErr and replace it with something richer.
		 * The replace ment should include more detail as to what the error
		 * was,  and where in the expr string to highlight.
		 *
		 * e.g. for =1+Shhet!A1+2
		 *  We should return "Unknow Sheet 'Shhet'" and the indicies 3:7
		 *  to mark the offending region.
		 */
		Workbook * wb =
		    application_workbook_get_by_name (yyvsp[-3].tree->u.constant->v.str->str);
		Sheet *sheet = NULL;

		if (wb != NULL)
			sheet = sheet_lookup_by_name (wb, yyvsp[-1].tree->u.constant->v.str->str);

		unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
		unregister_allocation (yyvsp[-3].tree); expr_tree_unref (yyvsp[-3].tree);
		if (sheet == NULL) {
			/* TODO : Do we need to free things here too ? */
			parser_error = PARSE_ERR_SYNTAX;
                        return ERROR;
		}
	        yyval.sheet = sheet;
        ;
    break;}
case 29:
#line 421 "parser.y"
{ yyval.sheet = NULL; ;
    break;}
case 30:
#line 424 "parser.y"
{
	        yyval.tree = yyvsp[0].tree;
	;
    break;}
case 31:
#line 428 "parser.y"
{
		yyvsp[0].tree->u.ref.sheet = yyvsp[-1].sheet;
	        yyval.tree = yyvsp[0].tree;
	;
    break;}
case 32:
#line 433 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		unregister_allocation (yyvsp[-2].tree);
		yyval.tree = register_expr_allocation
			(expr_tree_new_constant
			 (value_new_cellrange (&(yyvsp[-2].tree->u.ref), &(yyvsp[0].tree->u.ref),
					       parser_col, parser_row)));
		expr_tree_unref (yyvsp[0].tree);
		expr_tree_unref (yyvsp[-2].tree);
	;
    break;}
case 33:
#line 444 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		unregister_allocation (yyvsp[-3].tree);
		yyvsp[-3].tree->u.ref.sheet = yyvsp[-4].sheet;
		yyvsp[0].tree->u.ref.sheet = yyvsp[-1].sheet ? yyvsp[-1].sheet : yyvsp[-4].sheet;
		yyval.tree = register_expr_allocation
			(expr_tree_new_constant
			 (value_new_cellrange (&(yyvsp[-3].tree->u.ref), &(yyvsp[0].tree->u.ref),
					       parser_col, parser_row)));

		expr_tree_unref (yyvsp[0].tree);
		expr_tree_unref (yyvsp[-3].tree);
	;
    break;}
case 34:
#line 459 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		yyval.list = g_list_prepend (NULL, yyvsp[0].tree);
		register_expr_list_allocation (yyval.list);
        ;
    break;}
case 35:
#line 464 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].tree);
		yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
		register_expr_list_allocation (yyval.list);
	;
    break;}
case 36:
#line 470 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 37:
#line 473 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 38:
#line 474 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 39:
#line 477 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		yyval.list = g_list_prepend (NULL, yyvsp[0].tree);
		register_expr_list_allocation (yyval.list);
        ;
    break;}
case 40:
#line 482 "parser.y"
{
		if (parser_array_col_separator == ',') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].tree);
			yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
			register_expr_list_allocation (yyval.list);
		} else
			parser_error = PARSE_ERR_SYNTAX;
	;
    break;}
case 41:
#line 491 "parser.y"
{
		if (parser_array_col_separator == '\\') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].tree);
			yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
			register_expr_list_allocation (yyval.list);
		} else
			parser_error = PARSE_ERR_SYNTAX;
	;
    break;}
case 42:
#line 500 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 43:
#line 503 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		yyval.list = g_list_prepend (NULL, yyvsp[0].list);
		register_expr_list_list_allocation (yyval.list);
        ;
    break;}
case 44:
#line 508 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].list);
		yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].list);
		register_expr_list_list_allocation (yyval.list);
	;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 515 "parser.y"


static int
return_cellref (char *p)
{
	CellRef   ref;

	if (cellref_get (&ref, p, parser_col, parser_row)) {
		yylval.tree = register_expr_allocation (expr_tree_new_var (&ref));
		return CELLREF;
	} else
		return 0;
}

static int
make_string_return (char const *string, gboolean const possible_number)
{
	Value *v;
	double fv;
	char *format;

	/*
	 * Try to match the entered text against any
	 * of the known number formating codes, if this
	 * succeeds, we store this as a float + format,
	 * otherwise, we return a string.
	 * Be extra careful with empty strings (""),  They may
	 * match some formats ....
	 */
	if (possible_number && string[0] != '\0' &&
	    format_match (string, &fv, &format)){
		v = value_new_float (fv);
		if (parser_desired_format && *parser_desired_format == NULL)
			*parser_desired_format = g_strdup (format);
	} else
		v = value_new_string (string);

	yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
	return STRING;
}

static int
return_symbol (Symbol *sym)
{
	ExprTree *e = NULL;
	int type = STRING;

	switch (sym->type){
	case SYMBOL_FUNCTION:
		symbol_ref (sym);
		e = expr_tree_new_funcall (sym, NULL);
		type = FUNCALL;
		break;

	case SYMBOL_VALUE:
	case SYMBOL_STRING: {
		e = expr_tree_new_constant (value_duplicate (sym->data));
		type = CONSTANT;
		break;
	}

	default:
		g_assert_not_reached ();
	} /* switch */

	yylval.tree = register_expr_allocation (e);
	return type;
}

static int
return_name (ExprName *exprn)
{
	yylval.tree = register_expr_allocation (expr_tree_new_name (exprn));
	return CONSTANT;
}

/**
 * try_symbol:
 * @string: the string to try.
 * @try_cellref_and_number: If it may be a cellref or a number.
 *
 * Attempts to figure out what @string refers to.
 * if @try_cellref_and_number is TRUE it will also attempt to match the
 * string as a cellname reference or a number.
 */
static int
try_symbol (char *string, gboolean try_cellref_and_number)
{
	Symbol *sym;
	int v;

	if (try_cellref_and_number){
		v = return_cellref (string);
		if (v)
			return v;
	}

	sym = symbol_lookup (global_symbol_table, string);
	if (sym)
		return return_symbol (sym);

	{ /* Name ? */
		/*
		 * FIXME: we need a good bit of work to get sheet
		 * scope names working well
		 */
		ExprName *name = expr_name_lookup (parser_wb, NULL,
						   string);
		if (name)
			return return_name (name);
	}

	return make_string_return (string, try_cellref_and_number);
}

int
yylex (void)
{
	int c;
	const char *p, *tmp;
	int is_float, digits;

        while(isspace ((unsigned char)*parser_expr))
                parser_expr++;

	c = *parser_expr++;
        if (c == '(' || c == ')')
                return c;

	if (c == parser_separator)
		return SEPARATOR;

	/* Translate locale's decimal marker into a dot.  */
	if (c == parser_decimal_point)
		c = '.';

	switch (c){
        case '0': case '1': case '2': case '3': case '4': case '5':
	case '6': case '7': case '8': case '9': case '.': {
		Value *v;

		is_float = c == '.';
		p = parser_expr-1;
		tmp = parser_expr;

		digits = 1;
		while (isdigit ((unsigned char)*tmp) ||
		       (!is_float && *tmp == parser_decimal_point && ++is_float)){
			tmp++;
			digits++;
		}

		/* Can't store it in a gint32 */
		is_float |= (digits > 9);

		if (*tmp == 'e' || *tmp == 'E') {
			is_float = 1;
			tmp++;
			if (*tmp == '-' || *tmp == '+')
				tmp++;
			while (isdigit ((unsigned char)*tmp))
				tmp++;
		}

		/* Ok, we have skipped over a number, now load its value */
		if (is_float) {
			float_t f;
			float_get_from_range (p, tmp, &f);
			v = value_new_float (f);
		} else {
			int i;
			int_get_from_range (p, tmp, &i);
			v = value_new_int (i);
		}

		/* Return the value to the parser */
		yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
		parser_expr = tmp;
		return NUMBER;
	}

	case '#' :
	{
		int offset = 0;
		/* we already took the leading '#' off */
		Value *err = value_is_error (parser_expr-1, &offset);
		if (err != NULL) {
			yylval.tree = register_expr_allocation (expr_tree_new_constant (err));
			parser_expr += offset - 1;
			return CONSTANT;
		}
	}
	break;

	case '\'':
	case '"': {
		char *string, *s;
		char quotes_end = c;

                p = parser_expr;
                while(*parser_expr && *parser_expr != quotes_end) {
                        if (*parser_expr == '\\' && parser_expr [1])
                                parser_expr++;
                        parser_expr++;
                }
                if(!*parser_expr){
                        parser_error = PARSE_ERR_NO_QUOTE;
                        return ERROR;
                }

		s = string = (char *) alloca (1 + parser_expr - p);
		while (p != parser_expr){
			if (*p== '\\'){
				p++;
				*s++ = *p++;
			} else
				*s++ = *p++;

		}
		*s = 0;
		parser_expr++;

		return make_string_return (string, FALSE);
	}

	}

	if (isalpha ((unsigned char)c) || c == '_' || c == '$'){
		const char *start = parser_expr - 1;
		char *str;
		int  len;

		while (isalnum ((unsigned char)*parser_expr) || *parser_expr == '_' ||
		       *parser_expr == '$' || *parser_expr == '.')
			parser_expr++;

		len = parser_expr - start;
		str = alloca (len + 1);
		strncpy (str, start, len);
		str [len] = 0;
		return try_symbol (str, TRUE);
	}

	if (c == '\n' || c == 0)
		return 0;

	if (c == '<'){
		if (*parser_expr == '='){
			parser_expr++;
			return LTE;
		}
		if (*parser_expr == '>'){
			parser_expr++;
			return NE;
		}
		return c;
	}

	if (c == '>'){
		if (*parser_expr == '='){
			parser_expr++;
			return GTE;
		}
		return c;
	}

	return c;
}

int
yyerror (char *s)
{
#if 0
	printf ("Error: %s\n", s);
#endif
	return 0;
}

ParseErr
gnumeric_expr_parser (const char *expr, const ParsePosition *pp,
		      char **desired_format, ExprTree **result)
{
	struct lconv *locinfo;

	g_return_val_if_fail (pp, PARSE_ERR_UNKNOWN);
	g_return_val_if_fail (expr, PARSE_ERR_UNKNOWN);
	g_return_val_if_fail (result, PARSE_ERR_UNKNOWN);

	parser_error = PARSE_OK;
	parser_expr = expr;
	parser_wb    = pp->wb;
	parser_col   = pp->col;
	parser_row   = pp->row;
	parser_desired_format = desired_format;
	parser_result = result;

	if (parser_desired_format)
		*parser_desired_format = NULL;

	locinfo = localeconv ();
	if (locinfo->decimal_point && locinfo->decimal_point[0] &&
	    locinfo->decimal_point[1] == 0)
		parser_decimal_point = locinfo->decimal_point[0];
	else
		parser_decimal_point = '.';

	if (parser_decimal_point == ',') {
		parser_separator = ';';
		parser_array_col_separator = '\\'; /* ! */
	} else {
		parser_separator = ',';
		parser_array_col_separator = ',';
	}

	if (deallocate_stack == NULL)
		deallocate_init ();

	yyparse ();

	if (parser_error == PARSE_OK) {
		deallocate_assert_empty ();
		if (desired_format) {
			char *format;
			EvalPosition pos;

			pos.sheet = pp->sheet;
			pos.eval.col = pp->col;
			pos.eval.row = pp->row;
			format = auto_format_suggest (*parser_result, &pos);
			if (format) {
				/*
				 * Override the format that came from a
				 * constant somewhere inside.
				 */
				if (*desired_format)
					g_free (*desired_format);
				*desired_format = format;
			}
		}
	} else {
		fprintf (stderr, "Unable to parse '%s'\n", expr);
		deallocate_all ();
		*parser_result = NULL;
		if (desired_format && *desired_format) {
			g_free (*desired_format);
			*desired_format = NULL;
		}
	}

#ifndef KEEP_DEALLOCATION_STACK_BETWEEN_CALLS
	deallocate_uninit ();
#endif

	return parser_error;
}
