#ifndef GNUMERIC_MS_OBJ_H
#define GNUMERIC_MS_OBJ_H

/**
 * ms-obj.h: MS Excel Graphic Object support for Gnumeric
 *
 * Author:
 *    Michael Meeks (michael@imaginator.com)
 *    Jody Goldberg (jgoldberg@home.com)
 *
 * (C) 1998, 1999, 2000 Michael Meeks, Jody Goldberg
 **/

#include "config.h"
#ifdef ENABLE_BONOBO
#	include <bonobo/bonobo-stream.h>
#	include <bonobo/bonobo-stream-memory.h>
#	include "sheet-object-container.h"
#else
#	include "sheet-object.h"
#endif

#include "ms-excel-read.h"

#define MS_ANCHOR_SIZE	18

struct _MSObj
{
	/* In pixels */
	guint8	raw_anchor[MS_ANCHOR_SIZE];
	gboolean anchor_set;

	int id;

	/* Type specific parameters */
	SheetObjectType	gnumeric_type;
	unsigned	excel_type;
	union {
		struct {
			int blip_id;
		} picture;
	} v;
};

MSObj *ms_read_OBJ    (BiffQuery *q, MSContainer *container);
void   ms_destroy_OBJ (MSObj *obj);
char  *ms_read_TXO    (BiffQuery *q);

#endif /* GNUMERIC_MS_OBJ_H */
