#ifndef GNUMERIC_WORKBOOK_VIEW_H
#define GNUMERIC_WORKBOOK_VIEW_H

#include "gnumeric.h"
#include <gtk/gtkobject.h>

struct _WorkbookView {
	GtkObject  gtk_object;

	Workbook *wb;
	GPtrArray *wb_controls;

	Sheet	  *current_sheet;

	/* preferences */
	gboolean   show_horizontal_scrollbar;
	gboolean   show_vertical_scrollbar;
	gboolean   show_notebook_tabs;

	/* Non-normative size information */
	int preferred_width, preferred_height;

	/* The auto-expression */
	ExprTree  *auto_expr;
	char	  *auto_expr_desc;
	char	  *auto_expr_value_as_string;

	/* Format for feedback */
	MStyle    *current_format;
};

typedef struct {
	GtkObjectClass   gtk_object_class;
	void (*sheet_entered) (Sheet *sheet);
} WorkbookViewClass;

#define WORKBOOK_VIEW_TYPE     (workbook_view_get_type ())
#define WORKBOOK_VIEW(obj)     (GTK_CHECK_CAST ((obj), WORKBOOK_VIEW_TYPE, WorkbookView))
#define IS_WORKBOOK_VIEW(o)    (GTK_CHECK_TYPE ((o), WORKBOOK_VIEW_TYPE))
#define WORKBOOK_VIEW_CLASS(k) (GTK_CHECK_CLASS_CAST ((k), WORKBOOK_VIEW_TYPE, WorkbookViewClass))

/* Lifecycle */
GtkType		 workbook_view_get_type	  (void);
WorkbookView	*workbook_view_new	  (Workbook *optional_workbook);
void             workbook_view_init       (WorkbookView *wbv,
					   Workbook *optional_workbook);
void		 wb_view_attach_control	  (WorkbookView *wbv, WorkbookControl *wbc);
void		 wb_view_detach_control	  (WorkbookControl *wbc);

/* Information */
Workbook	*wb_view_workbook	  (WorkbookView *wbv);
Sheet		*wb_view_cur_sheet	  (WorkbookView *wbv);
void		 wb_view_sheet_focus	  (WorkbookView *wbv, Sheet *sheet);
void		 wb_view_sheet_add	  (WorkbookView *wbv, Sheet *new_sheet);

/* Manipulation */
GtkArg		*wb_view_get_attributev	  (WorkbookView *wbv, guint *n_args);
void		 wb_view_set_attributev	  (WorkbookView *wbv, GList *list);
void		 wb_view_preferred_size	  (WorkbookView *wbv,
					   int w_pixels, int h_pixels);
void		 wb_view_prefs_update	  (WorkbookView *wbv);
void		 wb_view_format_feedback  (WorkbookView *wbv, gboolean display);
void		 wb_view_auto_expr_recalc (WorkbookView *wbv, gboolean display);
void		 wb_view_auto_expr	  (WorkbookView *wbv,
					   char const *name, char const *expr);

#define WORKBOOK_VIEW_FOREACH_CONTROL(wbv, control, code)			\
do {										\
	int j;									\
	GPtrArray *wb_controls = wbv->wb_controls;				\
	if (wb_controls != NULL) /* Reverse is important during destruction */	\
		for (j = wb_controls->len; j-- > 0 ;) {				\
			WorkbookControl *control =				\
				g_ptr_array_index (wb_controls, j);		\
			code							\
		}								\
} while (0)

#endif /* GNUMERIC_WORKBOOK_VIEW_H */
