package org.gnu.libebook;

import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;
import org.gnu.libedataserver.EDSMemStruct;

public class EContactDate extends EDSMemStruct
{
    public EContactDate(Handle handle)
    {
        super(handle);
    }

    public static EContactDate getEContactDate(Handle handle)
    {
        if (handle == null)
            return null;

        EContactDate obj = (EContactDate) MemStruct.getMemStructFromHandle(handle);
        return obj == null ? new EContactDate(handle) : obj;
    }

    public int getMonth()
    {
        return e_contact_date_get_month(getHandle());
    }

    public int getDay()
    {
        return e_contact_date_get_day(getHandle());
    }

    public int getYear()
    {
        return e_contact_date_get_year(getHandle());
    }

    public void setMonth(int month)
    {
        e_contact_date_set_month(getHandle(), month);
    }

    public void setDay(int day)
    {
        e_contact_date_set_day(getHandle(), day);
    }

    public void setYear(int year)
    {
        e_contact_date_set_year(getHandle(), year);
    }

    public static EContactDate createContactDate()
    {
        return getEContactDate(e_contact_date_new());
    }

    //   a date string in the format YYYY-MM-DD or YYYYMMDD
    public static EContactDate createContactDate(String dateString)
    {
        return getEContactDate(e_contact_date_from_string(dateString));
    }


    native static private Handle e_contact_date_new();
    native static private Handle e_contact_date_from_string(String dateString);

    native static private int e_contact_date_get_month(Handle handle);
    native static private int e_contact_date_get_day(Handle handle);
    native static private int e_contact_date_get_year(Handle handle);
    native static private void e_contact_date_set_month(Handle handle, int month);
    native static private void e_contact_date_set_day(Handle handle, int day);
    native static private void e_contact_date_set_year(Handle handle, int year);
}
