package org.gnu.libebook;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.libedataserver.EDSObject;

/**
 * This is a representaton of a VCard. Understanding of the VCard specification is advised. What the spec calls a
 * property, we call an attribute.
 */
public class EVCard extends EDSObject
{
    public EVCard(Handle handle)
    {
        super(handle);
    }

    public static EVCard getEVCard(Handle handle)
    {
        if (handle == null)
            return null;

        EVCard obj = (EVCard) GObject.getGObjectFromHandle(handle);
        return obj == null ? new EVCard(handle) : obj;
    }

    public String getAsVCard()
    {
        return e_vcard_to_string(getHandle());
    }

    public void removeAttributes(String group, String name)
    {
        if (group != null && name != null)
            e_vcard_remove_attributes(getHandle(), group, name);
    }

    public void removeAttributes(String name)
    {
        if (name != null)
            removeAttributes("", name);
    }

    public void removeAttribute(EVCardAttribute attribute)
    {
        e_vcard_remove_attribute(getHandle(), attribute.getHandle());
    }

    public void addAttribute(EVCardAttribute attribute)
    {
        e_vcard_add_attribute(getHandle(), attribute.getHandle());
    }

    public void addAttributeWithValue(EVCardAttribute attribute, String value)
    {
        e_vcard_add_attribute_with_value(getHandle(), attribute.getHandle(), value);
    }

    public EVCardAttribute[] getAttributes()
    {
        Handle[] handles = e_vcard_get_attributes(getHandle());
        EVCardAttribute[] evCardAttributes = new EVCardAttribute[handles.length];
        for (int i = 0; i < evCardAttributes.length; i++)
            evCardAttributes[i] = EVCardAttribute.getEVCardattribute(handles[i], false);
        return evCardAttributes;
    }

    public static EVCard createNewEVCard()
    {
        return getEVCard(e_vcard_new());
    }

    public static EVCard createNewEVCardFromVCard(String vCard)
    {
        return vCard == null ? null : getEVCard(e_vcard_new_from_string(vCard));
    }

    native static Handle e_vcard_new();

    native static Handle e_vcard_new_from_string(String vCard);

    native static String e_vcard_to_string(Handle handle);

    native static void e_vcard_remove_attributes(Handle handle, String group, String name);

    native static void e_vcard_remove_attribute(Handle handle, Handle attribute);

    native static void e_vcard_add_attribute(Handle handle, Handle attribute);

    native static void e_vcard_add_attribute_with_value(Handle handle, Handle attribute, String value);

    native static Handle[] e_vcard_get_attributes(Handle handle);

}
