package org.gnu.libedataserver;

import org.gnu.glib.Handle;
import org.gnu.gtk.GtkObject;

public class ESource extends EDSObject
{
    public ESource(Handle handle)
    {
        super(handle);
    }

    public static ESource getESource(Handle handle) {
        if (handle == null)
            return null;

        ESource obj = (ESource) GtkObject.getGObjectFromHandle(handle);
        return obj == null ? new ESource(handle) : obj;
    }

    public ESource copy()
    {
        return getESource(e_source_copy(getHandle()));
    }

    public boolean equals(Object rhs)
    {
        return e_source_equal(getHandle(), ((ESource) rhs).getHandle());
    }

    public void setGroup(ESourceGroup group)
    {
        e_source_set_group(getHandle(), group.getHandle());
    }

    public void setName(String name)
    {
        e_source_set_name(getHandle(), name);
    }

    public void setRelativeUri(String uri)
    {
        e_source_set_relative_uri(getHandle(), uri);
    }

    public void setAbsoluteUri(String uri)
    {
        e_source_set_absolute_uri(getHandle(), uri);
    }

    public void setReadonly(boolean reandonly)
    {
        e_source_set_readonly(getHandle(), reandonly);
    }

    public ESourceGroup getGroup()
    {
        return ESourceGroup.getESourceGroup(e_source_peek_group(getHandle()));
    }

    public String getUid()
    {
        return e_source_peek_uid(getHandle());
    }

    public String getName()
    {
        return e_source_peek_name(getHandle());
    }

    public String getRelativeUri()
    {
        return e_source_peek_relative_uri(getHandle());
    }

    public String getAbsoluteUri()
    {
        return e_source_peek_absolute_uri(getHandle());
    }

    public boolean getReadonly()
    {
        return e_source_get_readonly(getHandle());
    }

    public String getUri()
    {
        return e_source_get_uri(getHandle());
    }

    public String getAsXml()
    {
        return e_source_to_standalone_xml(getHandle());
    }

    public String getESourceProperty(String propertyKey)
    {
        return e_source_get_property(getHandle(), propertyKey);
    }

    public void setESourceProperty(String propertyKey, String propertyValue)
    {
        e_source_set_property(getHandle(), propertyKey, propertyValue);
    }

    public static ESource createFromRelativeUri(String name, String relativeUri)
    {
        return name == null || relativeUri == null ? null : getESource(e_source_new(name, relativeUri));
    }

    public static ESource createFromAbsoluteUri(String name, String absoluteUri)
    {
        return name == null || absoluteUri == null ? null : getESource(e_source_new_with_absolute_uri(name, absoluteUri));
    }

    public static ESource createFromXml(String xml)
    {
        return xml == null ? null : getESource(e_source_new_from_standalone_xml(xml));
    }

    native static private Handle e_source_new(String name, String relativeUri);

    native static private Handle e_source_new_with_absolute_uri(String name, String absoluteUri);

    native static private Handle e_source_new_from_standalone_xml(String xml);

    native static private Handle e_source_copy(Handle handle);

    native static private boolean e_source_equal(Handle lhs, Handle rhs);

    native static private void e_source_set_group(Handle handle, Handle group);

    native static private void e_source_set_name(Handle handle, String name);

    native static private void e_source_set_relative_uri(Handle handle, String uri);

    native static private void e_source_set_absolute_uri(Handle handle, String uri);

    native static private void e_source_set_readonly(Handle handle, boolean readonly);

    native static private Handle e_source_peek_group(Handle handle);

    native static private String e_source_peek_uid(Handle handle);

    native static private String e_source_peek_name(Handle handle);

    native static private String e_source_peek_relative_uri(Handle handle);

    native static private String e_source_peek_absolute_uri(Handle handle);

    native static private boolean e_source_get_readonly(Handle handle);

    native static private String e_source_get_uri(Handle handle);

    native static private String e_source_to_standalone_xml(Handle handle);

    native static private String e_source_get_property(Handle handle, String property);

    native static private void e_source_set_property(Handle handle, String property, String value);
}
