/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "jg_jnu.h"
#include "gtk_java.h"
#include <libebook/e-book.h>
#include "org_gnu_libebook_EBookQuery.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_from_string
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1from_1string
(JNIEnv *env, jclass cls, jstring query)
{
    char* query_g = (char*)(*env)->GetStringUTFChars(env, query, 0);
    EBookQuery *ebookquery = e_book_query_from_string(query_g);
    (*env)->ReleaseStringUTFChars(env, query, query_g);
    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_to_string
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1to_1string
(JNIEnv *env, jclass cls, jobject obj)
{
    EBookQuery *query = (EBookQuery*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_book_query_to_string(query));
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_and
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1and
(JNIEnv *env, jclass cls, jobject obj1, jobject obj2)
{
    EBookQuery *queries[2];
    EBookQuery *ebookquery;

    queries[0] = (EBookQuery*)getPointerFromHandle(env, obj1);
    queries[1] = (EBookQuery*)getPointerFromHandle(env, obj2);
    ebookquery = e_book_query_and(2, queries, FALSE);

    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_or
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1or
(JNIEnv *env, jclass cls, jobject obj1, jobject obj2)
{
    EBookQuery *queries[2];
    EBookQuery *ebookquery;

    queries[0] = (EBookQuery*)getPointerFromHandle(env, obj1);
    queries[1] = (EBookQuery*)getPointerFromHandle(env, obj2);
    ebookquery = e_book_query_or(2, queries, FALSE);

    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_not
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1not
(JNIEnv *env, jclass cls, jobject obj)
{
    EBookQuery *query = (EBookQuery*)getPointerFromHandle(env, obj);
    EBookQuery *ebookquery = e_book_query_not(query, FALSE);
    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_field_exists
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1field_1exists
(JNIEnv *env, jclass cls, jint fieldId)
{
    EBookQuery *ebookquery = e_book_query_field_exists((int)fieldId);
    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_field_equals
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1field_1equals
(JNIEnv *env, jclass cls, jint fieldId, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EBookQuery *ebookquery = e_book_query_field_test((int)fieldId, E_BOOK_QUERY_IS, value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_field_contains
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1field_1contains
(JNIEnv *env, jclass cls, jint fieldId, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EBookQuery *ebookquery = e_book_query_field_test((int)fieldId, E_BOOK_QUERY_CONTAINS, value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_field_begins_with
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1field_1begins_1with
(JNIEnv *env, jclass cls, jint fieldId, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EBookQuery *ebookquery = e_book_query_field_test((int)fieldId, E_BOOK_QUERY_BEGINS_WITH, value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_field_ends_with
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1field_1ends_1with
(JNIEnv *env, jclass cls, jint fieldId, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EBookQuery *ebookquery = e_book_query_field_test((int)fieldId, E_BOOK_QUERY_ENDS_WITH, value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

/*
 * Class:     org_gnu_libebook_EBookQuery
 * Method:    e_book_query_any_field_contains
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EBookQuery_e_1book_1query_1any_1field_1contains
(JNIEnv *env, jclass cls, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EBookQuery *ebookquery = e_book_query_any_field_contains(value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
    if(!ebookquery)
        return NULL;
    return getStructHandle(env, ebookquery, (JGCopyFunc)e_book_query_ref, (JGFreeFunc)e_book_query_unref);
}

#ifdef __cplusplus
}

#endif
