/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "gtk_java.h"
#include "jg_jnu.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EContactPhoto.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EContactPhoto
 * Method:    e_contact_photo_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactPhoto_e_1contact_1photo_1new
(JNIEnv *env, jclass cls)
{
    return getStructHandle(env, g_new0(EContactPhoto, 1), NULL, (JGFreeFunc)e_contact_photo_free);
}

/*
 * Class:     org_gnu_libebook_EContactPhoto
 * Method:    e_contact_photo_get_data
 */
JNIEXPORT jbyteArray JNICALL Java_org_gnu_libebook_EContactPhoto_e_1contact_1photo_1get_1data
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactPhoto *contact_photo = (EContactPhoto*)getPointerFromHandle(env, obj);

    jbyteArray ret = (*env)->NewByteArray(env, contact_photo->length);
    (*env)->SetByteArrayRegion(env, ret, 0, contact_photo->length, contact_photo->data);
    return ret;
}


/*
 * Class:     org_gnu_libebook_EContactPhoto
 * Method:    e_contact_photo_set_data
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactPhoto_e_1contact_1photo_1set_1data
(JNIEnv *env, jclass cls, jobject obj, jbyteArray data, jint length)
{
    EContactPhoto *contact_photo = (EContactPhoto*)getPointerFromHandle(env, obj);
    char* data_g = (char*)(*env)->GetByteArrayElements(env, data, 0);
    contact_photo->data = data_g;
    contact_photo->length = length;
}



#ifdef __cplusplus
}

#endif
