/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:12 EDT
 */

 /*
  * TODO:
  * Some methods might not be used, decide it.
  */
 
package org.gnu.gdk;
import org.gnu.glib.GObject;
/**
 *
 */
public class Visual extends GObject 
{
	
	public Visual(int handle){
		this.handle=handle;
	}
	
	
	/**Get the best available depth for the default GDK display. 
	*	"Best" means "largest," i.e. 32 preferred over 24 preferred over 8 bits per pixel.
	*/
	public static int getBestDepth(){
		return Visual.gdk_visual_get_best_depth();
	}
	
	/**
	*	Return the best available visual type (the one with the most colors) for the default GDK display.		
	*/
	public static VisualType getBestVisualType(){
		return VisualType.getVisualType(Visual.gdk_visual_get_best_type());
	}
	
	
	/**
	*	Get the default or system visual for the default GDK display. 
	*	This is the visual for the root window of the display.
	*/
	public static Visual getSystemVisual(){
		return new Visual(Visual.gdk_visual_get_system());
	}
	
	/**
	*	Get the visual with the most available colors for the default GDK display.
	*/
	public static Visual getVisual(){
		return new Visual(Visual.gdk_visual_get_best());
	}
	
	
	/**
	*	Get the best visual with depth depth for the default GDK display.
	*	Color visuals and visuals with mutable colormaps are preferred over grayscale or fixed-colormap visuals.
	*	NULL may be returned if no visual supports depth.
	*/
	public static Visual getVisual(int depth){
		return new Visual(Visual.gdk_visual_get_best_with_depth(depth));
	}
	
	
	/**
	*	Get the best visual of the given visual_type for the default GDK display. Visuals with higher color depths are considered better. 
	*	NULL may be returned if no visual has type visual_type.
	*/
	public static Visual getVisual(VisualType vt){
		return new Visual(Visual.gdk_visual_get_best_with_type(vt.getValue()));
	}		
	
	/**
	*	Combines getVisual(int depth) and getVisual(VisualType vt).
	*/
	public static Visual getVisual(int depth,VisualType vt){
		return new Visual(Visual.gdk_visual_get_best_with_both(depth,vt.getValue()));
	}
	
	
	
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getDepth (int obj);
    native static final protected int getByteOrder (int obj);
    native static final protected int getColormapSize (int obj);
    native static final protected int getBitsPerRgb (int obj);
    native static final protected int getRedMask (int obj);
    native static final protected int getRedShift (int obj);
    native static final protected int getRedPrec (int obj);
    native static final protected int getGreenMask (int obj);
    native static final protected int getGreenShift (int obj);
    native static final protected int getGreenPrec (int obj);
    native static final protected int getBlueMask (int obj);
    native static final protected int getBlueShift (int obj);
    native static final protected int getBluePrec (int obj);
    native static final protected int gdk_visual_get_type ();
    native static final protected int gdk_visual_get_best_depth ();
    native static final protected int gdk_visual_get_best_type ();
    native static final protected int gdk_visual_get_system ();
    native static final protected int gdk_visual_get_best ();
    native static final protected int gdk_visual_get_best_with_depth (int depth);
    native static final protected int gdk_visual_get_best_with_type (int visualType);
    native static final protected int gdk_visual_get_best_with_both (int depth, int visualType);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}