/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:37 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The Fixed container enables your program to place widgets at a
 * fixed location with fixed sizes in pixels and to move widgets from 
 * one location to another.  Most applications should not use this container.
 * This container could result in truncated text, overlapping widgets and
 * other display bugs as the user changes their themes, fonts, or preferences.
 */
public class Fixed extends Container 
{

	/**
	 * Construct a new Fixed object.
	 */
	public Fixed() {
		noopInit();
	}
	
	/**
	 * Construct a new Fixed from a handle to a native resource.
	 */
	public Fixed(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {
		if (-1 == handle) {
			handle = Fixed.gtk_fixed_new();
			initializeEventHandlers();
		}
	}
	
	/**
	 * Add a Widget to the Fixed at the specified location.
	 */
	public void putWidget(Widget widget, int x, int y) {
		Fixed.gtk_fixed_put(handle, widget.getHandle(), x, y);
	}
	
	/**
	 * Move a widget to a new location.
	 */
	public void moveWidget(Widget widget, int x, int y) {
		Fixed.gtk_fixed_move(handle, widget.getHandle(), x, y);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_fixed_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_fixed_get_type ();
    native static final protected int gtk_fixed_new ();
    native static final protected void gtk_fixed_put (int fixed, int widget, int x, int y);
    native static final protected void gtk_fixed_move (int fixed, int widget, int x, int y);
    native static final protected void gtk_fixed_set_has_window (int fixed, boolean hasWindow);
    native static final protected boolean gtk_fixed_get_has_window (int fixed);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

