/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:41 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * ToolTips are the messages that appear next to a widget when the mouse
 * pointer is held over it for a short period of time.
 */
public class ToolTips extends GtkObject {
	/**
	 * Construct a new ToolTips object.
	 */
	public ToolTips() {
		noopInit();
	}
	
	protected void noopInit() {
		if (-1 == handle) {
			handle = ToolTips.gtk_tooltips_new();
		}
	}

	/**
	 * Adds a tooltip to a Widget.
	 * 
	 * @param widget The Widget to add to tooltips.
	 * @param tipText The text to display for the tooltip.
	 * @param additionalInfo Additional information that might be useful to
	 * the user if they get stuck.
	 */
	public void setTip(Widget widget, String tipText, String additionalInfo) {
		ToolTips.gtk_tooltips_set_tip(handle, widget.getHandle(), tipText, additionalInfo);
	}
	
	/**
	 * Enables the ToolTips.
	 */
	public void enable() {
		ToolTips.gtk_tooltips_enable(handle);
	}
	
	/**
	 * Disables the ToolTips.
	 */
	public void disable() {
		ToolTips.gtk_tooltips_disable(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_tooltips_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_tooltips_get_type();
	native static final protected int gtk_tooltips_new();
	native static final protected void gtk_tooltips_enable(int tooltips);
	native static final protected void gtk_tooltips_disable(int tooltips);
	native static final protected void gtk_tooltips_set_tip(int tooltips, int widget, String tipText, String tipPrivate);
	native static final protected void gtk_tooltips_force_window(int tooltips);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
