/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The EventBox widget is a container with a seethrough window that
 * can recieve events for the container widget - normally one that
 * cannot recvieve its own. Events are sent to the windows, so a widget
 * without windows cannot recieve events.
 */
public class EventBox extends Bin 
{
	/**
	 * Construct a new EventBox object.
	 */
	public EventBox() {
		noopInit();
	}
	
	/**
	 * Construct an eventbox using a handle to a native resource.
	 */
	protected EventBox(int handle) {
	    setHandle(handle);
	    initializeEventHandlers();
	}

	protected void noopInit() {
		if (-1 == getHandle()) {
			setHandle(gtk_event_box_new());
			initializeEventHandlers();
		}
	}
	
	
	/**
	 * Sets whether the EventBox has a visible window.
	 * @param isVisible
	 */
	public void setWindowVisible(boolean isVisible) {
		gtk_event_box_set_visible_window(getHandle(), isVisible);
	}
	
	/**
	 * Returns whether the EventBox has a visible window
	 * @return  true if the EventBox has a visible window.
	 */
	public boolean getWindowVisible() {
		return gtk_event_box_get_visible_window(getHandle());
	}
	
	/**
	 * Returns whether the EventBox is above or below the windows
	 * of its' child.
	 * @param aboveChild
	 */
	public void setAboveChild(boolean aboveChild) {
		gtk_event_box_set_above_child(getHandle(), aboveChild);
	}
	
	/**
	 * Returns whether the EventBox is above the window of its' child.
	 * @return
	 */
	public boolean getAboveChild() {
		return gtk_event_box_get_above_child(getHandle());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_event_box_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_event_box_get_type ();
    native static final protected int gtk_event_box_new ();
    native static final protected void gtk_event_box_set_visible_window(int ebox, boolean visible);
    native static final protected boolean gtk_event_box_get_visible_window(int ebox);
    native static final protected void gtk_event_box_set_above_child(int ebox, boolean above);
    native static final protected boolean gtk_event_box_get_above_child(int ebox);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

