/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventFocus_get_type (GdkEventFocus * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventFocus
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventFocus_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventFocus *obj_g = (GdkEventFocus *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventFocus_get_type (obj_g));
}

GdkWindow * GdkEventFocus_get_window (GdkEventFocus * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventFocus
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventFocus_getWindow (JNIEnv *env, jclass cls, jobject obj)
{
    GdkEventFocus *obj_g = (GdkEventFocus *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventFocus_get_window (obj_g));
}

gboolean GdkEventFocus_get_send_event (GdkEventFocus * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventFocus
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventFocus_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventFocus *obj_g = (GdkEventFocus *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventFocus_get_send_event (obj_g));
}

gint32 GdkEventFocus_get_in (GdkEventFocus * cptr) 
{
    return cptr->in;
}

/*
 * Class:     org.gnu.gdk.EventFocus
 * Method:    getIn
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventFocus_getIn (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventFocus *obj_g = (GdkEventFocus *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventFocus_get_in (obj_g));
}

#ifdef __cplusplus
}

#endif
