/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * This is a base class for a container widget that has only one child.
 * This class contains code common to all widgets that contain only a
 * single child widget.
 */
public class Bin extends Container 
{
	protected Bin(Handle handle) {
	    super(handle);
	}

	/**
	 * Retruns the child of this Bin or null if the bin contains no
	 * child.
	 */
	public Widget getChild() {
	    Handle hndl = gtk_bin_get_child(getHandle());
		if (null == hndl)
			return null;
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Widget)obj;
		return new Widget(hndl);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_bin_get_type());
	}
	

    native static final protected int gtk_bin_get_type ();
    native static final protected Handle gtk_bin_get_child (Handle bin);

}

