/* Main.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;

/**
 * @author Mark Boyns
 */
public class Main extends Frame
{
    static Options options;
    Monitor monitor;
    Server server;
    Filters filters;
    String version = "0.2";
    
    public Main ()
    {
	super ("Muffin");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	MenuBar bar = new MenuBar ();
	Menu menu = new Menu ("File");
	menu.setFont (new Font ("Helvetica", Font.BOLD, 12));
	MenuItem item = new MenuItem ("Quit");
	item.setFont (new Font ("Helvetica", Font.BOLD, 12));
	menu.add (item);
	bar.add (menu);

	menu = new Menu ("Help");
	menu.setFont (new Font ("Helvetica", Font.BOLD, 12));
	item = new MenuItem ("About Muffin...");
	item.setFont (new Font ("Helvetica", Font.BOLD, 12));
	menu.add (item);
	bar.setHelpMenu (menu);
	
	setMenuBar (bar);

	monitor = new Monitor ();
	add ("Center", monitor);

	GridBagLayout layout = new GridBagLayout ();
	Panel controlPanel = new Panel ();
	controlPanel.setLayout (layout);

	GridBagConstraints c = new GridBagConstraints ();
	c.anchor = GridBagConstraints.NORTHWEST;
	c.insets = new Insets (2, 5, 2, 5);
	c.weightx = 1.0;

	Button b;
	b = new Button ("Filters...");
	layout.setConstraints (b, c);
	controlPanel.add (b);
	b = new Button ("Options...");
	layout.setConstraints (b, c);
	controlPanel.add (b);
	b = new Button ("Suspend");
	layout.setConstraints (b, c);
	controlPanel.add (b);
	b = new Button ("Stop");
	layout.setConstraints (b, c);
	controlPanel.add (b);
	
	Icon icon = new Icon ();
	c.anchor = GridBagConstraints.EAST;
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (icon, c);
	controlPanel.add (icon);
	
	add ("North", controlPanel);

	filters = new Filters ();

	pack ();
	resize (preferredSize ());
	show ();
	
	server = new Server (options.getInteger ("muffin.port"),
			     monitor, filters, options);
	server.run ();
    }

    public boolean action (Event e, Object arg)
    {
	if (e.target instanceof MenuItem)
	{
	    if ("Quit".equals (arg))
	    {
		System.exit (0);
	    }
	    else if ("About Muffin...".equals (arg))
	    {
		new About (version);
	    }
	}
	else if (e.target instanceof Button)
	{
	    if ("Stop".equals (arg))
	    {
		server.stop ();
	    }
	    else if ("Suspend".equals (arg))
	    {
		Button b = (Button) e.target;
		b.setLabel ("Resume");
		server.suspend ();
		monitor.suspend ();
	    }
	    else if ("Resume".equals (arg))
	    {
		Button b = (Button) e.target;
		b.setLabel ("Suspend");
		server.resume ();
		monitor.resume ();
	    }
	    else if ("Filters...".equals (arg))
	    {
		filters.hideshow ();
	    }
	    else if ("Options...".equals (arg))
	    {
		options.hideshow ();
	    }
	    return true;
	}
	return false;
    }
    
    public static void main (String args[])
    {
	options = new Options ();
	
	for (int i = 0; i < args.length; i++) 
	{
	    if (args[i].equalsIgnoreCase ("-port")) 
	    {
		try 
		{
		    options.putInteger ("muffin.port", Integer.parseInt (args[++i]));
		}
		catch (Exception e)
		{
		    System.out.println ("invalid port: " + args[i]);
		    System.exit (1) ;
		}
	    }
	    else if (args[i].equalsIgnoreCase ("-httpProxyHost"))
	    {
		options.putString ("muffin.httpProxyHost", args[++i]);
	    }
	    else if (args[i].equalsIgnoreCase ("-httpProxyPort"))
	    {
		try
		{
		    options.putInteger ("muffin.httpProxyPort", Integer.parseInt (args[++i]));
		}
		catch (Exception e)
		{
		    System.out.println ("invalid httpProxyPort: " + args[i]);
		    System.exit (1) ;
		}
	    }
	    else if (args[i].equalsIgnoreCase ("-help")
		     || args[i].equalsIgnoreCase ("--help")
		     || args[i].equalsIgnoreCase ("-h"))
	    {
		System.out.println ("Muffin Options:\n\n"
				    + "-help                 This useful message.\n"
				    + "-httpProxyHost HOST   Use HOST as the HTTP proxy.\n"
				    + "-httpProxyPort PORT   Use PORT as the HTTP proxy port.\n"
				    + "-port PORT            Listen on PORT for browser requests.\n");
		System.exit (1) ;
	    }
	    else 
	    {
		System.out.println ("unrecognized option: " + args[i]);
		System.exit (1) ;
	    }
	}
	new Main ();
    }
}
