/* ImageCanvas.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;

class ImageCanvas extends java.awt.Canvas
{
    Image image = null;
    Color bg = null;
    boolean border = false;
    
    ImageCanvas (String imageFile, Color bg, boolean border)
    {
	image = Toolkit.getDefaultToolkit().getImage (imageFile);
	
	this.bg = bg;
	this.border = border;

	if (this.bg != null)
	{
	    setBackground (bg);
	}
    }
    
    public Dimension preferredSize ()
    {
	return new Dimension (image.getWidth (this), image.getHeight (this));
    }

    public Dimension preferredSize (int rows)
    {
	return new Dimension (image.getWidth (this), image.getHeight (this));
    }

    public Dimension minimumSize ()
    {
	return new Dimension (image.getWidth (this), image.getHeight (this));
    }

    public Dimension minimumSize (int rows)
    {
	return new Dimension (image.getWidth (this), image.getHeight (this));
    }

    public void paint (Graphics g)
    {
	g.drawImage (image, 0, 0, this);
	if (border)
	{
	    g.setColor (Color.black);
	    g.drawRect (0, 0, image.getWidth (this)-1, image.getHeight (this)-1);
	}
    }
}
