/* Referer.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import muffin.*;
import java.awt.*;

public class Referer extends Frame implements RequestFilter
{
    String referer = null;
    TextField input = null;
    
    public Referer ()
    {
	super ("Referer");

	String sampleReferers[] =
	{
	    "http://www.nowhere.com/",
	    "http://www.webpagesthatsuck.com/",
	};

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	GridBagConstraints c;
        panel.setLayout (layout);

	panel.add (new Label ("Referer:", Label.RIGHT));

	input = new TextField (32);
	c = new GridBagConstraints ();
	c.anchor = GridBagConstraints.WEST;
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (input, c);
	panel.add (input);

	panel.add (new Label ("Sample Referers:", Label.RIGHT));

	Choice choice = new Choice ();
	for (int i = 0; i < sampleReferers.length; i++)
	{
	    choice.addItem (sampleReferers[i]);
	}
	
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (choice, c);
	panel.add (choice);
	
	add ("Center", panel);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 3));
	buttonPanel.add (new Button ("Apply"));
	buttonPanel.add (new Button ("Close"));
	add ("South", buttonPanel);

	pack ();
	resize (preferredSize ());
    }

    public void filter (Request r)
    {
	if (referer != null)
	{
	    r.setHeaderField ("Referer", referer);
	}
    }
    
    public void view ()
    {
	show ();
    }

    public boolean action (Event e, Object arg)
    {
	if (e.target instanceof Button)
	{
	    if ("Apply".equals (arg))
	    {
		String s = input.getText ();
		if (s != null && s.length () > 0)
		{
		    referer = s;
		}
		else
		{
		    referer = null;
		}
	    }
	    else if ("Close".equals (arg))
	    {
		hide ();
	    }
	    return true;
	}
	else if (e.target instanceof Choice)
	{
	    input.setText ((String)arg);
	}
	return false;
    }
}
