/* RefererFrame.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filters;

import java.awt.*;
import java.awt.event.*;
import muffin.*;

public class RefererFrame extends Frame implements ActionListener, ItemListener
{
    Prefs prefs;
    Referer parent;
    
    TextField input = null;
    
    public RefererFrame (Prefs prefs, Referer parent)
    {
	super ("Referer");

	this.prefs = prefs;
	this.parent = parent;

	String sampleReferers[] =
	{
	    "http://www.nowhere.com/",
            "http://www.webpagesthatsuck.com/",
            "CENSORED",
            "none",
            "Uhm... no",
	};
	
	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
        GridBagLayout layout = new GridBagLayout ();
        GridBagConstraints c;
        panel.setLayout (layout);

        panel.add (new Label ("Referer:", Label.RIGHT));

        input = new TextField (32);
	input.setText (prefs.getString ("Referer.referer"));
        c = new GridBagConstraints ();
        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = GridBagConstraints.REMAINDER;
        layout.setConstraints (input, c);
        panel.add (input);

        panel.add (new Label ("Sample Referers:", Label.RIGHT));

        Choice choice = new Choice ();
	choice.addItemListener (this);
        for (int i = 0; i < sampleReferers.length; i++)
        {
            choice.addItem (sampleReferers[i]);
        }
        
        c = new GridBagConstraints ();
        c.gridwidth = GridBagConstraints.REMAINDER;
        layout.setConstraints (choice, c);
        panel.add (choice);
        
        add ("Center", panel);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 3));
	Button b;
	b = new Button ("Apply");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Save");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Close");
	b.addActionListener (this);
	buttonPanel.add (b);
	add ("South", buttonPanel);
	
	pack ();
	setSize (getPreferredSize ());

	show ();
    }

    public void itemStateChanged (ItemEvent event)
    {
	input.setText (event.getItem ().toString ());
    }

    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();
	
	if ("Apply".equals (arg))
	{
	    prefs.putString ("Referer.referer", input.getText ());
	}
	else if ("Save".equals (arg))
	{
	    parent.save ();
	}
	else if ("Close".equals (arg))
	{
	    setVisible (false);
	}
    }
}
