/* Options.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * @author Mark Boyns
 */
public class Options extends Prefs
{
    String version = "0.4";
    Vector hostsAllow;
    Vector hostsDeny;
    boolean noWindow = false;
    
    public Options ()
    {
	/* Load the properties with some reasonable defaults. */
	putString ("muffin.version", version);
	putString ("muffin.port", "51966");
	putString ("muffin.httpProxyHost", ""); // proxy.domain.edu
	putString ("muffin.httpProxyPort", ""); // 3182
	putBoolean ("muffin.noWindow", false);

	/* By default only allow the localhost access */
	try
	{
	    InetAddress localhost = InetAddress.getLocalHost ();
	    putString ("muffin.hostsAllow", localhost.getHostAddress ());
	}
	/* If this fails allow access to everyone, oh well */
	catch (Exception e)
	{
	    putString ("muffin.hostsAllow", "ALL");
	}
	
	putString ("muffin.hostsDeny", "ALL");

	sync ();
    }
    
    void updateHostsAllow ()
    {
	hostsAllow = new Vector (100);
	StringTokenizer st = new StringTokenizer (getString ("muffin.hostsAllow"), ", \t");
	while (st.hasMoreTokens ())
	{
	    hostsAllow.addElement (st.nextToken ());
	}
    }

    void updateHostsDeny ()
    {
	hostsDeny = new Vector (100);
	StringTokenizer st = new StringTokenizer (getString ("muffin.hostsDeny"), ", \t");
	while (st.hasMoreTokens ())
	{
	    hostsDeny.addElement (st.nextToken ());
	}
    }

    void sync ()
    {
	updateHostsAllow ();
	updateHostsDeny ();
    }
    
    boolean hostAccess (InetAddress addr)
    {
	String ip = addr.getHostAddress ();
	    
	/* First check if the addr in on the allow list */
	Enumeration e = hostsAllow.elements ();
 	while (e.hasMoreElements ())
 	{
	    String str = (String) e.nextElement ();
	    if (str.equals ("ALL") || ip.startsWith (str))
	    {
		return true;
	    }
	}

	/* Next check if the addr in on the deny list */
	e = hostsDeny.elements ();
 	while (e.hasMoreElements ())
 	{
	    String str = (String) e.nextElement ();
	    if (str.equals ("ALL") || ip.startsWith (str))
	    {
		return false;
	    }
	}

	/* Otherwise allow access */
	return true;
    }

    boolean useProxy ()
    {
	return ((getString ("muffin.httpProxyHost")).length () > 0
		&& getInteger ("muffin.httpProxyPort") > 0);
    }
}
