/*
 * Decompiled with CFR 0.152.
 */
package JP.ac.osaka_u.ender.util.regex;

import JP.ac.osaka_u.ender.util.regex.Chars;
import JP.ac.osaka_u.ender.util.regex.RTree;
import JP.ac.osaka_u.ender.util.regex.RegExpSyntaxException;
import java.util.Hashtable;

class RegExpParser {
    private static final int TK_END = 0;
    private static final int TK_CHAR = 1;
    private static final int TK_CHARCLASS = 2;
    private static final int TK_UNION = 10;
    private static final int TK_LPAR = 11;
    private static final int TK_RPAR = 12;
    private static final int TK_CLOSURE = 13;
    private static final int TK_PLUS = 14;
    private static final int TK_QUESTION = 15;
    private static final int TK_ANYCHAR = 16;
    private static final int TK_LBRA = 17;
    private static final int TK_LBRANEG = 18;
    private static final int TK_RBRA = 19;
    private static final int TK_LHEAD = 20;
    private static final int TK_LTAIL = 21;
    private static final char CHAR_VL = '|';
    private static final char CHAR_LPAR = '(';
    private static final char CHAR_RPAR = ')';
    private static final char CHAR_ASTERISK = '*';
    private static final char CHAR_PLUS = '+';
    private static final char CHAR_QUESTION = '?';
    private static final char CHAR_DOT = '.';
    private static final char CHAR_LBRA = '[';
    private static final char CHAR_RBRA = ']';
    private static final char CHAR_CARET = '^';
    private static final char CHAR_DOLLAR = '$';
    private static final char CHAR_MINUS = '-';
    private static final char CHAR_BKSLASH = '\\';
    private static final String MSG_INVALID_ESCAPE = "Invalid escape character.";
    private static final String MSG_INVALID_CHARRANGE = "Invalid character range.";
    private static final String MSG_RBRA_EXPECTED = "\"]\" is expected.";
    private static final String MSG_RPAR_EXPECTED = "\")\" is expected.";
    private static final String MSG_CHAR_EXPECTED = "Normal character is expected.";
    private int currentToken;
    private Chars tokenChars;
    private String strbuff = "";
    private int pstr = 0;
    private boolean inCharClass = false;
    private static Hashtable escapeTable = new Hashtable();

    private void initialize(String string) throws RegExpSyntaxException {
        this.strbuff = this.processEscape(string);
        this.pstr = 0;
        this.nextToken();
    }

    private String processEscape(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            String string3;
            String string4;
            char c = string.charAt(n);
            string2 = c == '\\' ? ((string4 = (String)escapeTable.get(string3 = string.substring(++n, n + 1))) == null ? String.valueOf(string2) + "\\" + string3 : String.valueOf(string2) + string4) : String.valueOf(string2) + c;
            ++n;
        }
        return string2;
    }

    private void nextToken() throws RegExpSyntaxException {
        if (this.inCharClass) {
            int n = this.getTokenCC();
            if (n == 19) {
                this.inCharClass = false;
                return;
            }
        } else {
            int n = this.getTokenStd();
            if (n == 17 || n == 18) {
                this.inCharClass = true;
            }
        }
    }

    private int getTokenStd() throws RegExpSyntaxException {
        if (this.pstr == this.strbuff.length()) {
            this.currentToken = 0;
        } else {
            char c = this.strbuff.charAt(this.pstr++);
            switch (c) {
                case '|': {
                    this.currentToken = 10;
                    break;
                }
                case '(': {
                    this.currentToken = 11;
                    break;
                }
                case ')': {
                    this.currentToken = 12;
                    break;
                }
                case '*': {
                    this.currentToken = 13;
                    break;
                }
                case '+': {
                    this.currentToken = 14;
                    break;
                }
                case '?': {
                    this.currentToken = 15;
                    break;
                }
                case '.': {
                    this.currentToken = 16;
                    break;
                }
                case '^': {
                    this.currentToken = 20;
                    this.tokenChars = new Chars(c);
                    break;
                }
                case '$': {
                    this.currentToken = 21;
                    this.tokenChars = new Chars(c);
                    break;
                }
                case '[': {
                    if (this.pstr == this.strbuff.length()) {
                        throw new RegExpSyntaxException(MSG_RBRA_EXPECTED);
                    }
                    if ((c = this.strbuff.charAt(this.pstr++)) == '^') {
                        this.currentToken = 18;
                        break;
                    }
                    --this.pstr;
                    this.currentToken = 17;
                    break;
                }
                case '\\': {
                    if (this.pstr == this.strbuff.length()) {
                        throw new RegExpSyntaxException(MSG_INVALID_ESCAPE);
                    }
                    this.currentToken = 1;
                    this.tokenChars = new Chars(this.strbuff.charAt(this.pstr++));
                    break;
                }
                default: {
                    this.currentToken = 1;
                    this.tokenChars = new Chars(c);
                    break;
                }
            }
        }
        return this.currentToken;
    }

    private int getTokenCC() throws RegExpSyntaxException {
        char c;
        if (this.pstr == this.strbuff.length()) {
            throw new RegExpSyntaxException(MSG_RBRA_EXPECTED);
        }
        if ((c = this.strbuff.charAt(this.pstr++)) == ']') {
            this.currentToken = 19;
        } else {
            char c2;
            if (c == '\\') {
                if (this.pstr == this.strbuff.length()) {
                    throw new RegExpSyntaxException("Illegal escape sequense.");
                }
                c = this.strbuff.charAt(this.pstr++);
            }
            this.currentToken = 1;
            if ((c2 = this.strbuff.charAt(this.pstr++)) == '-') {
                char c3;
                if (this.pstr == this.strbuff.length()) {
                    throw new RegExpSyntaxException(MSG_RBRA_EXPECTED);
                }
                if ((c3 = this.strbuff.charAt(this.pstr++)) == ']') {
                    this.pstr -= 2;
                    this.tokenChars = new Chars(c);
                } else {
                    if (c3 == '\\') {
                        if (this.pstr == this.strbuff.length()) {
                            throw new RegExpSyntaxException(MSG_INVALID_ESCAPE);
                        }
                        c3 = this.strbuff.charAt(this.pstr++);
                    }
                    this.currentToken = 2;
                    if (c > c3) {
                        throw new RegExpSyntaxException(MSG_INVALID_CHARRANGE);
                    }
                    this.tokenChars = new Chars(c, c3);
                }
            } else {
                --this.pstr;
                this.tokenChars = new Chars(c);
            }
        }
        return this.currentToken;
    }

    private RTree regexp() throws RegExpSyntaxException {
        RTree rTree = this.term();
        while (this.currentToken == 10) {
            this.nextToken();
            rTree = new RTree(3, rTree, this.term());
        }
        return rTree;
    }

    private RTree term() throws RegExpSyntaxException {
        RTree rTree;
        if (this.currentToken == 10 || this.currentToken == 12 || this.currentToken == 0) {
            rTree = new RTree(0, null, null);
        } else {
            rTree = this.factor();
            while (this.currentToken != 10 && this.currentToken != 12 && this.currentToken != 0) {
                rTree = new RTree(2, rTree, this.factor());
            }
        }
        return rTree;
    }

    private RTree factor() throws RegExpSyntaxException {
        RTree rTree = this.primary();
        if (this.currentToken == 13) {
            rTree = new RTree(4, rTree, null);
            this.nextToken();
        } else if (this.currentToken == 14) {
            rTree = new RTree(2, rTree, new RTree(4, rTree, null));
            this.nextToken();
        } else if (this.currentToken == 15) {
            rTree = new RTree(3, rTree, new RTree(0, null, null));
            this.nextToken();
        }
        return rTree;
    }

    private RTree primary() throws RegExpSyntaxException {
        RTree rTree;
        switch (this.currentToken) {
            case 1: {
                rTree = new RTree(this.tokenChars);
                this.nextToken();
                break;
            }
            case 20: {
                rTree = new RTree(5, this.tokenChars, null, null);
                this.nextToken();
                break;
            }
            case 21: {
                rTree = new RTree(6, this.tokenChars, null, null);
                this.nextToken();
                break;
            }
            case 16: {
                rTree = new RTree(new Chars('\u0000', '\uffff'));
                this.nextToken();
                break;
            }
            case 11: {
                this.nextToken();
                rTree = this.regexp();
                if (this.currentToken != 12) {
                    throw new RegExpSyntaxException(MSG_RPAR_EXPECTED);
                }
                this.nextToken();
                break;
            }
            case 17: {
                rTree = this.charClass();
                if (this.currentToken != 19) {
                    throw new RegExpSyntaxException(MSG_RBRA_EXPECTED);
                }
                this.nextToken();
                break;
            }
            case 18: {
                rTree = this.negativeCharClass();
                if (this.currentToken != 19) {
                    throw new RegExpSyntaxException(MSG_RBRA_EXPECTED);
                }
                this.nextToken();
                break;
            }
            default: {
                throw new RegExpSyntaxException(MSG_CHAR_EXPECTED);
            }
        }
        return rTree;
    }

    private RTree charClass() throws RegExpSyntaxException {
        this.nextToken();
        if (this.currentToken == 19) {
            throw new RegExpSyntaxException("Invalid character class.");
        }
        RTree rTree = new RTree(this.tokenChars);
        this.nextToken();
        while (this.currentToken != 19) {
            rTree = new RTree(3, rTree, new RTree(this.tokenChars));
            this.nextToken();
        }
        return rTree;
    }

    private RTree negativeCharClass() throws RegExpSyntaxException {
        this.nextToken();
        if (this.currentToken == 19) {
            throw new RegExpSyntaxException("Invalid character class.");
        }
        RTree rTree = new RTree(new Chars('\u0000', '\uffff'));
        while (this.currentToken != 19) {
            rTree.removeChars(this.tokenChars);
            this.nextToken();
        }
        return rTree;
    }

    public RTree parse(String string) throws RegExpSyntaxException {
        this.initialize(string);
        RTree rTree = this.regexp();
        if (this.currentToken != 0) {
            throw new RegExpSyntaxException("Extra character at end of pattren.");
        }
        return rTree;
    }

    static {
        escapeTable.put("0", "\u0000");
        escapeTable.put("b", "\b");
        escapeTable.put("t", "\t");
        escapeTable.put("r", "\r");
        escapeTable.put("n", "\n");
        escapeTable.put("d", "[0-9]");
        escapeTable.put("D", "[^0-9]");
        escapeTable.put("s", "[ \t\r\n]");
        escapeTable.put("S", "[^ \t\r\n]");
        escapeTable.put("w", "[0-9A-Z_a-z]");
        escapeTable.put("W", "[^0-9A-Z_a-z]");
    }
}

