/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.util.Vector;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManagerFrame;
import muffin.Prefs;
import muffin.UserPrefs;

public class FilterManager {
    Vector knownFilters;
    Vector enabledFilters;
    UserPrefs userPrefs;
    FilterManagerFrame frame;

    public FilterManager(UserPrefs userPrefs) {
        String[] stringArray = new String[]{"muffin.filter.AnimationKiller", "muffin.filter.CookieMonster", "muffin.filter.Decaf", "muffin.filter.DocumentInfo", "muffin.filter.Glossary", "muffin.filter.Logger", "muffin.filter.Painter", "muffin.filter.Preview", "muffin.filter.NoThanks", "muffin.filter.Referer", "muffin.filter.Secretary", "muffin.filter.SecretAgent", "muffin.filter.SecretServer", "muffin.filter.Snoop", "muffin.filter.Stats"};
        this.userPrefs = userPrefs;
        this.knownFilters = new Vector(32);
        String[] stringArray2 = userPrefs.getStringList("muffin.knownFilters");
        if (stringArray2.length == 0) {
            stringArray2 = stringArray;
        }
        int n = 0;
        while (n < stringArray2.length) {
            this.knownFilters.addElement(stringArray2[n]);
            ++n;
        }
        this.enabledFilters = new Vector(32);
        stringArray2 = userPrefs.getStringList("muffin.enabledFilters");
        n = 0;
        while (n < stringArray2.length) {
            this.enable(stringArray2[n]);
            ++n;
        }
    }

    public Filter[] createFilters() {
        Filter[] filterArray = new Filter[this.enabledFilters.size()];
        int n = 0;
        while (n < filterArray.length) {
            FilterFactory filterFactory = (FilterFactory)this.enabledFilters.elementAt(n);
            filterArray[n] = filterFactory.createFilter();
            ++n;
        }
        return filterArray;
    }

    public void createFrame() {
        if (this.frame == null) {
            this.frame = new FilterManagerFrame(this);
        }
        this.frame.hideshow();
    }

    public void append(String string) {
        this.knownFilters.addElement(string);
        if (this.frame != null) {
            this.frame.updateKnownFiltersList();
        }
    }

    public void remove(int n) {
        this.knownFilters.removeElementAt(n);
        if (this.frame != null) {
            this.frame.updateKnownFiltersList();
        }
    }

    public void enable(String string) {
        try {
            System.out.println("Enabling " + string);
            FilterFactory filterFactory = (FilterFactory)Class.forName(string).newInstance();
            Prefs prefs = this.userPrefs.extract(string.substring(string.lastIndexOf(46) + 1));
            filterFactory.setPrefs(prefs);
            filterFactory.setManager(this);
            this.enabledFilters.addElement(filterFactory);
            String[] stringArray = new String[this.enabledFilters.size()];
            int n = 0;
            while (n < stringArray.length) {
                filterFactory = (FilterFactory)this.enabledFilters.elementAt(n);
                stringArray[n] = filterFactory.getClass().getName();
                ++n;
            }
            this.userPrefs.putStringList("muffin.enabledFilters", stringArray);
            if (this.frame != null) {
                this.frame.updateEnabledFiltersList();
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("");
            System.out.println("WARNING: Can't load " + string + ": ");
            System.out.println("");
            System.out.println("         " + exception);
            System.out.println("");
            System.out.println("         You may need to restart muffin with a different CLASSPATH.");
            System.out.println("");
        }
    }

    public void disable(int n) {
        FilterFactory filterFactory = (FilterFactory)this.enabledFilters.elementAt(n);
        System.out.println("Disabling " + filterFactory.getClass().getName());
        this.enabledFilters.removeElementAt(n);
        if (this.frame != null) {
            this.frame.updateEnabledFiltersList();
        }
    }

    public void save() {
        this.userPrefs.save();
    }

    public void save(FilterFactory filterFactory) {
        this.userPrefs.merge(filterFactory.getPrefs());
        this.userPrefs.save();
    }
}

