/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.awt.Component;
import muffin.Cookie;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.Prefs;
import muffin.filter.CookieMonsterFilter;
import muffin.filter.CookieMonsterFrame;

public class CookieMonster
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    CookieMonsterFrame frame;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putBoolean("CookieMonster.eatRequestCookies", true);
        prefs.putBoolean("CookieMonster.eatReplyCookies", true);
        prefs.setOverride(bl);
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new CookieMonsterFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        CookieMonsterFilter cookieMonsterFilter = new CookieMonsterFilter(this);
        cookieMonsterFilter.setPrefs(this.prefs);
        return cookieMonsterFilter;
    }

    void save() {
        this.manager.save(this);
    }

    void process(Cookie cookie) {
        if (this.frame != null) {
            this.frame.text.append("Eating " + cookie.toString() + "\n");
        }
    }
}

