/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import muffin.ContentFilter;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;
import muffin.filter.Test;
import muffin.html.HtmlTokenizer;
import muffin.html.Tag;

public class DocumentInfo
implements FilterFactory,
ContentFilter {
    FilterManager manager;
    Prefs prefs;
    Test factory;
    InputStream in;
    OutputStream out;
    Reply reply;
    Request request;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        System.out.println("DocumentInfo: no preferences");
    }

    public Filter createFilter() {
        DocumentInfo documentInfo = new DocumentInfo();
        documentInfo.setPrefs(this.prefs);
        return documentInfo;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
        String string = reply.getHeaderField("Content-type");
        return string != null && string.startsWith("text/html");
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void run() {
        try {
            int n;
            Object object;
            int n2;
            HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this.in);
            while ((n2 = htmlTokenizer.getToken()) != -1) {
                if (n2 == -2) {
                    Tag tag = htmlTokenizer.getTag();
                    if (tag.is("body")) {
                        htmlTokenizer.writeTag(tag, this.out);
                        object = new StringBuffer();
                        ((StringBuffer)object).append("<small>\n");
                        ((StringBuffer)object).append("URL: ");
                        ((StringBuffer)object).append(this.request.getURL());
                        ((StringBuffer)object).append("<br>\n");
                        if (this.reply.containsHeaderField("Server")) {
                            ((StringBuffer)object).append("Server: ");
                            ((StringBuffer)object).append(this.reply.getHeaderField("Server"));
                            ((StringBuffer)object).append("<br>\n");
                        }
                        if (this.reply.containsHeaderField("Last-Modified")) {
                            ((StringBuffer)object).append("Last-Modified: ");
                            String string = this.reply.getHeaderField("Last-Modified");
                            try {
                                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance();
                                switch (string.charAt(3)) {
                                    case ',': {
                                        simpleDateFormat.applyPattern("EEE, dd MMM yyyy HH:mm:ss z");
                                        break;
                                    }
                                    case ' ': {
                                        simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
                                        break;
                                    }
                                    default: {
                                        simpleDateFormat.applyPattern("EEEE, dd-MMM-yyyy HH:mm:ss z");
                                    }
                                }
                                ParsePosition parsePosition = new ParsePosition(0);
                                Date date = simpleDateFormat.parse(this.reply.getHeaderField("Last-Modified"), parsePosition);
                                ((StringBuffer)object).append(simpleDateFormat.format(date));
                            }
                            catch (Exception exception) {
                                ((StringBuffer)object).append(string);
                            }
                            ((StringBuffer)object).append("<br>\n");
                        }
                        ((StringBuffer)object).append("</small>\n");
                        this.out.write(((StringBuffer)object).toString().getBytes(), 0, ((StringBuffer)object).length());
                        break;
                    }
                    htmlTokenizer.writeTag(tag, this.out);
                    continue;
                }
                htmlTokenizer.writeToken(this.out);
            }
            object = new byte[8192];
            while ((n = this.in.read((byte[])object, 0, ((byte[])object).length)) > 0) {
                this.out.write((byte[])object, 0, n);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

