/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import JP.ac.osaka_u.ender.util.regex.MatchInfo;
import JP.ac.osaka_u.ender.util.regex.NFABuildException;
import JP.ac.osaka_u.ender.util.regex.RegExp;
import JP.ac.osaka_u.ender.util.regex.RegExpSyntaxException;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.Prefs;
import muffin.filter.NoThanksFilter;
import muffin.filter.NoThanksFrame;

public class NoThanks
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    NoThanksFrame frame;
    String[] hyperlist = new String[]{"href", "src", "action", "base", "background"};
    private RegExp kill;
    private RegExp comment;
    private RegExp hypertags;
    private RegExp content;
    private Hashtable strip;
    private Vector redirectPatterns;
    private Vector redirectLocations;

    public NoThanks() {
        try {
            this.hypertags = new RegExp("^a|img|background$");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = prefs.getUserFile("killfile");
        prefs.putString("NoThanks.killfile", string);
        prefs.setOverride(bl);
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new NoThanksFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        NoThanksFilter noThanksFilter = new NoThanksFilter(this);
        noThanksFilter.setPrefs(this.prefs);
        return noThanksFilter;
    }

    boolean isKilled(String string) {
        if (this.kill == null) {
            return false;
        }
        MatchInfo matchInfo = this.kill.match(string);
        return matchInfo != null;
    }

    boolean killComment(String string) {
        if (this.comment == null) {
            return false;
        }
        MatchInfo matchInfo = this.comment.match(string);
        return matchInfo != null;
    }

    boolean killContent(String string) {
        if (this.content == null) {
            return false;
        }
        MatchInfo matchInfo = this.content.match(string);
        return matchInfo != null;
    }

    boolean stripTag(String string) {
        return this.strip.containsKey(string);
    }

    String stripUntil(String string) {
        String string2 = (String)this.strip.get(string);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    String redirect(String string) {
        int n = 0;
        while (n < this.redirectPatterns.size()) {
            RegExp regExp = (RegExp)this.redirectPatterns.elementAt(n);
            MatchInfo matchInfo = regExp.match(string);
            if (matchInfo != null) {
                return (String)this.redirectLocations.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    boolean checkTag(String string) {
        MatchInfo matchInfo = this.hypertags.match(string);
        return matchInfo != null;
    }

    void save() {
        this.manager.save(this);
    }

    void load() {
        this.strip = new Hashtable(33);
        this.redirectPatterns = new Vector();
        this.redirectLocations = new Vector();
        String string = this.prefs.getString("NoThanks.killfile");
        System.out.println("NoThanks loading " + string);
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("NoThanks can't open " + string);
            return;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String string4;
                if (string2.startsWith("#")) continue;
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string2));
                streamTokenizer.resetSyntax();
                streamTokenizer.commentChar(35);
                streamTokenizer.whitespaceChars(0, 32);
                streamTokenizer.wordChars(33, 126);
                streamTokenizer.quoteChar(34);
                streamTokenizer.eolIsSignificant(true);
                int n = streamTokenizer.nextToken();
                if (n != -3) continue;
                if (streamTokenizer.sval.equals("kill")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("comment")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append("|");
                    }
                    stringBuffer2.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("strip")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    string4 = new String(streamTokenizer.sval);
                    string3 = "";
                    n = streamTokenizer.nextToken();
                    if (n == -3 || n == 34) {
                        string3 = new String(streamTokenizer.sval);
                    }
                    this.strip.put(string4, string3);
                    continue;
                }
                if (streamTokenizer.sval.equals("content")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (stringBuffer3.length() > 0) {
                        stringBuffer3.append("|");
                    }
                    stringBuffer3.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("redirect")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    string4 = new String(streamTokenizer.sval);
                    string3 = "";
                    n = streamTokenizer.nextToken();
                    if (n == -3 || n == 34) {
                        string3 = new String(streamTokenizer.sval);
                    }
                    try {
                        RegExp regExp = new RegExp(string4);
                        this.redirectPatterns.addElement(regExp);
                        this.redirectLocations.addElement(string3);
                    }
                    catch (RegExpSyntaxException regExpSyntaxException) {
                        System.out.println(String.valueOf(string4) + " " + regExpSyntaxException.getMessage());
                    }
                    catch (NFABuildException nFABuildException) {
                        System.out.println(String.valueOf(string4) + " " + nFABuildException.getMessage());
                    }
                    continue;
                }
                System.out.println("NoThanks: " + streamTokenizer.sval + " unknown command");
            }
            bufferedReader.close();
            this.kill = stringBuffer.length() > 0 ? new RegExp(stringBuffer.toString()) : null;
            this.comment = stringBuffer2.length() > 0 ? new RegExp(stringBuffer2.toString()) : null;
            if (stringBuffer3.length() > 0) {
                this.content = new RegExp(stringBuffer3.toString());
                return;
            }
            this.content = null;
            return;
        }
        catch (RegExpSyntaxException regExpSyntaxException) {
            System.out.println("NoThanks RegExpSyntaxException: " + regExpSyntaxException.getMessage());
            return;
        }
        catch (NFABuildException nFABuildException) {
            System.out.println("NoThanks NFABuildException: " + nFABuildException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void process(String string) {
        if (this.frame != null) {
            this.frame.text.append(string);
        }
    }
}

