/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.io.InputStream;
import java.io.OutputStream;
import muffin.ContentFilter;
import muffin.FilterException;
import muffin.Prefs;
import muffin.Reply;
import muffin.ReplyFilter;
import muffin.Request;
import muffin.RequestFilter;
import muffin.filter.NoThanks;
import muffin.html.HtmlTokenizer;
import muffin.html.Tag;

public class NoThanksFilter
implements ContentFilter,
RequestFilter,
ReplyFilter {
    NoThanks factory;
    Prefs prefs;
    InputStream in;
    OutputStream out;
    Request request;

    public NoThanksFilter(NoThanks noThanks) {
        this.factory = noThanks;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Request request) throws FilterException {
        String string = request.getURL();
        String string2 = this.factory.redirect(string);
        if (string2 != null) {
            request.setURL(string2);
            return;
        }
        if (this.factory.isKilled(string)) {
            this.factory.process("Killed: " + string + "\n");
            throw new FilterException("NoThanks URL " + string + " rejected");
        }
    }

    public void filter(Reply reply) throws FilterException {
        String string = reply.getHeaderField("Content-type");
        if (string != null && this.factory.killContent(string)) {
            this.factory.process("Killed: " + string + "\n");
            throw new FilterException("NoThanks content-type " + string + " rejected");
        }
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getHeaderField("Content-type");
        return string != null && string.startsWith("text/html");
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void run() {
        try {
            int n;
            HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this.in);
            String string = null;
            boolean bl = false;
            block6: while ((n = htmlTokenizer.getToken()) != -1) {
                if (bl && n != -8) continue;
                switch (n) {
                    case -8: {
                        String string2 = htmlTokenizer.getTokenValue();
                        bl = this.factory.killComment(string2);
                        if (bl) {
                            this.factory.process("Comment: " + string2 + "\n");
                            break;
                        }
                        htmlTokenizer.writeToken(this.out);
                        break;
                    }
                    case -2: {
                        boolean bl2 = true;
                        Tag tag = htmlTokenizer.getTag();
                        if (string != null && tag.is(string)) {
                            string = null;
                            break;
                        }
                        if (this.factory.stripTag(tag.name())) {
                            this.factory.process("Stripped: " + tag.name() + "\n");
                            string = this.factory.stripUntil(tag.name());
                            bl2 = false;
                        } else if (this.factory.checkTag(tag.name())) {
                            int n2 = 0;
                            while (n2 < this.factory.hyperlist.length) {
                                String string3;
                                if (tag.has(this.factory.hyperlist[n2]) && this.factory.isKilled(string3 = tag.get(this.factory.hyperlist[n2]))) {
                                    this.factory.process("Killed: " + string3 + "\n");
                                    bl2 = false;
                                    if (!tag.is("a")) break;
                                    string = "/a";
                                    break;
                                }
                                ++n2;
                            }
                        }
                        if (!bl2) continue block6;
                        htmlTokenizer.writeTag(tag, this.out);
                        break;
                    }
                    default: {
                        if (string != null) continue block6;
                        htmlTokenizer.writeToken(this.out);
                        break;
                    }
                }
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

