/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

public class TokenCharacters {
    private static final String EOL = "\n\r";
    public static final String WHITESPACE = " \t\n\r";
    public static final char ESCAPE_CHAR = '\\';
    public static final String COMMENT_CHAR = "#";
    public static final char QUOTE_CHAR = '\'';
    private String whitespace;
    private String commentChars;
    private String beginQuoteChars;
    private String endQuoteChars;
    private String separators;
    private static final int NOT_FOUND = -1;

    public TokenCharacters() {
        this("");
    }

    public TokenCharacters(String string) {
        this(string, COMMENT_CHAR, '\'', '\'', WHITESPACE);
    }

    public TokenCharacters(String string, String string2, char c, char c2, String string3) {
        this.separators = this.nullFilter(string);
        this.commentChars = this.nullFilter(string2);
        this.whitespace = this.nullFilter(string3);
        this.beginQuoteChars = String.valueOf(c);
        this.endQuoteChars = String.valueOf(c2);
    }

    public void addQuoteChars(char c, char c2) {
        this.beginQuoteChars = String.valueOf(this.beginQuoteChars) + c;
        this.endQuoteChars = String.valueOf(this.endQuoteChars) + c2;
    }

    public char getCommentChar() {
        return this.commentChars.charAt(0);
    }

    public void setSeparatorChars(String string) {
        this.separators = this.nullFilter(string);
    }

    public boolean isEOL(char c) {
        return TokenCharacters.containsChar(EOL, c);
    }

    public boolean isEscape(char c) {
        return c == '\\';
    }

    public boolean isWhitespace(char c) {
        return TokenCharacters.containsChar(this.whitespace, c);
    }

    public boolean isSeparator(char c) {
        return TokenCharacters.containsChar(this.separators, c);
    }

    public boolean isBeginQuote(char c) {
        return TokenCharacters.containsChar(this.beginQuoteChars, c);
    }

    public boolean isEndQuote(char c) {
        return TokenCharacters.containsChar(this.endQuoteChars, c);
    }

    public boolean isComment(char c) {
        return TokenCharacters.containsChar(this.commentChars, c);
    }

    public boolean isTokenTerminator(char c) {
        return TokenCharacters.containsChar(String.valueOf(this.whitespace) + this.separators + this.commentChars, c);
    }

    public boolean isQuotePair(char c, char c2) {
        int n = this.beginQuoteChars.indexOf(c);
        if (n == -1) {
            return false;
        }
        return this.endQuoteChars.charAt(n) == c2;
    }

    public boolean requiresEscaping(char c) {
        return TokenCharacters.containsChar(String.valueOf(this.beginQuoteChars) + this.endQuoteChars + '\\', c);
    }

    public boolean containsEscapeableChar(String string) {
        String string2 = String.valueOf(this.beginQuoteChars) + this.endQuoteChars + '\\';
        return TokenCharacters.containsChar(string, string2);
    }

    public String escapeToken(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        String string2 = String.valueOf(this.beginQuoteChars) + this.endQuoteChars + '\\';
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (TokenCharacters.containsChar(string2, c)) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean containsTokenTerminator(String string) {
        String string2 = String.valueOf(this.whitespace) + this.commentChars + this.separators;
        return TokenCharacters.containsChar(string, string2);
    }

    public String quoteToken(String string) {
        return String.valueOf(this.beginQuoteChars.charAt(0)) + string + this.endQuoteChars.charAt(0);
    }

    private String nullFilter(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static final boolean containsChar(String string, char c) {
        return string.indexOf(c) != -1;
    }

    private static final boolean containsChar(String string, String string2) {
        int n = 0;
        while (n < string2.length()) {
            if (string.indexOf(string2.charAt(n)) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

