/* HttpError.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

class HttpError
{
    StringBuffer content = null;
    Reply reply = null;
    
    HttpError (Options options, int code, String message)
    {
	String error;
	switch (code)
	{
	case 400:
	    error = "Bad Request";
	    break;

	case 403:
	    error = "Forbidden";
	    break;

	case 404:
	    error = "Not found";
	    break;

	case 503:
	    error = "Service Unavailable";
	    break;

	default:
	    error = "Error";
	    break;
	}

	reply = new Reply ();
	reply.statusLine = "HTTP/1.0 " + code + " " + error;
	reply.setHeaderField ("Content-type", "text/html");
	reply.setHeaderField ("Server", "Muffin/" + options.getString ("muffin.version"));

	content = new StringBuffer ();
	content.append ("<title>" + error + "</title>\r\n");
	content.append ("<body bgcolor=\"#FFFFFF\">\r\n");
	content.append ("<h1>" + error + "</h1>\r\n<hr noshade size=4>\r\n");
	content.append (message);
	content.append ("<p>\r\n<hr noshade size=4>\r\n");
	content.append ("<a href=\"" + options.getString ("muffin.url") + "\">");
	content.append ("<i><img border=0 alt=\"\" src=\"" + Httpd.getLocation () + "/images/mufficon.jpg\">");
	content.append ("Generated by Muffin " + options.getString ("muffin.version") + "</a></i>");
	content.append ("</body>\r\n");
    }

    Reply getReply ()
    {
	return reply;
    }

    String getContent ()
    {
	if (content == null)
	{
	    return null;
	}
	return content.toString ();
    }

    public String toString ()
    {
	StringBuffer buf = new StringBuffer ();
	if (reply != null)
	{
	    buf.append (reply.toString ());
	}
	if (content != null)
	{
	    buf.append (content.toString ());
	}
	return buf.toString ();
    }
}
