package muffin.filter;

import java.awt.*;
import java.awt.event.*;
import muffin.*;

class PreviewDialog extends Dialog implements ActionListener, WindowListener
{
    byte content[] = null;
    boolean accepted = true;
    TextArea text = null;
    Image image = null;
    
    PreviewDialog (Frame frame, Request request, Reply reply, byte content[])
    {
	super (frame, "", true);

	this.content = content;
	    
	if (reply.getHeaderField ("Content-type").startsWith ("text"))
	{
	    text = new TextArea ();
	    text.setEditable (true);
	    text.setText (new String (content));
	    add ("Center", text);
	}
	else if (reply.getHeaderField ("Content-type").startsWith ("image"))
	{
	    image = Toolkit.getDefaultToolkit ().createImage (content);
	    ImageCanvas ic = new ImageCanvas (image);
	    add ("Center", ic);
	}

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 2));
	Button b;
	b = new Button ("Accept");
	b.setActionCommand ("doAccept");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Reject");
	b.setActionCommand ("doReject");
	b.addActionListener (this);
	buttonPanel.add (b);
	add ("South", buttonPanel);

	addWindowListener (this);
	pack ();
	setSize (getPreferredSize ());
    }

    public boolean accept ()
    {
	return accepted;
    }

    public byte[] getContent ()
    {
	return content;
    }

    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();
	
	if ("doAccept".equals (arg))
	{
	    accepted = true;
	    if (text != null)
	    {
		content = text.getText ().getBytes ();
	    }
	    setVisible (false);
	}
	else if ("doReject".equals (arg))
	{
	    accepted = false;
	    setVisible (false);
	}
    }

    public void windowActivated (WindowEvent e)
    {
    }
  
    public void windowDeactivated (WindowEvent e)
    {
    }
  
    public void windowClosing (WindowEvent e)
    {
	setVisible (false);
    }
  
    public void windowClosed (WindowEvent e)
    {
    }
  
    public void windowIconified (WindowEvent e)
    {
    }
  
    public void windowDeiconified (WindowEvent e)
    {
    }
  
    public void windowOpened (WindowEvent e)
    {
    }
}
