/*
 * Decompiled with CFR 0.152.
 */
package JP.ac.osaka_u.ender.util.regex;

import JP.ac.osaka_u.ender.util.regex.Chars;
import JP.ac.osaka_u.ender.util.regex.NFABuildException;
import JP.ac.osaka_u.ender.util.regex.NList;
import JP.ac.osaka_u.ender.util.regex.RTree;
import java.util.Hashtable;

class RegExpNFA {
    private Hashtable nfa = new Hashtable();
    private int nfaEntry;
    private int nfaExit;
    private int count;
    private RTree tree;
    private boolean hasLHead = false;
    private boolean hasLTail = false;
    private static final String MSG_INVALID_OPERATION = "Invalid operation.";

    public RegExpNFA(RTree rTree) throws NFABuildException {
        this.tree = rTree;
        this.buildNfa();
    }

    private int genNode() throws NFABuildException {
        return this.count++;
    }

    private void addTransition(int n, int n2, Chars chars) {
        Integer n3 = new Integer(n);
        NList nList = new NList(chars, n2, (NList)this.nfa.get(n3));
        this.nfa.put(n3, nList);
    }

    private void genNfa(RTree rTree, int n, int n2) throws NFABuildException {
        switch (rTree.operation()) {
            case 1: {
                this.addTransition(n, n2, rTree.chars());
                return;
            }
            case 5: {
                if (n != this.nfaEntry) {
                    this.addTransition(n, n2, rTree.chars());
                    return;
                }
                this.hasLHead = true;
                this.addTransition(n, n2, new Chars(2));
                return;
            }
            case 6: {
                if (n2 != this.nfaExit) {
                    this.addTransition(n, n2, rTree.chars());
                    return;
                }
                this.hasLTail = true;
                this.addTransition(n, n2, new Chars(3));
                return;
            }
            case 0: {
                this.addTransition(n, n2, new Chars(0));
                return;
            }
            case 3: {
                this.genNfa(rTree.left(), n, n2);
                this.genNfa(rTree.right(), n, n2);
                return;
            }
            case 4: {
                int n3 = this.genNode();
                int n4 = this.genNode();
                this.addTransition(n, n3, new Chars(0));
                this.genNfa(rTree.left(), n3, n4);
                this.addTransition(n4, n3, new Chars(0));
                this.addTransition(n3, n2, new Chars(0));
                return;
            }
            case 2: {
                int n5 = this.genNode();
                this.genNfa(rTree.left(), n, n5);
                this.genNfa(rTree.right(), n5, n2);
                return;
            }
        }
        throw new NFABuildException(MSG_INVALID_OPERATION);
    }

    private void buildNfa() throws NFABuildException {
        this.nfaEntry = this.genNode();
        this.nfaExit = this.genNode();
        this.genNfa(this.tree, this.nfaEntry, this.nfaExit);
    }

    public NList getNList(int n) {
        Integer n2 = new Integer(n);
        return (NList)this.nfa.get(n2);
    }

    public int entry() {
        return this.nfaEntry;
    }

    public int exit() {
        return this.nfaExit;
    }

    public int count() {
        return this.count;
    }

    public boolean hasLHead() {
        return this.hasLHead;
    }

    public boolean hasLTail() {
        return this.hasLTail;
    }

    public RTree getTree() {
        return this.tree;
    }
}

