/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import JP.ac.osaka_u.ender.util.regex.MatchInfo;
import JP.ac.osaka_u.ender.util.regex.RegExp;
import java.awt.Component;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.Prefs;
import muffin.filter.DecafFilter;
import muffin.filter.DecafFrame;

public class Decaf
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    DecafFrame frame;
    private RegExp javaScriptTags;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
        try {
            this.javaScriptTags = new RegExp("^a|input|body|form|area|select|frameset$");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putBoolean("Decaf.noJavaScript", true);
        prefs.putBoolean("Decaf.noJava", false);
        prefs.setOverride(bl);
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new DecafFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        DecafFilter decafFilter = new DecafFilter(this);
        decafFilter.setPrefs(this.prefs);
        return decafFilter;
    }

    public boolean isJavaScriptTag(String string) {
        MatchInfo matchInfo = this.javaScriptTags.match(string);
        return matchInfo != null;
    }

    void save() {
        this.manager.save(this);
    }

    void process(String string) {
        if (this.frame != null) {
            this.frame.text.append(string);
        }
    }
}

