/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import UK.co.demon.asmodeus.util.MultiSearchReader;
import UK.co.demon.asmodeus.util.MultiSearchResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import muffin.ContentFilter;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;
import muffin.filter.Glossary;

public class GlossaryFilter
implements ContentFilter {
    Prefs prefs;
    Glossary factory;
    InputStream in;
    OutputStream out;

    public GlossaryFilter(Glossary glossary) {
        this.factory = glossary;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        String string = reply.getHeaderField("Content-type");
        return string != null && string.startsWith("text/html");
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void run() {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            object = new byte[1024];
            while ((n = this.in.read((byte[])object, 0, ((byte[])object).length)) > 0) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (Exception exception) {}
        object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream2);
        Enumeration enumeration = this.factory.keys();
        MultiSearchReader multiSearchReader = new MultiSearchReader(enumeration, false, outputStreamWriter);
        try {
            MultiSearchResult multiSearchResult = new MultiSearchResult(-1, " ");
            boolean bl = false;
            while (multiSearchResult != null) {
                multiSearchResult = multiSearchReader.search(multiSearchResult.getOffset() + multiSearchResult.getMatch().length(), bufferedReader);
                if (multiSearchReader.getTagStatus() == 2 && multiSearchResult != null) {
                    outputStreamWriter.write(multiSearchResult.getMatch());
                    continue;
                }
                if (multiSearchResult == null) continue;
                outputStreamWriter.write("<a href=\"");
                outputStreamWriter.write(this.factory.lookup(multiSearchResult.getMatch()));
                outputStreamWriter.write("\">");
                outputStreamWriter.write(multiSearchResult.getMatch());
                outputStreamWriter.write("</a>");
            }
            ((Writer)outputStreamWriter).close();
            byteArrayOutputStream2.writeTo(this.out);
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

