/*
 * Decompiled with CFR 0.152.
 */
package muffin.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import muffin.html.Tag;

public class HtmlTokenizer
extends PushbackInputStream {
    public static final int TT_EOF = -1;
    public static final int TT_TAG = -2;
    public static final int TT_TEXT = -4;
    public static final int TT_COMMENT = -8;
    private final int initialSize = 512;
    private byte[] buf;
    private int offset;
    private int[] bad = new int[]{62, 60, 62};
    private int badIndex;

    public HtmlTokenizer(InputStream inputStream) {
        super(inputStream);
        this.buf = new byte[512];
    }

    public void writeToken(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.offset);
    }

    public void writeTag(Tag tag, OutputStream outputStream) throws IOException {
        if (tag.isModified()) {
            String string = tag.toString();
            outputStream.write(string.getBytes(), 0, string.length());
            return;
        }
        outputStream.write(this.buf, 0, this.offset);
    }

    public String getTokenValue() {
        return new String(this.buf, 0, this.offset);
    }

    public Tag getTag() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block7: while (n < this.offset) {
            switch (this.buf[++n]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 62: {
                    continue block7;
                }
            }
        }
        n2 = n;
        block8: while (n2 < this.offset) {
            switch (this.buf[++n2]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    n3 = n2 + 1;
                    break block8;
                }
                case 62: {
                    n3 = -1;
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        Tag tag = new Tag();
        tag.name = new String(this.buf, n, n2 - n).toLowerCase();
        if (n3 > 0) {
            tag.contents = this.buf;
            tag.contentsIndex = n3;
            tag.contentsEnd = this.offset - 1;
        }
        return tag;
    }

    public int getToken() throws IOException {
        int n;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        this.offset = 0;
        while ((n = this.read()) != -1) {
            if (n2 != -8) {
                if (bl) {
                    if (n == n3) {
                        bl = false;
                    } else if (n == this.bad[this.badIndex]) {
                        ++this.badIndex;
                        if (this.badIndex == this.bad.length) {
                            this.badIndex = 0;
                            bl = false;
                            System.out.println(String.valueOf(this.getClass().getName()) + " Bad HTML!");
                        }
                    }
                } else if (n == 60) {
                    if (n2 != 0) {
                        this.unread(n);
                        return n2;
                    }
                    n2 = -2;
                } else if (n2 == -2 && (n == 34 || n == 39)) {
                    bl = true;
                    n3 = n;
                } else if (n2 == 0) {
                    n2 = -4;
                }
            }
            if (this.offset == this.buf.length) {
                byte[] byArray = this.buf;
                this.buf = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, this.buf, 0, this.offset);
            }
            this.buf[this.offset++] = (byte)n;
            if (n2 == -2 && this.offset == 4 && this.buf[0] == 60 && this.buf[1] == 33 && this.buf[2] == 45 && this.buf[3] == 45) {
                n2 = -8;
            }
            if (n == 62 && !bl && (n2 == -2 || n2 == -8) && (n2 != -8 || this.buf[this.offset - 1] == 62 && this.buf[this.offset - 2] == 45 && this.buf[this.offset - 3] == 45)) break;
        }
        if (n2 == 0) {
            return -1;
        }
        return n2;
    }
}

